// Start Settings
$altitudeBarWidth = 99;     // Width
$altitudeBarMax = 300;      // Max Value
// End Settings

package altitudeBar {
    function NetBarHud::infoUpdate(%this, %ping, %packetLoss, %sendPackets, %sendBytes, %receivePackets, %receiveBytes) {
        parent::infoUpdate(%this, %ping, %packetLoss, %sendPackets, %sendBytes, %receivePackets, %receiveBytes);
        %altitude = getControlObjectAltitude();
        if (%altitude > $altitudeBarMax)
            %altitude = $altitudeBarMax;
        altitudeBarBitmap.setExtent(%altitude * $altitudeBarWidth / $altitudeBarMax,"8");
    }
    
    function LoadingGui::onWake(%this) {
        parent::onWake(%this);
        if (!isObject(altitudeBarFrame))
            setupAltitudeBar();
    }
};

function setupAltitudeBar() {
    new GuiControl(altitudeBarFrame) {
        profile = "GuiDefaultProfile";
        horizSizing = "left";
        vertSizing = "bottom";
        position = "0 0";
        extent = $altitudeBarWidth SPC "8";
        minExtent = "8 8";
        visible = "1";
        opacity = "1.0";

        new HudBitmapCtrl(altitudeBarBitmap) {
            profile = "GuiButtonProfile";
            horizSizing = "left";
            vertSizing = "bottom";
            position = "0 0";
            extent = "0 8";
            minExtent = "0 8";
            visible = "1";
            frameColor = "0 0 0 0";
            opacity = "0.5";
            bitmap = "altitudeBar.png";
        };
    };
    playgui.add(altitudeBarFrame);
    if (isObject(HM) && isObject(HudMover))
        hudmover::addhud(altitudeBarFrame, "Altitude Bar");
}

activatePackage(altitudeBar);
