// Start Settings
$altitudeBarLargeHeight = 300;          // Height
$altitudeBarLargeWidth = 20;            // Width
$altitudeBarLargeMax = 300;             // Max Value
$altitudeBarLargeIncrement = 25;        // Increment
$altitudeBarTextColor = "255 122 0";    // Number Color (red green blue [alpha otional]) (decimal 0-255)
$altitudeBarLineColor = "0 0 0";        // Line Color (reg green blue [alpha optional]) (decimal 0-255)
// End Settings

$altitudeBarLargeMaxReal = $altitudeBarLargeMax + $altitudeBarLargeIncrement;
$altitudeBarLargeLineText = "";
$altitudeBarLargeOn = true;

package altitudeBarLarge {
    function NetBarHud::infoUpdate(%this, %ping, %packetLoss, %sendPackets, %sendBytes, %receivePackets, %receiveBytes) {
        parent::infoUpdate(%this, %ping, %packetLoss, %sendPackets, %sendBytes, %receivePackets, %receiveBytes);
        %altitude = getControlObjectAltitude();
        if (%altitude > $altitudeBarLargeMax)
            %altitude = $altitudeBarLargeMax;
        altitudeBarLargeBitmap.setPosition("25",$altitudeBarLargeHeight - (%altitude * $altitudeBarLargeHeight / $altitudeBarLargeMaxReal) - 6);
        altitudeBarLargeBitmap.setExtent($altitudeBarLargeWidth,%altitude * $altitudeBarLargeHeight / $altitudeBarLargeMaxReal);
    }
    
    function LoadingGui::onWake(%this) {
        parent::onWake(%this);
        if (!isObject(altitudeBarLargeFrame))
            setupAltitudeBarLarge();
    }
    
    function clientCmdVehicleMount() {
        parent::clientCmdVehicleMount();
        passengerKeys.copyBind(moveMap, altitudeBarLargeToggle);
    }

    function clientCmdSetWeaponryVehicleKeys() {
        parent::clientCmdSetWeaponryVehicleKeys();
        passengerKeys.copyBind(moveMap, altitudeBarLargeToggle);
	}
};

function altitudeBarLargeToggle(%val) {
    if (%val) {
        $altitudeBarLargeOn = !$altitudeBarLargeOn;
        if ($altitudeBarLargeOn)
            addMessageHudLine("\c3Altitude Bar: \c0On");
        else
            addMessageHudLine("\c3Altitude Bar: \c0Off");
        altitudeBarLargeFrame.setVisible($altitudeBarLargeOn);
    }
}

function altitudeBarLargeReload() {
    exec("scripts/autoexec/altitudeBarLarge.cs");
    altitudeBarLargeFrame.delete();
    makeAltitudeBarLarge();
    hudmover::sethuds();
}

function makeAltitudeBarLarge() {
    new GuiControlProfile("altitudeBarLargeText") {
        fontType = "Univers Condensed";
        fontSize = 16;
        fontColor = $altitudeBarTextColor;
        justify = "right";
    };
    
    new GuiControlProfile("altitudeBarLargeLine") {
        fontType = "Univers Condensed";
        fontSize = 16;
        fontColor = $altitudeBarLineColor;
        justify = "left";
    };

    new GuiControl(altitudeBarLargeFrame) {
        profile = "GuiChatBackProfile";
        horizSizing = "left";
        vertSizing = "top";
        position = "0 0";
        extent = 25 + $altitudeBarLargeWidth SPC $altitudeBarLargeHeight;
        minExtent = "8 8";
        visible = "1";
        opacity = "1.0";

        new HudBitmapCtrl(altitudeBarLargeBitmap) {
            profile = "GuiButtonProfile";
            horizSizing = "left";
            vertSizing = "top";
            position = "25" SPC $altitudeBarLargeHeight;
            extent = $altitudeBarLargeWidth SPC "0";
            minExtent = "50 0";
            visible = "1";
            frameColor = "0 0 0 0";
            opacity = "0.5";
            bitmap = "altitudeBar.png";
        };
    };

    for (%i = 0; %i <= $altitudeBarLargeWidth; %i += 6)
        $altitudeBarLargeLineText = $altitudeBarLargeLineText @ "_";

    for (%i = 0; %i <= $altitudeBarLargeMaxReal; %i += $altitudeBarLargeIncrement) {
        $altitudeBarLargeLine[%i] = new GuiTextCtrl() {
            profile = "altitudeBarLargeLine";
            horizSizing = "right";
            vertSizing = "top";
            position = "25" SPC $altitudeBarLargeHeight - 22 - (%i / $altitudeBarLargeMaxReal * $altitudeBarLargeHeight);
            extent = $altitudeBarLargeWidth SPC "16";
            visible = "1";
            text = $altitudeBarLargeLineText;
        };

        $altitudeBarLargeText[%i] = new GuiTextCtrl() {
            profile = "altitudeBarLargeText";
            horizSizing = "right";
            vertSizing = "top";
            position = "0" SPC $altitudeBarLargeHeight - 16 - (%i / $altitudeBarLargeMaxReal * $altitudeBarLargeHeight);
            extent = "23 16";
            visible = "1";
            text = %i;
        };

        altitudeBarLargeFrame.add($altitudeBarLargeLine[%i]);
        altitudeBarLargeFrame.add($altitudeBarLargeText[%i]);
    }

    playgui.add(altitudeBarLargeFrame);
}

function setupAltitudeBarLarge() {
    makeAltitudeBarLarge();
    if (isObject(HM) && isObject(HudMover))
        hudmover::addhud(altitudeBarLargeFrame, "Altitude Bar Large");

    $RemapName[$RemapCount]="\c5Altitude Bar";
    $RemapCmd[$RemapCount]="altitudeBarLargeToggle";
    $RemapCount++;
}
activatePackage(altitudeBarLarge);
