////////////////////////////////////////////////////////////
// File:	TV.cs
// Version:	1.3
// Author:	Runar
// Credits:	Freaky, Gold for beta-tests.
// Info:	Observe your flag-carrier in fullscreen with
//		a keypress.
//
// EXTRA:       This is the Stripped version, ported by
//              dumb ole EvItA.  This should work with
//		Presto or Writers packs as well.
//
// CHANGES:     You can now view up to 16 players on your team.
//
//              This script is flag tracking independant; meaning,
//              you can run it with ANY flag tracking hud.
//
////////////////////////////////////////////////////////////

editActionmap("playmap.sae");

// Bind to obs current (or last) flagcarrier
bindCommand(keyboard0, make, "f6", TO, "TV::Carrier();");
bindCommand(keyboard0, break, "f6", TO, "TV::DeActivate();");

// Bind to activate menu to select player to obs.
bindCommand(keyboard0, make, "f11", TO, "TV::Menu();");
bindCommand(keyboard0, break, "f11", TO, "");

// Bind to re-obs last selected player
bindCommand(keyboard0, make, "f12", TO, "TV::Selected();");
bindCommand(keyboard0, break, "f12", TO, "TV::DeActivate();");

function TV::Menu()
{
	%menu = "<JL><F0>TV Select player:\n";
	%count = 0;

	// New keymap
	NewActionMap("TV.sae");

        %MyTeamID = Client::GetTeam(getManagerID());

	for(%clientId = 2048 ; %clientId < 2180 ; %clientId++)
	{
           %TempTeamID = Client::GetTeam(%clientId);
		if(Client::GetName(%clientId) != "" && %TempTeamID == %MyTeamID)
		{
			%count++;

			if(%count <= 9)
			$customKey = %count;
			else if(%count == 10)
			$customKey = "a";
			else if(%count == 11)
			$customKey = "b";
			else if(%count == 12)
			$customKey = "c";
			else if(%count == 13)
			$customKey = "d";
			else if(%count == 14)
			$customKey = "e";
			else if(%count == 15)
			$customKey = "f";
			else if(%count == 16)
			$customKey = "g";

                        $TV::TTName = Client::GetName(%clientId);
			%menu = %menu @ "\n<JL><F2>" @ $customKey @ ". <F1>" @ $TV::TTName;

			bindCommand(keyboard0, make, $customKey, TO, "TV::Select(" @ %clientId @ ");");
			bindCommand(keyboard0, break, $customKey, TO, "TV::DeActivate();");
		}
	}

	// Load keymap
	PushActionMap("TV.sae");

	// CP the menu
	remoteCP(2048, %menu, 999);
}

function TV::Select(%clientId)
{
	// Clear CP
	remoteCP(2048, "", 0.1);

	$TV::Selected = %clientId;
        $TV::TTName = Client::GetName(%clientId);
	echo("TV Selected: " @ $TV::TTName);

	TV::Activate($TV::Selected);
}

function TV::Selected()
{
	TV::Activate($TV::Selected);
}

function TV::Carrier()
{
        $TV::TTName = $CurrentFlagCarrier;
	TV::Activate($TV::FlagCarrier);
}

function TV::Activate(%clientId)
{
	// Can't obs if there's no carrier..
	if(%clientId == "")
	{
		$TV::Active = "False";
		remoteBP(2048, "<JC><F1>Illegal clientId, unable to observe!", 2);
		return;
	}

	// Delete the entire CommandGui
	if(isObject("CommandGui"))
		renameObject("CommandGui", "_CommandGui");

	// Add CMDObserve if it isn't there..
	if(!isObject("PlayGui/ObsTV"))
	{
		addToSet(PlayGui, newObject("ObsTV", FearGui::CMDObserve, 0, 0, 1, 1));
	}

	// Go to CommandMode
	remoteEval(2048, CommandMode);

	// Force full bandwidth
	RemoteEval(2048, "scom", -1);

	// Turn off the cursor
	Schedule("CursorOff(mainwindow);", 0.3);

	// Enable observer mode
	Client::ToggleCmdObserver("True");

	// Observe flag-carrier or team-mate
	Client::cmdObservePlayer(%clientId);

	// Show who we are obsing
	remoteBP(2048, "<JC><F1>Observing: <F2>" @ $TV::TTName, 999);

	// Just to make sure..
	$TV::Active = "True";
}

function TV::DeActivate()
{
	// Unload keymap
	PopActionMap("TV.sae");

	Client::ToggleCmdObserver("False");

	remoteEval(2048, PlayMode);

	if($TV::Active)
		deleteObject("PlayGui/ObsTV");

	renameObject("_CommandGui", "CommandGui");

	remoteBP(2048, "", 0.1);

	$TV::Active = "False";
}

function TV::FlagTaken(%client, %msg)
{

	if(%client)
	return;

	if(String::findSubStr(%msg, "You ") != -1)
	return;

	%crackhead = String::findSubStr(%msg, " took the ");

	if (%crackhead > 0)
	{
	      $CurrentFlagCarrier = String::getSubStr(%msg, 0, %crackhead);
              %MyTeamID = Client::GetTeam(getManagerID());
              %TempID::ClientID = getClientByName($CurrentFlagCarrier);
              %TempID = Client::GetTeam(%TempID::ClientID);
	      if(%MyTeamID == %TempID){
	      $TV::FlagCarrier = getClientByName($CurrentFlagCarrier);
	      return;}
	}
}

Event::Attach(eventClientMessage, TV::FlagTaken);
