// #name	= Pilot
// #version 	= 1.0
// #date 	= 2001-09-24
// #author 	= Runar
// #email 	= runar@vsdn.org
// #web 	= http://www.vsdn.org
// #description	= Pilot-script
// #status 	= Release


if($pref::Pilot::Sensitivity[Hoverbike] $= "")
{
	$pref::Pilot::Sensitivity[Hoverbike]	= "2 2" ;
	$pref::Pilot::DeadZone[Hoverbike]	= false ;

	$pref::Pilot::Sensitivity[Assault]	= "4 4";
	$pref::Pilot::DeadZone[Assault]		= false ;

	$pref::Pilot::Sensitivity[MPB]		= "6 6" ;
	$pref::Pilot::DeadZone[MPB]		= false ;

	$pref::Pilot::Sensitivity[Shrike]	= "6 4" ;
	$pref::Pilot::DeadZone[Shrike]		= false ;

	$pref::Pilot::Sensitivity[Bomber]	= "6 4" ;
	$pref::Pilot::DeadZone[Bomber]		= false ;

	$pref::Pilot::Sensitivity[HAPC]		= "6 4";
	$pref::Pilot::DeadZone[HAPC]		= false ;

	$pref::Pilot::Sensitivity[Default]	= "2 2";
	$pref::Pilot::DeadZone[Default]		= false ;
}

if(!isObject(Pilot))
{
	new ScriptObject(Pilot)
	{
		class = Pilot;
	};
}

function Pilot::Sens(%this, %yaw, %pitch, %useDzone)
{
	if(!Pilot.driving)
	{
		return;
	}

	if(!%yaw || !%pitch)
	{
		%yaw = getWord($pref::Pilot::Sensitivity[Default], 0);
		%pitch = getWord($pref::Pilot::Sensitivity[Default], 1);

		if(!%yaw || !%pitch)
		{
			echo("Pilot sensitivity setting NOT found/set!!");
			return;
		}
	}

	if(%yaw == 1 && %pitch == 1)
		return;

	// Yaw bind
	%bind = moveMap.getBinding(yaw);
	%device = getField(%bind, 0);
	%action = getField(%bind, 1);
	%flags = Pilot.Flags(moveMap.isInverted(%device, %action), 0, %useDzone);


	if(%useDzone)
	{
		passengerKeys.bind(%device, %action, %flags, moveMap.getDeadZone(%device, %action), moveMap.getScale(%device, %action) * %yaw, yaw);
	}
	else
	{
		passengerKeys.bind(%device, %action, %flags, moveMap.getScale(%device, %action) * %yaw, yaw);
	}

	// Pitch bind
	%bind = moveMap.getBinding(pitch);
	%device = getField(%bind, 0);
	%action = getField(%bind, 1);
	%flags = Pilot.Flags(moveMap.isInverted(%device, %action), $pref::Vehicle::InvertYAxis, %useDzone);

	if(%useDzone)
	{
		passengerKeys.bind(%device, %action, %flags, moveMap.getDeadZone(%device, %action), moveMap.getScale(%device, %action) * %yaw, pitch);
	}
	else
	{
		passengerKeys.bind(%device, %action, %flags, moveMap.getScale(%device, %action) * %yaw, pitch);
	}
}

function Pilot::Flags(%this, %inverted, %vInverted, %deadzone)
{
	%flags[0, 0, 0] = "S";
	%flags[0, 0, 1] = "SD";
	%flags[0, 1, 0] = "SI";
	%flags[0, 1, 1] = "SDI";
	%flags[1, 0, 0] = "SI";
	%flags[1, 0, 1] = "SDI";
	%flags[1, 1, 0] = "S";
	%flags[1, 1, 1] = "SD";

	return %flags[%inverted, %vInverted, %deadzone];
}

package PilotPkg
{
	function ClientCmdSetHudMode(%mode, %type, %node)
	{
		parent::ClientCmdSetHudMode(%mode, %type, %node);

		if(getWord(%mode, 1) $= "Pilot")
			Pilot.Sens(getWord($pref::Pilot::Sensitivity[%type], 0), getWord($pref::Pilot::Sensitivity[%type], 1), $pref::Pilot::DeadZone[%type]);
	}

	function clientCmdSetPilotVehicleKeys()
	{
		parent::clientCmdSetPilotVehicleKeys();
		Pilot.driving = true;
	}

	function clientCmdSetPassengerVehicleKeys()
	{
		parent::clientCmdSetPassengerVehicleKeys();
		Pilot.driving = false;
	}

};

activatePackage(PilotPkg);
