//QSpeedHud
//{NQP!}Qing


//$Pref::Qing::QSpeedHudUseKPH = false;		
//change to 'true' and remove the // at the beginning of the line if you want speed displayed in kph instead of m/s

$SpeedXPos = getword($pref::Video::resolution, 0) - 72;
$SpeedYPos = 200;
$SpeedHudPos = $SpeedXPos @ " " @ $SpeedYPos;




new GuiControlProfile ("QSpeedHudProfile") {
	fontType = "Univers Condensed";
	fontSize = 16;
	fontColor = "128 128 0"; 
	autoSizeWidth = false;
	autoSizeHeight = true;
};




function QSpeedHudCreate()
{
	if(isObject($QSpeedHud))
		{
		echo("Deleting Existing QSpeedHud");
		$QSpeedHud.delete();
		}
	cdecho("Creating New QSpeedHud");
	$QSpeedHud = new ShellFieldCtrl(QSpeedHudShell) 
		{
		profile = "GuiClockBackProfile";
		horizSizing = "center";
		vertSizing = "top";
		position = $SpeedHudPos;
		extent = "72 28";
		minExtent = "16 18";
		visible = "1";
		helpTag = "0";

		new GuiMLTextCtrl(qspeeddisplay) 
			{
			profile = "QSpeedHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "0 0";
			extent = "64 12";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			text = "<just:center><color:2cacb5>Speed: <color:d0c07c>";
			};

		new GuiMLTextCtrl(qaltdisplay) 
			{
			profile = "QSpeedHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "0 12";
			extent = "64 12";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			text = "<just:center><color:2cacb5>Speed: <color:d0c07c>";
			};
		};
	PlayGui.add($QSpeedHud);
	QSpeedHudUpdate();
}


function QSpeedHudUpdate()
{
	if(isObject($QSpeedHud))
		{
		$SpeedXPos = getword($pref::Video::resolution, 0) - 72;
		$SpeedYPos = 200;
		$SpeedHudPos = $SpeedXPos @ " " @ $SpeedYPos;
		if(QSpeedHudShell.position !$= $SpeedHudPos)
			QSpeedHudCreate();
		}
	QGetSpeed();
	$SpeedHudScheduler = schedule(200, 0, "QSpeedHudUpdate");
}


function QGetSpeed()
{
	%vel = getControlObjectSpeed();
	%vel = mfloor(%vel);
	%alt = getControlObjectAltitude();
	if(%vel == 0)
		qspeeddisplay.setValue("<color:808080>STATIONARY");		
	else
		{
		%truevel = %vel;
		if($Pref::Qing::QSpeedHudUseKPH)
			%vel = mfloor(%vel * 2.7777777);
		if(%truevel > 50)
			qspeeddisplay.setValue("<color:FFFFFF>SPEED: " @ %vel @ " !!");
		else
			qspeeddisplay.setValue("<color:808080>SPEED: " @ %vel);
		}


	%drop = $oldAlt[3] - %alt;
	$oldAlt[5] = $oldAlt[4];
	$OldAlt[4] = $oldAlt[3];
	$OldAlt[3] = $oldAlt[2];
	$OldAlt[2] = $OldAlt[1];
	$OldAlt[1] = %alt;
//	if(%vel == 0)
//		{
//		qaltdisplay.setValue(  "<color:808080>ALT:     " @ %alt);	//gray
//		return;
//		}
	if(%alt == 0)
		{
		qaltdisplay.setValue("");
		return;
		}
	if(%drop > 8)
		{
		qaltdisplay.setValue(  "<color:FF0000>ALT:     " @ %alt);	//red
		alxPlay(sButtonOver,0,0,0);
		return;
		}
	if(%drop > 6)
		{
		qaltdisplay.setValue(  "<color:FFFF00>ALT:     " @ %alt);	//yellow
		alxPlay(sButtonDown,0,0,0);
		return;
		}
	if(%drop > 4)
		{
		qaltdisplay.setValue(  "<color:808080>ALT:     " @ %alt);	//grey
		return;
		}
	if(%drop > 0)
		{
		qaltdisplay.setValue(  "<color:00FF00>ALT:     " @ %alt);	//green
		return;
		}
	if(%drop == 0)
		{
		qaltdisplay.setValue(  "<color:808080>ALT:     " @ %alt);	//gray
		return;
		}

	qaltdisplay.setValue(  "<color:FFFFFF>ALT:     " @ %alt);		//white
}


function QSpeedHudKill()
{
	cancel($SpeedHudScheduler);
	$QSpeedHud.delete();
}

package QSpeedHudLoad 
{ 
	function PlayGui::onWake(%this) 
		{
		$QSpeedHudStarter = schedule(1500, 0, "QSpeedHudCreate");
		parent::onWake(%this);
		}
};


activatePackage(QSpeedHudLoad);
