//QBattleFov.cs
//by {NQP!}Qing
//qing@netquickposse.com
//http://netquickposse.com
//Release, 6/1/01 - Tribes 2


//Configuration
moveMap.bind(keyboard0, "w", qsetfov);		//the key that toggles the zoomed 'battle mode'
moveMap.bind(keyboard0, "alt w", qsetwide);	//the key that toggles the wide 'sentry mode'

if(!$Pref::Qing::NormalFov)
	{
	$Pref::Qing::ZoomedFov = 60;
	$Pref::Qing::WideFov = 120;
	$Pref::Qing::NormalFov = 100;
	}

//true = zoom when firing this weapon
$Pref::Qing::AutoFov[SniperRifle] = false;
$Pref::Qing::AutoFov[Chaingun] = false;
$Pref::Qing::AutoFov[Disc] = false;

//true = zoom when selecting this weapon
$Pref::Qing::ArmFov[SniperRifle] = false;

$Pref::Qing::AutoGamma[Damnation] = 1.3;	//multiple that is applied to normal gamma level for this map
$Pref::Qing::AutoGamma[Firestorm] = 1.3;
$Pref::Qing::AutoGamma["DeadlyBirdsSong_x"] = 1.3;
$Pref::Qing::AutoGamma[Pandemonium] = 1.3;

$Pref::Qing::Auto3rd = 1;



function qsetfov(%on)
{
	if(%on) 
		{
		if($Pref::Qing::AutoGamma[$MissionName])
			videoSetGammaCorrection($Pref::Qing::AutoGamma[$MissionName] * $pref::OpenGL::gammaCorrection);
		else
			videoSetGammaCorrection($pref::OpenGL::gammaCorrection);
		if($QWide)
			{
			QSetWide(true);
			if($Pref::Qing::Auto3rd && !$FirstPerson)
				toggleFirstPerson(true);
			return;
			}
		if(!$Qzoomed)
			{
			$pref::player::defaultfov = $Pref::Qing::ZoomedFov;
			togglezoom(false);
			$Qzoomed = true;
			$Qwide = false;
			}
		else
			{
			$pref::player::defaultfov = $Pref::Qing::NormalFov;
			togglezoom(false);
			$Qzoomed = false;
			$QWide = false;
			}
		BattleHudUpdate();
		}
}


function qsetwide(%on)
{
	if(%on) 
		{
		if($Pref::Qing::AutoGamma[$MissionName])
			videoSetGammaCorrection($Pref::Qing::AutoGamma[$MissionName] * $pref::OpenGL::gammaCorrection);
		else
			videoSetGammaCorrection($pref::OpenGL::gammaCorrection);

		if(!$Qwide)
			{
			$pref::player::defaultfov = $Pref::Qing::WideFov;
			togglezoom(false);
			$QWide = true;
			$Qzoomed = false;
			if($Pref::Qing::Auto3rd && $FirstPerson)
				toggleFirstPerson(true);
			}
		else
			{
			$pref::player::defaultfov = $Pref::Qing::NormalFov;
			togglezoom(false);
			$Qwide = false;
			$Qzoomed = false;
			if($Pref::Qing::Auto3rd && !$FirstPerson)
				toggleFirstPerson(true);
			}
		BattleHudUpdate();
		}
}


$BattleXPos = getword($pref::Video::resolution, 0)/2 - 40;
$BattleYPos = getword($Pref::video::resolution, 1)/2 - 60;
$BattleHudPos = $BattleXPos @ " " @ $BattleYPos;

new GuiControlProfile ("BattleHudProfile") 
{
	fontType = "Univers Condensed";
	fontSize = 16;
	fontColor = "128 128 0"; 
	autoSizeWidth = false;
	autoSizeHeight = true;
};




function BattleHudCreate()
{
	if(isObject($BattleHud))
		{
		echo("Deleting Existing BattleHud");
		$BattleHud.delete();
		}

	cdecho("Creating New BattleHud");
	$BattleHud = new ShellFieldCtrl(BattleHudShell) 
		{
//		profile = "GuiClockBackProfile";
		profile = "";
		horizSizing = "center";
		vertSizing = "top";
		position = $BattleHudPos;
		extent = "80 18";
		minExtent = "16 18";
		visible = "1";
		helpTag = "0";

//		new GuiMLTextCtrl(BattledisplayShadow) 
//			{
//			profile = "BattleHudProfile";
//			horizSizing = "center";
//			vertSizing = "top";
//			position = "1 1";
//			extent = "80 18";
//			minExtent = "8 8";
//			visible = "1";
//			setFirstResponder = "0";
//			modal = "1";
//			lineSpacing = "2";
//			allowColorChars = "1";
//			maxChars = "-1";
//			};

		new GuiMLTextCtrl(Battledisplay) 
			{
			profile = "BattleHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "0 0";
			extent = "80 18";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		};
	PlayGui.add($BattleHud);
	BattleHudUpdate();
}


function BattleHudUpdate()
{
	$BattleXPos = getword($pref::Video::resolution, 0)/2 - 40;
	$BattleYPos = getword($Pref::video::resolution, 1)/2 - 60;
	$BattleHudPos = $BattleXPos @ " " @ $BattleYPos;
	if(BattleHudShell.position !$= $BattleHudPos)
		BattleHudCreate();

	if($Qzoomed)
		{
//		BattledisplayShadow.setvalue("<just:center><color:000000>BATTLE MODE");
		Battledisplay.setvalue("<just:center><color:ff0000>BATTLE MODE");
		$BattleClear = schedule(2000, 0, "BattleClear");
		}
	else
		if($Qwide)
			{
//			BattledisplayShadow.setvalue("<just:center><color:000000>SENTRY MODE");
			Battledisplay.setvalue("<just:center><color:FFFF00>SENTRY MODE");
			$BattleClear = schedule(2000, 0, "BattleClear");
			}
	else
		{
		Battledisplay.setvalue("<just:center><color:00dd00>NORMAL MODE");
//		BattledisplayShadow.setvalue("<just:center><color:000000>NORMAL MODE");
		$BattleClear = schedule(2000, 0, "BattleClear");
		}
//	$BattleHudScheduler = schedule(10000, 0, "BattleHudUpdate");
}

function BattleClear()
{
	Battledisplay.setvalue("");
}

package BattleHudLoad 
{ 
	function PlayGui::onWake(%this) 
		{
		$BattledHudStarter = schedule(1500, 0, "BattleHudCreate");
		parent::onWake(%this);
		}

	function mousefire()
		{
		if($QWide && !$Pref::Qing::Auto3rd)
			QSetFov(true);

		if(($mvTriggerCount[0] / 2) == mfloor($mvTriggerCount[0] / 2))	//even number means not firing
			{
			if($Pref::Qing::AutoFov[$QCurrentWeapon])
				{
				$pref::player::defaultfov = $Pref::Qing::ZoomedFov;
				togglezoom(false);
				$Qzoomed = true;
				$Qwide = false;
				}
			}
		else
			{
			if($Pref::Qing::AutoFov[$QCurrentWeapon])
				{
				$pref::player::defaultfov = $Pref::Qing::NormalFov;
				togglezoom(false);
				$Qzoomed = false;
				$Qwide = false;
				}
			}
		parent::MouseFire();
		}

	function clientCmdSetWeaponsHudActive(%slot) 
		{
		$QOldWeapon = $QCurrentWeapon;
		$QCurrentWeapon = $WeaponNames[%slot];
		parent::clientCmdSetWeaponsHudActive(%slot);
		if($Pref::Qing::ArmFov[$QCurrentWeapon])
			{
			if(1) 
				{
				if($MissionName $= "Firestorm")
					videoSetGammaCorrection(1); 
				$pref::player::defaultfov = $Pref::Qing::ZoomedFov;
				togglezoom(false);
				$Qzoomed = true;
				$Qwide = false;
				BattleHudUpdate();
				}
			else
				{
				if(!$Qwide)
					{
					if(	$MissionName $= "Firestorm" ||
						$MissionName $= "Damnation")
							videoSetGammaCorrection( $pref::OpenGL::gammaCorrection ); 
					$pref::player::defaultfov = $Pref::Qing::NormalFov;
					togglezoom(false);
					$Qzoomed = false;
					$QWide = false;
					BattleHudUpdate();
					}
				}
			}
				if($Pref::Qing::ArmFOV[$QOldWeapon])
					{
					$pref::player::defaultfov = $Pref::Qing::NormalFov;
					togglezoom(false);
					$Qzoomed = false;
					$Qwide = false;
					BattleHudUpdate();
					}

		}



};
activatePackage(BattleHudLoad);


