error("************* QDEMOLOAD LOADED");

function qDemoLoad(%file)
{
   %file = "recordings/" @ %file @ ".rec";
   %verLen = getDemoVersionLength(%file);


	if(!isfile(%file))
		{
		error("Demo File '" @ %file @ "' does not exist.  Cannot play demo.");
		return;
		}
	else
error("DEMO FILE EXISTS");

   Canvas.pushDialog(DemoLoadProgressDlg);
   if(playDemo(%file))
   {
      // do not allow new sources to have a force feedback effect
      alxEnableForceFeedback(false);

      resetGameState();
      Canvas.popDialog(DemoLoadProgressDlg);
      Canvas.popDialog(RecordingsDlg);   
      Canvas.setContent(PlayGui);
      loadDemoSettings();

      $DemoPlaybackIndex = 5;
      $DemoPlaybackLastIndex = 5;

      // setup the global action map
      GlobalActionMap.bindCmd(keyboard, "escape", "", "stopDemoPlayback();");
      GlobalActionMap.bindCmd(keyboard, "tab", "", "toggleDemoPlaybackHud();");
      GlobalActionMap.bindCmd(keyboard, "space", "", "toggleDemoPause();");
      GlobalActionMap.bindCmd(keyboard, "numpadadd", "", "stepDemoPlaybackSpeed(1);");
      GlobalActionMap.bindCmd(keyboard, "numpadminus", "", "stepDemoPlaybackSpeed(-1);");
      $globalActionMapOnly = true;

      $DemoPlaybackProgress = 0;
      $DemoPlaybackLength = getField(%verLen, 1);

      // playback length may be 0 if recording was not clean (just set to 1min)
      if($DemoPlaybackLength == 0)
         $DemoPlaybackLength = 60000;
      
      DemoPlayback_EndTime.setValue(msToMinSec($DemoPlaybackLength));

      $DemoPlaybackIndex = 5;
      $DemoPlaybackLastIndex = 5;
      $DemoPlaybackProgress = 0;
      demoPlaybackUpdate(0);

      updateDemoPlaybackStatus();
      $qDemoLoadFile = "";	//prevents reloading game after finished
   }
   else
      MessageBoxOK("Playback Failed", "Demo playback failed for file '" @ %file @ "'.");
}

package qDemoLoad
{

	function TrainingGui::onWake( %this )
	{
		if($qDemoLoadFile $= "")
			{
			parent::onWake(%this);
			return;
			}
		else
			{
			Canvas.pushDialog(RecordingsDlg);
//			Canvas.popDialog(TrainingGui);
			qDemoLoad($qDemoLoadFile);
			}
	}
};
activatepackage(qDemoLoad);

