// odysseyACS - auto chat system - by sal9000

// ==========-------------------------------------------------------------------------------------==========
// ==========-- Begin User Edit Section ----------------------------------------------------------==========
// ==========-------------------------------------------------------------------------------------==========
//
// *NOTE* if you do NOT want a particular message, make it = "FALSE"
// example: $odysseyACSmsg["Repairing"] = "FALSE";

// the 2 colors, one for the text, and one for the object. (i.e. %name% or %time)
// valid colors are: BLUE, BLUE2, GREEN, GREEN2, GOLD, GOLD2
$odysseyACScolor["text"] = "GREEN";
$odysseyACScolor["object"] = "BLUE";

// Auto chats: customize your messages
// and place %name% where you wish the
// player/item's name to be placed.
$odysseyACSmsg["RepairDone"] = "Repairs Complete on \c2%name%.";
$odysseyACSmsg["Repairing"] = "Repairing %name%.";
$odysseyACSmsg["HitbyTeammate"] = "Watch where your shooting %name%!";
$odysseyACSmsg["ShootTeammate"] = "Sorry %name%!";

// these 2 have no 'name' so just reword
// them to your liking
$odysseyACSmsg["NoPower"] = "Our Power is Down, Repair our Generators!";
$odysseyACSmsg["StationDisabled"] = "Stations Needs Repair.";

// the friendly/enemy flag timer messages
// place %time% where you want the timer you
// specified to announce the return. (default is 10)
$odysseyACSmsg["EnemyFlagReturning"] = "Enemy Flag Returning in %time% seconds!";
$odysseyACSmsg["FriendlyFlagReturning"] = "Our Flag is Returning in %time% seconds!";

// the time remaining for flag return, to announce it.
$odysseyACSflagReturnTime = 10;

// ==========-------------------------------------------------------------------------------------==========
// ==========-- End User Edit Section ------------------------------------------------------------==========
// ==========-------------------------------------------------------------------------------------==========

// anti-spamming time in seconds *edit* remove these from public usage
$odysseyACSspamTimeRepair = 5;
$odysseyACSspamTimeTD = 10;

function odysseyACSstringParse(%name, %TAG, %object) {
	%string = $odysseyACSmsg[%name];

	%tC = $odysseyACScolor[$odysseyACScolor["text"]];
	%oC = $odysseyACScolor[$odysseyACScolor["object"]];
	%string = %tC @ %string;
	%output = strreplace(%string, %TAG, %oC@%object@%tC);

	return %output;
}

function odysseyACSen(%msg) {
	if($odysseyACSmsg[%msg] $= "FALSE") return FALSE;
	else return TRUE;
}

$odysseyACScolor["BLUE"] = "\c0";
$odysseyACScolor["GREEN"] = "\c1";
$odysseyACScolor["GOLD"] = "\c2";
$odysseyACScolor["GREEN2"] = "\c3";
$odysseyACScolor["BLUE2"] = "\c4";
$odysseyACScolor["GOLD2"] = "\c5";

function odysseyACSrepairDone() {
	if(odysseyACSen("RepairDone") $= FALSE) return;
	commandToServer('TeamMessageSent', odysseyACSstringParse("RepairDone", "%name%", $odysseyACSlastObj));
}

function odysseyACSrepairingObj(%msgType, %msgString, %object) {
	if($odysseyACSspam $= "TRUE") return;
	if(odysseyACSen("Repairing") $= FALSE) return;
	else {
		schedule(($odysseyACSspamTimeRepair * 1000), 0, "odysseyACSspam", "FALSE");
		$odysseyACSspam = TRUE;
		commandToServer('TeamMessageSent', odysseyACSstringParse("Repairing", "%name%", %object));
	}
	$odysseyACSlastObj = %object;
}

function odysseyACSspam(%bool) {
	$odysseyACSspam = %bool;
}

function odysseyACShurtTeam(%msgType, %msgString, %string) {
	%player = detag(%string);

	if($odysseyACSspam $= "TRUE") return;
	if(odysseyACSen("ShootTeammate") $= FALSE) return;
	else {
		schedule(($odysseyACSspamTimeTD * 1000), 0, "odysseyACSspam", "FALSE");
		$odysseyACSspam = TRUE;
		commandToServer('TeamMessageSent', odysseyACSstringParse("ShootTeammate", "%name%", %player));
	}
}

function odysseyACShurtByTeam(%msgType, %msgString, %string) {
	%player = detag(%string);

	if($odysseyACSspam $= "TRUE") return;
	if(!odysseyACSen("HitbyTeammate")) return;
	else {
		schedule(($odysseyACSspamTimeTD * 1000), 0, "odysseyACSspam", "FALSE");
		$odysseyACSspam = TRUE;
		commandToServer('TeamMessageSent', odysseyACSstringParse("HitbyTeammate", "%name%", %player));
	}
}

function odysseyACSdisabled() {
	if($odysseyACSspam $= "TRUE") return;
	if(odysseyACSen("StationDisabled") $= FALSE) return;
	else {
		schedule(($odysseyACSspamTimeTD * 1000), 0, "odysseyACSspam", "FALSE");
		$odysseyACSspam = TRUE;
		commandToServer('TeamMessageSent', odysseyACSstringParse("StationDisabled"));
	}
}

function odysseyACSnoPower() {
	if($odysseyACSspam $= "TRUE") return;
	if(odysseyACSen("NoPower") $= FALSE) return;
	else {
		schedule($odysseyACSspamTimeTD, 0, "odysseyACSspam", "FALSE");
		$odysseyACSspam = TRUE;
		commandToServer('TeamMessageSent', odysseyACSstringParse("NoPower"));
	}
}

function odysseyACSflagDrop(%msgType, %msgString, %string, %string1, %string2, %string3) {
	%team = detag(%string2);
	cancel($odysseyFlagTimer[%team]);
	$odysseyFlagTimer[%team] = schedule(((45-$odysseyACSflagReturnTime) * 1000), 0, odysseyACSannounceReturn, %team);
}

function odysseyACSflagTake(%msgType, %msgString, %string, %string1, %string2, %string3) {
	%team = detag(%string2);
	cancel($odysseyFlagTimer[%team]);
}

function odysseyACSflagReturn(%msgType, %msgString, %string, %string1, %string2, %string3) {
	%team = detag(%string2);
	cancel($odysseyFlagTimer[%team]);
}

function odysseyACSannounceReturn(%team) {
	if(%team $= $odysseyACSmyTeam) {
		if(odysseyACSen("FriendlyFlagReturning") $= FALSE) return;
		commandToServer('TeamMessageSent', odysseyACSstringParse("FriendlyFlagReturning", "%time%", $odysseyACSflagReturnTime));
	}
	else {
		if(odysseyACSen("EnemyFlagReturning") $= FALSE) return;
		commandToServer('TeamMessageSent', odysseyACSstringParse("EnemyFlagReturning", "%time%", $odysseyACSflagReturnTime));
	}
}

function odysseyACSgameOver() {
	cancel($odysseyFlagTimer[$odysseyACSmyTeam]);
	cancel($odysseyFlagTimer[$odysseyACSenemyTeam]);
}

function odysseyACSmyTeam(%msgType, %msgString, %teamNum) {
	$odysseyACSmyTeam = detag(%teamNum);
	if($odysseyACSmyTeam $= 1) $odysseyACSenemyTeam = 2;
	else if($odysseyACSmyTeam $= 2) $odysseyACSenemyTeam = 1;
}

package odysseyACS {

function clientCmdSetStationKeys(%inStation) {
	parent::clientCmdSetStationKeys(%inStation);

	if ( %inStation ) {}
	else {
		%currentFAV = $odysseyACScurrentFAV;
		%lastFAV = $odysseyACSlastFAV;
		%currentPACK = $odysseyACScurrentPACK;
		%lastPACK = $odysseyACSlastPACK;

		if(%currentFAV $= %lastFAV && %currentPACK $= %lastPACK) {}
		else {
			commandToServer('TeamMessageSent', "\c0["@%currentFAV@"] \c2"@%currentPACK);
			$odysseyACSlastFAV = $odysseyACScurrentFAV;
			$odysseyACSlastPACK = $odysseyACScurrentPACK;
		}
	}
}

function loadFavorite(%index, %echo) {
	parent::loadFavorite(%index, %echo);

	$odysseyACSLastFav = $odysseyACSCurrentFav;
	$odysseyACSCurrentFav = $pref::FavNames[%index];
	$odysseyACSCurrentPack = "";
}

function addQuickPackFavorite(%pack, %item) {
	parent::addQuickPackFavorite(%pack, %item);

	$odysseyACSlastPACK = $odysseyACScurrentPACK;
	$odysseyACScurrentPACK = %pack;
}

function DispatchLaunchMode() {

	addMessageCallback('MsgRepairPackDone', odysseyACSrepairDone);
	addMessageCallback('MsgRepairPackRepairingObj',odysseyACSrepairingObj);

	addMessageCallback('MsgDamagedTeam', odysseyACShurtTeam);
	addMessageCallback('MsgDamagedByTeam', odysseyACShurtByTeam);

	addMessageCallback('msgStationNoPower', odysseyACSnoPower);
	addMessageCallback('msgStationDisabled', odysseyACSdisabled);

	addMessageCallback('MsgCTFFlagDropped', odysseyACSflagDrop);
	addMessageCallback('MsgCTFFlagTaken', odysseyACSflagTake);
	addMessageCallback('MsgCTFFlagReturned', odysseyACSflagReturn);

	addMessageCallback('MsgCheckTeamLines', odysseyACSmyTeam);

	addMessageCallback('MsgGameOver', odysseyACSgameOver);


	parent::DispatchLaunchMode();
}

};
activatePackage(odysseyACS);

// atl nfo
$odysseyACSversion = "2.0 (stable)";
$odysseyACSinfo = "auto chat system";