// #autoload
// #category = MoopScript
// #name = Flag Status CTF
// #date = December 28, 2001
// #author = Marcus Welz
// #warrior = stahl
// #email = stahl@themoops.org
// #web = http://www.themoops.org/
// #description = Shows how long until the flag returns.
// #status = beta

// $Workfile: flag_ctf.cs $
// $Author: Stahl $
// $Date: 02-01-13 4:00p $
// $Revision: 1 $

package MoopFlag {

// *********************************************************************************


// called when the flag is taken
function MoopEventFlagTaken(%msgType, %msgStr, %clientname, %teamname, %teamid, %taker) {
  %index = detag(%teamid);
  cancel($MoopFlagTimer[%index]);
  $MoopFlagTimer[%index] = "";
  %name = detag(%taker);
  objectiveHud.flagLocation[%index].setValue(%name);
  //%handle = alxCreateSource(AudioChat, "moopFlagTaken.wav"); alxPlay(%handle);
} // function MoopEventFlagTaken

// *********************************************************************************

// called when flag is dropped
function MoopEventFlagDrop(%msgType, %msgStr, %clientname, %teamname, %teamid) {
  %index = detag(%teamid);
  $MoopFlagCount[%index] = 45;
  MoopFlagCountdown(%index);
} // function MoopEventFlagDrop

// *********************************************************************************

function MoopFlagCountdown(%index) {
  objectiveHud.flagLocation[%index].setValue("<Dropped: " @ $MoopFlagCount[%index] @ ">");
  if($MoopFlagCount[%index] == 10) {
    %teamname = objectiveHud.teamName[%index].getValue();
    %message = %teamname @ " Flag returns in 10 seconds.~wvoice/announcer/ANN.10sec.WAV";
    defaultmessagecallback('', %message);
  }
  if($MoopFlagCount[%index] > 0) {
    $MoopFlagTimer[%index] = schedule(1000, 0, "MoopFlagCountdown", %index);
    $MoopFlagCount[%index]--;
  }
} // function MoopFlagCountdown

// *********************************************************************************

// called when flag returns
function MoopEventFlagReturn(%msgType, %msgStr, %clientname, %teamname, %teamid) {
  %index = detag(%teamid);
  cancel($MoopFlagTimer[%index]);
  $MoopFlagTimer[%index] = "";
  objectiveHud.flagLocation[%index].setValue("<At Base>");
  //%handle = alxCreateSource(AudioChat, "moopFlagReturned.wav"); alxPlay(%handle);
} // function MoopEventFlagReturn

// *********************************************************************************

// called when flag returns
function MoopEventFlagCapped(%msgType, %msgStr, %clientname, %teamname, %teamid) {
  %index = detag(%teamid);
  cancel($MoopFlagTimer[%index]);
  $MoopFlagTimer[%index] = "";
  //%handle = alxCreateSource(AudioChat, "moopFlagCaptured.wav"); alxPlay(%handle);
} // function MoopEventFlagCapped


// *********************************************************************************

function MoopEventFlagReset() {
  cancel($MoopFlagTimer[1]);
  $MoopFlagTimer[1] = "";
  cancel($MoopFlagTimer[2]);
  $MoopFlagTimer[2] = "";
} // function MoopEventFlagReset

// *********************************************************************************


};

activatePackage(MoopFlag);

  addMessageCallback('MsgCTFFlagTaken', MoopEventFlagTaken);
  addMessageCallback('MsgCTFFlagDropped', MoopEventFlagDrop);
  addMessageCallback('MsgCTFFlagReturned', MoopEventFlagReturn);
  addMessageCallback('MsgCTFFlagCapped', MoopEventFlagCapped);
  addMessageCallback('MsgGameOver', MoopEventFlagReset);
