// #autoload
// #category = MoopScript
// #name = Auto Missile
// #date = January 13, 2002
// #author = Marcus Welz
// #warrior = stahl
// #email = stahl@themoops.org
// #web = http://www.themoops.org/
// #description = Automatically fires a missile on lock
// #status = beta
// #credit = Used DeLukas' AutoMissile as template, then did (a) little OO abstraction, simplified HUD code. His site is at: http://www.thzclan.com/delukas/

// $Workfile: automissile.cs $
// $Author: Stahl $
// $Date: 02-01-13 4:00p $
// $Revision: 1 $

function TAutoMissile::create(%name)
{
	return new ScriptObject(%name)
	{
		class = "TAutoMissile";
		active = true;
		locked = false;
		setkey = false;
	};
}

function TAutoMissile::delete(%this)
{
	parent::delete(%this);
}

function TAutoMissile::turnOn(%this)
{
	%this.active = true;
	AutoMissileHUD.setText("AUTO");
    if (%this.locked)	// fire if we have a lock
    {
    	if(($mvTriggerCount0 & 1) == 0)
    	{
    		%this.fire();
    	}
	}
}

function TAutoMissile::turnOff(%this)
{
	%this.active = false;
	AutoMissileHUD.setText("");
}

function TAutoMissile::fire(%this)
{
	$mvTriggerCount0++;
}

TAutoMissile::create(autoMissile);

function AutoMissileToggle(%down)
{
	if (%down)
	{
		if (AutoMissile.active)
		{
			AutoMissile.turnOff();
		}
		else
		{
			AutoMissile.turnOn();
		}
	}
}

package moopPkgAutoMissile
{

	function clientCmdSetRepairReticle()
	{
		parent::clientCmdSetRepairReticle();
		AutoMissileHUD.visible = false;
	}

	function clientCmdSetWeaponsHudActive(%slot)
	{
		parent::clientCmdSetWeaponsHudActive(%slot);
		if($WeaponNames[%slot] $= "MissileLauncher")
		{
			AutoMissileHUD.setVisible(true);
		}
		else
		{
			AutoMissileHUD.setVisible(false);
		}
    }

	function GameConnection::onTargetLocked(%con,%state)
	{
		if( %state $= "true" )
		{
			AutoMissile.locked = true;
			if (AutoMissile.active)
			{
           		if (($mvTriggerCount0 & 1) == 0)
            	{
   	        		AutoMissile.fire();
				}
			}
		}
		else // %state == false
		{
			AutoMissile.locked = false;
			if (($mvTriggerCount0 & 1) == 1)
			{
				AutoMissile.fire();
			}
		} // state
		parent::onTargetLocked(%con,%state);
	} // function

	function OptionsDlg::onWake(%this)
	{
		if(!AutoMissile.setkey)
		{
			AutoMissile.setkey = true;
			$RemapName[$RemapCount]="AutoMissile";
			$RemapCmd[$RemapCount]="AutoMissileToggle";
			$RemapCount++;
		}
		parent::onWake( %this );
	}
};

activatePackage(moopPkgAutoMissile);

new GuiTextCtrl(AutoMissileHUD) {
	profile = "CenterPrintTextProfile";
	horizSizing = "relative";
	vertSizing = "center";
	position = "348 229";
	extent = "140 22";
	minExtent = "8 8";
	visible = "0";
	helpTag = "0";
	text = "AUTO";
	maxLength = "255";
};

PlayGui.add(AutoMissileHUD);
