// #autoload
// #name = madZoom
// #version = 2.5
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = extra zoom functionality.  requires mouse.cs

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::zoom::loaded)
{
	$madPref::zoom::zoomReset = true;  // reset zoom to minimum level when leaving zoomed state, set to false to remember previous zoom level
	$madPref::zoom::zoomNormal = true;  // wheel up = zoom out, set to false for wheel up = zoom in

	//$madPref::zoom::alwaysZoom = true;

	// additional zoom levels can be added by adding array elements in the prefs file
	// the next zoom level in the list will be $madPref::zoom::zoomLevel[4] = ...;
	$madPref::zoom::zoomLevel[0] = 2;
	$madPref::zoom::zoomLevel[1] = 5;
	$madPref::zoom::zoomLevel[2] = 10;
	$madPref::zoom::zoomLevel[3] = 20;
	
	$madPref::zoom::loaded = true;	
}

if(!isObject(madZoom))
{
	new ScriptObject(madZoom)
	{
		class = madZoom;
		
		zoomFOVPointer = 0; // just initializing
			
		keyList = false;
	};
}

function madZoom::mouseZoomIn(%this)
{
	if(%this.zoomFOVPointer < %this.maxZoomLevel)
		%this.zoomFOVPointer++;
	else
		%this.zoomFOVPointer = %this.maxZoomLevel;
	$pref::player::currentFOV = %this.zoomFOV[madZoom.zoomFOVPointer];
}

function madZoom::mouseZoomOut(%this)
{
	if(%this.zoomFOVPointer > 0)
		%this.zoomFOVPointer--;
	else
		%this.zoomFOVPointer = 0;
	$pref::player::currentFOV = %this.zoomFOV[%this.zoomFOVPointer];
}	

function madZoom::calcFOVarray(%this)
{
	// find maxZoomLevel
	for(%i = 0; $madPref::zoom::zoomLevel[%i] != 0; %i++)
		%this.maxZoomLevel = %i;
	for(%i = 0; %i <= %this.maxZoomLevel; %i++)				
		%this.zoomFOV[%i] = $pref::player::defaultFov / $madPref::zoom::zoomLevel[%i];
	%this.zoomFOVPointer = 0;
}

function calcMouseZoomFOV(%val)
{
	if($madPref::zoom::zoomNormal)
	{
		if(%val < 0) // wheel down
			madZoom.mouseZoomOut();
		if(%val > 0) // wheel up
			madZoom.mouseZoomIn();
	}
	else
	{	
		if(%val < 0) // wheel down
			madZoom.mouseZoomIn();
		if(%val > 0) // wheel up
			madZoom.mouseZoomOut();
	}
		
	// the following is taken straight from calcZoomFOV in hud.cs
	
	if(!$ZoomOn)
	{
		if($pref::player::currentFOV != 0)
		{
			%pos = getZoomCenter($pref::player::defaultFov / $pref::player::currentFOV);
      			%extent = getZoomExtent($pref::player::defaultFov / $pref::player::currentFOV);
      		}
      		else
      		{
      			%pos = getZoomCenter($pref::player::defaultFov);
      			%extent = getZoomExtent($pref::player::defaultFov);
      		}
      			
      		ZoomHud.resize(getWord(%pos, 0), getWord(%pos, 1), getWord(%extent, 0), getWord(%extent, 1));
      		if(ZoomHud.hideThread != 0)
         		cancel(ZoomHud.hideThread);
		ZoomHud.hideThread = schedule(5000, 0, hideZoomHud);
      		ZoomHud.setVisible(true);
   	}
   	else
      		setFov($pref::player::currentFOV);
} // end function calcMouseZoomFOV

function toggleZoomMode(%val)
{
	if(%val)
		$ZoomOn = !$ZoomOn;
	if($ZoomOn)
	{
		if(ZoomHud.isVisible())
		{         
			cancel(ZoomHud.hideThread);
        			hideZoomHud();
		}
		setFov($pref::player::currentFOV);
   	} 
   	else if(!$ZoomOn)
   	{
   		setFov($pref::player::defaultFov);
   		if($madPref::zoom::zoomReset)
   		{
   			$pref::player::currentFOV = madZoom.zoomFOV[0];
   			madZoom.zoomFOVPointer = 0;
   		}
   	}
}

package madZoomPackage
{
	// modifying native zoom toggle to reset to lowest zoom level

	function toggleZoom(%val)
	{
		parent::toggleZoom(%val);
		if(!%val && $madPref::zoom::zoomReset)
		{
			$pref::player::currentFOV = madZoom.zoomFOV[0];
			madZoom.zoomFOVPointer = 0;
		}
	}

	// modifying native zoom level cycle to use new zoom levels
	
	function calcZoomFov()
	{
		if(madZoom.zoomFOVPointer < madZoom.maxZoomLevel)
			madZoom.zoomFOVPointer++;
		else
			madZoom.zoomFOVPointer = 0;
		$pref::player::currentFOV = madZoom.zoomFOV[madZoom.zoomFOVPointer];

		if(!$ZoomOn)
   		{
      			if($pref::player::currentFOV != 0)
      			{
      				%pos = getZoomCenter($pref::player::defaultFov / $pref::player::currentFOV);
      				%extent = getZoomExtent($pref::player::defaultFov / $pref::player::currentFOV);
      			}
      			else
      			{
      				%pos = getZoomCenter($pref::player::defaultFov);
      				%extent = getZoomExtent($pref::player::defaultFov);
      			}
      			
      			ZoomHud.resize(getWord(%pos, 0), getWord(%pos, 1), getWord(%extent, 0), getWord(%extent, 1));
      			if(ZoomHud.hideThread != 0)
         		cancel(ZoomHud.hideThread);
		      	ZoomHud.hideThread = schedule(5000, 0, hideZoomHud);
      			ZoomHud.setVisible(true);
   		}
   		else
      			setFov($pref::player::currentFOV);
	} // end function calcZoomFov
	
	// config and keybind functions

	function OptionsDlg::onWake(%this)
	{
		if(!madZoom.keyList)
		{
			$RemapName[$RemapCount] = "\c5toggle zoom";
			$RemapCmd[$RemapCount] = "toggleZoomMode";
			$RemapCount++;
		
			madZoom.keyList = true;
		}
		parent::onWake(%this);
	}
		
	// add option to z-axis mouse config using mouse.cs routines
	
	function MouseConfigDlg::buildZActionMenu()
	{
		parent::buildZActionMenu();
		
		$MouseRemapName[$MouseRemapCount] = "Cycle Zoom Level";
		$MouseRemapCmd[$MouseRemapCount] = "calcMouseZoomFOV";
		$MouseRemapCount++;
	}

	// copy zoom keys to vehicle keybinds
	
	function clientCmdSetDefaultVehicleKeys(%inVehicle)
    	{
        	parent::clientCmdSetDefaultVehicleKeys(%inVehicle);
        	if (%inVehicle)
            	{
            		passengerKeys.copyBind(moveMap, toggleZoomMode);
            		passengerKeys.copyBind(moveMap, calcMouseZoomFOV);
		}
	} // end function clientCmdSetDefaultVehicleKeys 
	
	function DispatchLaunchMode()
	{
		parent::DispatchLaunchMode();
		madZoom.calcFOVarray();
	}
}; // end package
activatePackage(madZoomPackage);

