// #autoload
// #name = madThrow
// #version = 4.1
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #credit = jsut (for answers about when to restart the throw count), MeBaD (extra drop keybinds)

// no support scripts required

// features -->
//	o keybind for full-force grenades
//	o keybind for full-force mines
//	o functionality of standard grenade and mine keybinds unaffected
//	o keybind to toss all grenade ammo
//	o keybind to toss health kit
//	o keybind to toss all mines
// 	o option for full-force throws on key up or key down (edit pref file)

// initialize prefs and relevant variables

$madThrow::keyList = false;	

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::throw::loaded)
{
	$madPref::throw::onKeyUp = true;
	$madPref::throw::loaded = true;
}

function madGrenade(%val)
{
	if(%val ^ $madPref::throw::onKeyUp)
	{
		commandToServer('endThrowCount');
		$mvTriggerCount4++;
		$mvTriggerCount4++;
		commandToServer('startThrowCount');
	}
	else
		return;
}  // end function madGrenade

function madMine(%val)
{
	if(%val ^ $madPref::throw::onKeyUp)
	{
		commandToServer('endThrowCount');
		$mvTriggerCount5++;
		$mvTriggerCount5++;
		commandToServer('startThrowCount');
	}
	else
		return;
} // end function madMine

function throwKit(%val)
{
	if(%val)
		throw(RepairKit);
} // end function throwKit
	
function dropGrenades(%val)
{
	if(%val)
	{
		// trap all grenade types
		throw(Grenade);
		throw(FlareGrenade);
		throw(FlashGrenade);
		throw(CameraGrenade);
		throw(ConcussionGrenade);
	}
} // end function dropGrenades
	
function dropMines(%val)
{
	if(%val)
		throw(Mine);
} // end function dropMines

package madThrowPackage
{
	function OptionsDlg::onWake(%this)
	{
		if(!$madThrow::keyList)
		{
			// full-force grenade bind
			$RemapName[$RemapCount] = "\c5full-force grenades";
			$RemapCmd[$RemapCount] = "madGrenade";
			$RemapCount++;
	
			// full-force mine bind
			$RemapName[$RemapCount] = "\c5full-force mines";
			$RemapCmd[$RemapCount] = "madMine";
			$RemapCount++;
		
			// throw repair kit bind
			$RemapName[$RemapCount] = "\c5throw repair kit";
			$RemapCmd[$RemapCount] = "throwKit";
			$RemapCount++;
		
			// throw all grenades
			$RemapName[$RemapCount] = "\c5drop all grenades";
			$RemapCmd[$RemapCount] = "dropGrenades";
			$RemapCount++;
		
			// throw all mines
			$RemapName[$RemapCount] = "\c5drop all mines";
			$RemapCmd[$RemapCount] = "dropMines";
			$RemapCount++;
			
			$madThrow::keyList = true;
		}
		
		parent::onWake(%this);
	} // end keybinds
	
	// rewrite of normal grenade and mine functions for compatibility
	
	function throwGrenade(%val)
	{
		if(!%val)
		{			
			commandToServer('endThrowCount');
			$mvTriggerCount4++;
			$mvTriggerCount4++;
		}
		commandToServer('startThrowCount');	
	} // end function throwGrenade
	
	function placeMine(%val)
	{
		if(!%val)
		{
			commandToServer('endThrowCount');
			$mvTriggerCount5++;
			$mvTriggerCount5++;
		}
		commandToServer('startThrowCount');	
	} // end function placeMine

	// handle T2's resetting of the throw count
	
	function updateActionMaps()
	{ 
		parent::updateActionMaps(); 
		commandToServer('startThrowCount');
	} // end function updateActionMaps
	
	function clientCmdSetInventoryHudItem(%slot, %amount, %addItem)
	{
		parent::clientCmdSetInventoryHudItem(%slot, %amount, %addItem);
		commandToServer('startThrowCount');
	} // end function clientCmdSetInventoryHudItem	
		
	// additional useful functions
	
	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	} // end function quit
}; // end package
activatePackage(madThrowPackage);


	
		
				
	