// #autoload
// #name = madStatusHud
// #version = 0.1
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #status = beta
// #credit = MeBaD

// tracks:  ping, fps, speed, altitude
// will add a cycle key and prefs to track which displays are active...maybe

if(!isObject(madStatus))
{
	new ScriptObject(madStatus)
	{
		class = madStatus;

		sLabel = "<just:left><color:ffff00>speed:<color:ffffff> ";
		aLabel = "<just:left><color:ff8c00>alt:<color:ffffff> ";
		pLabel = "<just:left><color:00ff00>ping:<color:ffffff> ";
		fLabel = "<just:left><color:00ffff>fps:<color:ffffff> ";
	};
}

$madStatus::visible = true;
$madStatus::keybind = false;

function madStatus::setup(%this)
{
	new GuiControlProfile("madStatusHudProfile")
	{
		fontType = "Verdana";
		fontSize = 10;
		fontColor = "0 0 0";
		justify = "center";
	};
} // end function setup
	
function madStatus::get(%this)
{
	cancel(%this.schedule);
	if($madStatus::visible)
	{
		%temp = getControlObjectSpeed();
		%this.speed = mfloor(%temp) * 3.6;
		%this.alt = getControlObjectAltitude();
		%this.ping = detag(NetBarHudPingText.getValue());
		%this.fps = mFloor($fps::real);
		%this.update();
	}
} // end function get
		
function madStatus::update(%this)
{
	%speedUpdate = %this.sLabel @ %this.speed @ "\n";
	%altUpdate = %this.aLabel @ %this.alt @ "\n";
	%pingUpdate = %this.pLabel @ %this.ping @ "\n";
	%fpsUpdate = %this.fLabel @ %this.fps;	

	%update = %speedUpdate @ %altUpdate @ %pingUpdate @ %fpsUpdate;

	madStatusHudText.setValue(%update);
	
	%this.schedule(200, get);
} // end function update
	
function madStatus::create(%this)
{
	%this.destroy();
	
	new ShellFieldCtrl("madStatusHud")
	{
		profile = "GuiClockBackProfile";
		horizSizing = "left";
		vertSizing = "center";
		position = "170 0";  // should be able to use = %x SPC %y
		extent = "72 44";
		minExtent = "8 8";
		visible = "1";
				
		new GuiMLTextCtrl(madStatusHudText)
		{
			profile = "madStatusHudProfile";
			horizSizing = "left";
			vertSizing = "top";
			position = "2 2";
			extent = "66 40";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};
	};		
		
	playgui.add(madStatusHud);
} // end function create
	
function madStatus::destroy(%this)
{
	if(isObject(madStatusHud))
	{
		playGui.remove(madStatusHud);
		madStatusHud.delete();
	}
} // end function destroy

function madStatusToggle(%val)
{
	if(%val)
		$madStatus::visible = !$madStatus::visible;
	if($madStatus::visible)
		madStatus.get();
	madStatusHud.setVisible($madStatus::visible);
}	

package madStatusPackage
{
	function LoadingGui::onWake(%this)
	{
		madStatus.create();
		madStatus.get();
		madStatusHud.setVisible(true);
						
		if(isObject(HudMover))
			hudmover::addhud(madStatusHud, "status hud");
		
		parent::onWake(%this);
	} // end function onWake

	function OptionsDlg::onWake(%this)
	{
		if(!$madStatus::keybind)
		{
			$RemapName[$RemapCount] = "\c5toggle status hud";
			$RemapCmd[$RemapCount] = "madStatusToggle";
			$RemapCount++;		
			
			$madStatus::keybind = true;
		}
		
		parent::onWake(%this);
	}
}; // end package
activatePackage(madStatusPackage);

madStatus.setup();
