// #autoload
// #name = madSpeedHud
// #version = 2.1
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #status = final
// #credit = MeBaD

// small hud to track altitude and speed

if(!isObject(madSpeed))
{
	new ScriptObject(madSpeed)
	{
		class = madSpeed;

		sLabel = "<just:left><color:ffff00>Speed:<color:ffffff> ";
		aLabel = "<just:left><color:ff8c00>Alt:<color:ffffff> ";
	};
}

function madSpeed::setup(%this)
{
	new GuiControlProfile("madSpeedHudProfile")
	{
		fontType = "Univers Condensed";
		fontSize = 16;
		fontColor = "0 0 0";
		justify = "center";
	};
} // end function setup
	
function madSpeed::get(%this)
{
	%temp = getControlObjectSpeed();
	%this.speed = mfloor(%temp) * 3.6;
	%this.alt = getControlObjectAltitude();
	%this.update();
} // end function get
		
function madSpeed::update(%this)
{
	%speedUpdate = %this.sLabel @ %this.speed;
	%altUpdate = %this.aLabel @ %this.alt;
			
	madSpeedHudText.setText(%speedUpdate);
	madAltHudText.setText(%altUpdate);
		
	%this.schedule(200, get);
} // end function update
	
function madSpeed::create(%this)
{
	%this.destroy();
	
	new ShellFieldCtrl("madSpeedHud")
	{
		profile = "GuiClockBackProfile";
		horizSizing = "left";
		vertSizing = "center";
		position = "170 0";  // should be able to use = %x SPC %y
		extent = "72 46";
		minExtent = "8 8";
		visible = "1";
				
		new GuiMLTextCtrl(madSpeedHudText)
		{
			profile = "madSpeedHudProfile";
			horizSizing = "left";
			vertSizing = "top";
			position = "3 5";
			extent = "66 16";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};
	
		new GuiMLTextCtrl(madAltHudText)
		{
			profile = "madSpeedHudProfile";
			horizSizing = "left";
			vertSizing = "bottom";
			position = "3 23";
			extent = "66 16";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};
	
	};		
		
	playgui.add(madSpeedHud);
} // end function create
	
function madSpeed::destroy(%this)
{
	if(isObject(madSpeedHud))
	{
		playGui.remove(madSpeedHud);
		madSpeedHud.delete();
	}
} // end function destroy

package madSpeedPackage
{
	function LoadingGui::onWake(%this)
	{
		madSpeed.create();
		madSpeed.get();
		madSpeedHud.setVisible(true);
						
		if(isObject(HudMover))
			hudmover::addhud(madSpeedHud, "speed hud");
		
		parent::onWake(%this);
	} // end function onWake
}; // end package
activatePackage(madSpeedPackage);

madSpeed.setup();
