// #autoload
// #name = madSpeedHud
// #version = 1.2
// #status = updated
// #author = Monk
// #credit = MeBaD

// small hud to track altitude and speed

if(!isObject(madSpeed))
{
	new ScriptObject(madSpeed)
	{
		class = madSpeed;

		sLabel = "<color:ffff00>Speed:<color:ffffff> ";
		aLabel = "<color:ffc800>Alt:<color:ffffff> ";
	};
}


package madSpeed
{
	function LoadingGui::onWake(%this)
	{
		madSpeed.create();
		madSpeed.get();
		madSpeedHud.setVisible(true);
						
		if(isObject(HudMover))
			hudmover::addhud(madSpeedHud, "speed hud");
		
		parent::onWake(%this);
	}
	
	function DispatchLaunchMode()
	{
		madSpeed.setup();
		parent::DispatchLaunchMode();
	}
	
	function madSpeed::setup()
	{
		new GuiControlProfile("madSpeedHudProfile")
		{
			fontType = "Univers Condensed";
			fontSize = 16;
			fontColor = "0 0 0";
			justify = "center";
		};
	}
	
	
	function madSpeed::get()
	{
		%temp = getControlObjectSpeed();
		madSpeed.speed = (mfloor(%temp) * 3.6) / 1;
		madSpeed.alt = getControlObjectAltitude();
		madSpeed.update();
	}
	
	function madSpeed::update()
	{
		%speedUpdate = "<just:left><color:ffff00>speed: <color:ffffff>" @ madSpeed.speed;
		%altUpdate = "<just:left><color:ffff00>alt: <color:ffffff>" @ madSpeed.alt;
				
		madSpeedHudText.setText(%speedUpdate);
		madAltHudText.setText(%altUpdate);
		
		schedule(200, 0, eval, "madSpeed.get();");
	}
	
	function madSpeed::create()
	{
		madSpeed.destroy();
		
		%xCenter = getword($pref::Video::resolution, 0) / 2;  // get screen center
		%x = %xCenter - 25;
		%y = 100;
		
		new ShellFieldCtrl("madSpeedHud")
		{
			profile = "GuiClockBackProfile";
			horizSizing = "left";
			vertSizing = "center";
			position = "170 0";  // should be able to use = %x SPC %y
			extent = "64 46";
			minExtent = "8 8";
			visible = "1";
					
			new GuiMLTextCtrl(madSpeedHudText)
			{
				profile = "madSpeedHudProfile";
				horizSizing = "left";
				vertSizing = "top";
				position = "3 5";
				extent = "58 16";
				minExtent = "8 8";
				visible = "1";
				helpTag = "0";
				lineSpacing = "2";
				allowColorChars = "1";
				maxChars = "-1";
			};
		
			new GuiMLTextCtrl(madAltHudText)
			{
				profile = "madSpeedHudProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "3 23";
				extent = "58 16";
				minExtent = "8 8";
				visible = "1";
				helpTag = "0";
				lineSpacing = "2";
				allowColorChars = "1";
				maxChars = "-1";
			};
		
		};		
		
		playgui.add(madSpeedHud);
	}
	
	function madSpeed::destroy()
	{
		if(isObject(madSpeedHud))
		{
			playGui.remove(madSpeedHud);
			madSpeedHud.delete();
		}
	}
	
};
activatePackage(madSpeed);

// gui profiles

