// #autoload
// #name = madShieldWheel
// #version = 1.1
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts

// this is the precursor to madPackWheel, it's a proof of concept script
// the idea is to incorporate this with a more complex mousewheel function
// so that i can use the mousewheel to activate a shield pack if i have one,
// but use it to cycle zoom levels otherwise

// played around to add a deadzone to the mousewheel

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::shieldwheel::loaded)
{
	$madPref::shieldwheel::deadzone = 2;
	$madPref::shieldwheel::timeout = 1000;
	$madPref::shieldwheel::loaded = 1;
}


$madShield::on = false;

$mouseWheelUp = 0;
$mouseWheelDown = 0;

function madShieldWheel(%val)
{
	cancel($madShield::timer);
	if(%val > 0)
	{
		$mouseWheelUp++;
		$mouseWheelDown = 0;
		if($mouseWheelUp >= $madPref::shieldwheel::deadzone && !$madShield::on)
		{
			$mouseWheelUp = 0;
			$madShield::on = true;
			use("ShieldPack");
		}
		else
			$madShield::timer = schedule($madPref::shieldwheel::timeout, 0, eval, "$mouseWheelUp = 0;");
	}
	else if(%val < 0)
	{
		$mouseWheelDown++;
		$mouseWheelUp = 0;
		if($mouseWheelDown >= $madPref::shieldwheel::deadzone && $madShield::on)
		{
			$mouseWheelDown = 0;
			use("ShieldPack");
			$madShield::on = false;
		}
		else
			$madShield::timer = schedule($madPref::shieldwheel::timeout, 0, eval, "$mouseWheelDown = 0;");	
	}
}
	
function madShieldWheelReset()
{
	$madShield::on = false;
}

package madShieldWheelPackage
{
	function clientCmdSetInventoryHudClearAll() // reset pack if we die
	{
		parent::clientCmdSetInventoryHudClearAll();
		$madShield::on = false;
	}
			
	function MouseConfigDlg::buildZActionMenu()
	{	
		parent::buildZActionMenu();
		$MouseRemapName[$MouseRemapCount] = "Shield Wheel";
		$MouseRemapCmd[$MouseRemapCount] = "madShieldWheel";
		$MouseRemapCount++;
	}	

	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	} // end prefs save

}; // end package
activatePackage(madShieldWheelPackage);

addMessageCallback('MsgShieldPackOff', madShieldWheelReset);
