// #autoload
// #name = madPilot
// #version = 1.0
// #status = beta
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #credit = Runar

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::pilot::loaded)
{
	$madPref::pilot::sensitivity = 2;
	$madPref::pilot::deadzone = false;
	$madPref::pilot::loaded = true;
}

if(!isObject(madPilot))
{
	new ScriptObject(madPilot)
	{
		class = madPilot;
		
		flags[0, 0, 0] = "S";
		flags[0, 0, 1] = "SD";
		flags[0, 1, 0] = "SI";
		flags[0, 1, 1] = "SDI";
		flags[1, 0, 0] = "SI";
		flags[1, 0, 1] = "SDI";
		flags[1, 1, 0] = "S";
		flags[1, 1, 1] = "SD";
	};
}

function madPilot::setScale(%this)
{
	if(!%this.pilot)
		return;
	
	// Yaw bind
	%bind = moveMap.getBinding(yaw);
	%device = getField(%bind, 0);
	%action = getField(%bind, 1);
	%flags = %this.flags[moveMap.isInverted(%device, %action), 0, $madPref::pilot::deadzone];	
	
	if($madPref::pilot::deadzone)
		passengerKeys.bind(%device, %action, %flags, moveMap.getDeadZone(%device, %action), moveMap.getScale(%device, %action) * $madPref::pilot::sensitivity, yaw);
	else
		passengerKeys.bind(%device, %action, %flags, moveMap.getScale(%device, %action) * $madPref::pilot::sensitivity, yaw);

	// Pitch bind
	%bind = moveMap.getBinding(pitch);
	%device = getField(%bind, 0);
	%action = getField(%bind, 1);
	%flags = %this.flags[moveMap.isInverted(%device, %action), $pref::Vehicle::InvertYAxis, $madPref::pilot::deadzone];

	if($madPref::pilot::deadzone)
		passengerKeys.bind(%device, %action, %flags, moveMap.getDeadZone(%device, %action), moveMap.getScale(%device, %action) * $madPref::pilot::sensitivity, pitch);
	else
		passengerKeys.bind(%device, %action, %flags, moveMap.getScale(%device, %action) * $madPref::pilot::sensitivity, pitch);
}	

package madPilotPackage
{
	function ClientCmdSetHudMode(%mode, %type, %node)
	{
		parent::ClientCmdSetHudMode(%mode, %type, %node);

		if(getWord(%mode, 1) $= "Pilot")
			madPilot.setScale();
	}

	function clientCmdSetPilotVehicleKeys()
	{
		parent::clientCmdSetPilotVehicleKeys();
		madPilot.pilot = true;
	}

	function clientCmdSetPassengerVehicleKeys()
	{
		parent::clientCmdSetPassengerVehicleKeys();
		madPilot.pilot = false;
	}
	
	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	} // end prefs save
};
activatePackage(madPilotPackage);
