// #autoload
// #name = madPackWheel
// #version = 1.1
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #include = support/loadout.cs
// #include = support/callback.cs
// #description = new mousewheel function - scrolling up will activate pack, scrolling down will turn it off (requires mouse.cs)


if(!isObject(madPackWheel))
{
	new ScriptObject(madPackWheel)
	{
		class = madPackWheel;
		
		packOn = false;

	};
}

function madPackWheel(%val)
{
	echo(%val);
	if(%val > 0 && !madPackWheel.packOn)
	{
		madPackWheel.packOn = true;
		useBackPack(1);
	}
	else if(%val < 0 && madPackWheel.packOn)
	{
		%pack = loadout.getPack();
		
		if(strstr(%pack, "Deployable") != -1)
			useBackPack(0);
		else
			useBackPack(1);
		madPackWheel.packOn = false;
	}
}

function madPackWheel::reset()
{
	madPackWheel.packOn = false;
}

package madPackWheelPackage
{
	function MouseConfigDlg::buildZActionMenu()
	{	
		parent::buildZActionMenu();
		$MouseRemapName[$MouseRemapCount] = "Pack Wheel";
		$MouseRemapCmd[$MouseRemapCount] = "madPackWheel";
		$MouseRemapCount++;
	}
}; // end package
activatePackage(madPackWheelPackage);

callback.add(CallbackMsgCloakingPackOff, "madPackWheel.reset");
callback.add(CallbackMsgCloakingPackFailed, "madPackWheel.reset");
callback.add(CallbackMsgSensorJammerPackOff, "madPackWheel.reset");
callback.add(CallbackMsgShieldPackOff, "madPackWheel.reset");
callback.add(PlayerDeath, "madPackWheel.reset");