// #autoload
// #name = madMute
// #version = 0.3
// #status = beta
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::mute::loaded)
{
	$madPref::mute::global = false;
	$madPref::mute::team = false;
}

$madMute::keyList = false;

// set the counter properly

if($madPref::mute::global && $madPref::mute::team)
	$madMute::counter = 3;
else if($madPref::mute::global)
	$madMute::counter = 1;
else if($madPref::mute::team)
	$madMute::counter = 2;

function madToggleMute(%val)
{
	if(%val)
	{
		$madMute::counter++;
		switch$ ($madMute::counter)
			case 1:
				$madPref::mute::global = true;
				$madPref::mute::team = false;
				%message = "\c2o- Global chat muted -o";
			case 2:
				$madPref::mute::global = false;
				$madPref::mute::team = true;
				%message = "\c2o- Team chat muted -o";
			case 3:
				$madPref::mute::team = true;
				$madPref::mute::global = true;
				%message = "\c2o- Global and Team chat muted -o";
			case default:
				$madPref::mute::team = false;
				$madPref::mute::global = false;
				%message = "\c2o- mute disabled -o";
		
		addMessageHudLine(%message);
	}
}

package madMutePackage
{
	function clientCmdChatMessage(%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10)
	{
		%global = strstr(detag(%msgString), "\c4");
		%team = strstr(detag(%msgString), "\c3");
	
		if((%global != -1) && $madMute::mute::global)
			return;
		else if((%team != -1) && $madMute::mute::team)
			return;
		else
			parent::clientCmdChatMessage(%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);
	}
	
	function OptionsDlg::onWake(%this)
	{
		if(!$madMute::keyList)
		{
			$RemapName[$RemapCount] = "\c5toggle mute options";
			$RemapCmd[$RemapCount]  = "madToggleMute";
			$RemapCount++;
			
			$madMute::keyList = true;		
		}
		parent::onWake(%this);
	} // end function onWake
	
	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	}	
}; // end package
activatePackage(madMutePackage);
