// #autoload
// #name = madNewChatHud
// #version = 0.2
// #status = beta
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts

// goal:
//	a more half-life style chat hud for tribes 2 - why?  because i play at 800x600 and the chat hud's huge
// plan:
//	create a new hud to handle messages, hide standard chat hud (due to extensiveness of changes being made)
//	make new hud transparent, compact, and a popup - that is new messages will be added and pushed as needed
//	but messages will timeout of the chat hud

// other things to do:
//	strip voice bind keys
//	seperate huds for team, global, misc messages
// 	built in mute functionality



if(!isObject(madNewChat))
{
	new ScriptObject(madNewChat)
	{
		class = madNewChat;

		delay = 5000;
	};
}

new MessageVector(madHudMessageVector);

function madNewChat::create(%this)
{
	%this.destroy();
		
	// create the chat hud object
	new GuiControl(madMainChatHud) 
	{
		profile = "GuiModelessDialogProfile";
		horizSizing = "width";
		vertSizing = "height";
		position = "0 0";
		extent = "800 600";
		minExtent = "8 8";
		visible = "1";
		modal = "1";
		bypassHideCursor = "1";
		setFirstResponder = "0";

		new GuiNoMouseCtrl() 
		{
			profile = "GuiDefaultProfile";
			horizSizing = "relative";
			vertSizing = "bottom";
			position = "0 0";
			extent = "800 600";
			minExtent = "8 8";
			visible = "1";
      
			new ShellFieldCtrl(madOuterChatHud)
   			{
	   			profile = "GuiDefaultProfile";
	   			horizSizing = "width";
	   			vertSizing = "bottom";
	   			position = "1 420";
	   			extent = "256 88";
	   			minExtent = "8 8";
	   			visible = "1";
	   			setFirstResponder = "0";
		         
      				new GuiScrollCtrl(madChatScrollHud) 
	   			{
			   		profile = "GuiDefaultProfile";
		   			horizSizing = "width";
		   			vertSizing = "bottom";
		   			position = "2 2";
		   			extent = "252 86";
		   			minExtent = "8 8";
		   			visible = "1";
		   			setFirstResponder = "0";
		   			willFirstRespond = "1";
		   			hScrollBar = "alwaysOff";
		   			vScrollBar = "alwaysOff";
		   			constantThumbHeight = "0";
            
			   		new GuiScrollContentCtrl() 
			   		{
			   			profile = "GuiDefaultProfile";
			   			horizSizing = "width";
			   			vertSizing = "bottom";
			   			position = "2 2";
			   			extent = "252 86";
			   			minExtent = "8 8";
			   			visible = "1";
			   			helpTag = "0";

		      				new GuiMessageVectorCtrl(madChatHud) 
		      				{
			      				profile = "GuiMadNewChatHudProfile";
			      				horizSizing = "width";
			      				vertSizing = "height";
			      				position = "2 2";
			      				extent = "252 86";
			      				minExtent = "8 8";
			      				visible = "1";
			      				setFirstResponder = "0";
			      				lineSpacing = "0";
			      				lineContinuedIndex = "10";
			      				allowedMatches[0] = "http";
			      				allowedMatches[1] = "t2server";
			      				matchColors[0] = "0 0 255 255";
			      				matchColors[1] = "255 0 0 255";
			      				matchColors[2] = "0 0 255 255";
			      				matchColors[3] = "0 0 255 255";
			      				matchColors[4] = "0 0 255 255";
			      				matchColors[5] = "0 0 255 255";
			      				matchColors[6] = "0 0 255 255";
			      				matchColors[7] = "0 0 255 255";
			      				matchColors[8] = "0 0 255 255";
			      				matchColors[9] = "0 0 255 255";
			      				matchColors[10] = "0 0 255 255";
			      				matchColors[11] = "0 0 255 255";
			      				matchColors[12] = "0 0 255 255";
			      				matchColors[13] = "0 0 255 255";
			      				matchColors[14] = "0 0 255 255";
			      				matchColors[15] = "0 0 255 255";
               						maxColorIndex = 5;
		      				};
       					};   
	  			};
   			};
		};
	};
		
	// create the vote hud object
		
	new ShellFieldCtrl(madVoteHud)
	{
		profile = "GuiDefaultProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "1 200"; 
		extent = "200 76";
		minExtent = "8 8";
		visible = "1";
					
		new GuiMLTextCtrl(madVoteHudText)
		{
			profile = "GuiMadNewChatHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "2 2";
			extent = "196 46";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};
			
		new GuiMLTextCtrl(madVoteYesText)
		{
			profile = "GuiMadNewChatHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "2 46";
			extent = "100 15";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "1";
			allowColorChars = "1";
			maxChars = "-1";
		};					
			
		new GuiMLTextCtrl(madVoteNoText)
		{
			profile = "GuiMadNewChatHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "2 61";
			extent = "100 15";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "1";
			allowColorChars = "1";
			maxChars = "-1";
		};
						
	};					
	// create the message hud object (could use the existing one but would have to hack up the code anyway)
		
	// for starters, going to abuse the existing message hud, but change a couple of parameters
	MessageHud_Frame.profile = "GuiDefaultProfile";
	MessageHud_Frame.position = "2 2";
		
	// add these objects to the playgui
	
	playGui.add(madMainChatHud);
	playGui.add(madVoteHud);
	// playGui.add(madMessageHud);		
}
	
function madNewChat::destroy(%this)
{
	if(isObject(madMainChatHud))
	{
		playGui.remove(madMainChatHud);
		madMainChatHud.delete();
	}
	if(isObject(madVoteHud))
	{
		playGui.remove(madVoteHud);
		madVoteHud.delete();
	}
}

function madNewChat::setTimeout(%this)
{
	madHudMessageVector.popFrontLine();
	if(madHudMessageVector.getNumLines() > 0)
		%this.timeout = %this.schedule(%this.delay, setTimeout);
	else
		%this.timeout = "";
}


package madNewChatHudPackage
{
	// setup chat hud

	function LoadingGui::onWake(%this)
	{
		madNewChat.create();
		madChatHud.setVisible(true);

		//if(isObject(HudMover))
		//	hudmover::addhud(madOuterChatHud, "new chat hud");

		parent::onWake(%this);
	}
	
	function PlayGui::onWake(%this)
	{
		parent::onWake(%this);

  		madChatHud.attach(madHudMessageVector);
	}

	// overrides to pipe chat lines to new chat hud (the important part of the code)
	
	function addMessageHudLine(%text)
	{
		// take what we need first, the chat hud can stand in line
		while(madHudMessageVector.getNumLines() >= 6)
		{
	      		%tag = madHudMessageVector.getLineTag(0);
      			if(%tag != 0)
	         		%tag.delete();
      			madHudMessageVector.popFrontLine();
      		}

      		madHudMessageVector.pushBackLine(%text, $LastHudTarget);
      		if(madNewChat.timeout $= "")
      			madNewChat.timeout = madNewChat.schedule(madNewChat.delay, setTimeout);  // time out chat messages
	
		parent::addMessageHudLine(%text);
	}
	
	// hide the default chat hud, message hud and vote hud

	function ClientCmdDisplayHuds()
	{
		parent::ClientCmdDisplayHuds();
		
		madOuterChatHud.setVisible(true);
		OuterChatHud.setVisible(false);
		
		madVoteHud.setVisible(mainVoteHud.visible);
		mainVoteHud.setVisible(false);
	}
	
	function clientCmdTogglePlayHuds(%val)
	{
		parent::clientCmdTogglePlayHuds(%val);
		
		madOuterChatHud.setVisible(%val);
		OuterChatHud.setVisible(false);

		madVoteHud.setVisible(mainVoteHud.visible);
		mainVoteHud.setVisible(false);
	}
	
	function hideAllHuds()
	{
		parent::hideAllHuds();
		madOuterChatHud.setVisible(false);
	}
	
	function restoreAllHuds()
	{
		parent::restoreAllHuds();
		OuterChatHud.setVisible(false);
		madOuterChatHud.setVisible(true);
	}
	
	// voting hud routines

	function initVote(%msgType, %msgString, %voter, %action, %arg)
	{
		%voter = detag(%voter);
		%arg = detag(%arg);
		%action = detag (%action);
	
		// pick out the ones that need to be made more concise, then default the rest to displaying the standard msg
		switch$(%action)
		{
			case "change the mission to":
				%voteMsg = "map: " @ %arg;
			case "Kick Player":
				%voteMsg = "kick: " @ %arg;
			case "Ban Player":
				%voteMsg = "ban: " @ %arg;
			case "Admin Player":
				%voteMsg = "admin: " @ %arg;
			case "change the server to":
				%voteMsg = %arg;
			case "change the time limit to":
				%voteMsg = "time: " @ %arg;
			default:
				%voteMsg = %action;
		}
			
		// update new hud items and set the vote hud visible
		
		%message = "\c2(" @ %voter @ "\c2)\n" @ %voteMsg;
	
		madVoteHud.position = "1 200";
		madVoteHud.setVisible(true);
		madVoteHudText.setText(%message);
		
		if(voteHud.yesCount $= "")
			voteHud.yesCount = 0;
		if(voteHud.noCount $= "")
			voteHud.noCount = 0;
		
		madVoteYesText.setText("\c2yes: " @ voteHud.yesCount);
		madVoteNoText.setText("no:  " @ voteHud.noCount);
	}	
	
	function openVoteHud(%msgType, %msgString, %numClients, %passPercent)
	{
		parent::openVoteHud(%msgType, %msgString, %numClients, %passPercent);
		
		voteHud.setVisible(false);
   		mainVoteHud.setVisible(false);
   	}
   	
   	function CloseVoteHud(%msgType, %msgString)
   	{
   		parent::closeVoteHud(%msgType, %msgString);
   		
   		madVoteHud.setVisible(false);
   		madVoteHudText.setText("");
   		madVoteYesText.setText("");
   		madVoteNoText.setText("");
   	}
   	
   	function addYesVote(%msgType, %msgString)
   	{
   		parent::addYesVote(%msgType, %msgString);
   		
   		madVoteYesText.setText("\c2yes: " @ voteHud.yesCount);
   	}
   	
   	function addNoVote(%msgType, %msgString)
   	{
   		parent::addNoVote(%msgType, %msgString);
   		
   		madVoteNoText.setText("no:  " @ voteHud.noCount);
   	}
   	
   	// end voting routines
   	
   	// message hud routines
   	
	// will start by editing down the existing message hud functions
	
	function MessageHud::open(%this)
	{
       		// ripped out all of the repositioning code       		
       		%offset = 6; 
       		
       		if(%this.isVisible())
      			return;
	
   		if(%this.isTeamMsg)
      			%text = "team:";
   		else
      			%text = "global:";

   		MessageHud_Text.setValue(%text);
   		
   		%textExtent = getWord(MessageHud_Text.extent, 0);
   		%ctrlExtent = getWord(MessageHud_Frame.extent, 0);
	   		   	
	   	Canvas.pushDialog(%this);
	   	
  		MessageHud_Edit.position = setWord(MessageHud_Edit.position, 0, %textExtent + %offset);
   		MessageHud_Edit.extent = setWord(MessageHud_Edit.extent, 0, %ctrlExtent - %textExtent - (2 * %offset));
	   	
     		%this.setVisible(true);
   		deactivateKeyboard();
   		MessageHud_Edit.makeFirstResponder(true);
	}

	function MessageHud::close(%this)
	{
   		// ripped out all repositioning code
   		
   		if(!%this.isVisible())
      			return;
	      
   		Canvas.popDialog(%this);
      		%this.setVisible(false);
   		if ( $enableDirectInput )
      			activateKeyboard();
   		MessageHud_Edit.setValue("");
	}

//	function MessageHud::toggleState(%this)
//	{
//  		if(%this.isVisible())
//    			%this.close();
//   		else
//      			%this.open();
//	}

//	function MessageHud_Edit::onEscape(%this)
//	{
//  	 	MessageHud.close();
//	}

//	function MessageHud_Edit::eval(%this)
//	{
//   		%text = trim(%this.getValue());
//   		if(%text !$= "")
//   		{
//     			if(MessageHud.isTeamMsg)
//         			commandToServer('teamMessageSent', %text);
//     		 	else
//         			commandToServer('messageSent', %text);
//   		}
//
//   		MessageHud.close();
//	}		
}; // end package
activatePackage(madNewChatHudPackage);

new GuiControlProfile("GuiMadNewChatHudProfile")
{
	fontType = "Verdana";
	fontSize = 10;
	fontColor = "0 255 255";// default color (death msgs, scoring, inventory)
	fontColors[1] = "255 200 0";// client join/drop, tournament mode
	fontColors[2] = "255 255 255";// gameplay, admin/voting, pack/deployable
	fontColors[3] = "0 255 0";// team chat, spam protection message, client tasks
	fontColors[4] = "255 255 0";// global chat
	fontColors[5] = "255 0 128 255";// used in single player game
	autoSizeWidth = true;
	autoSizeHeight = true;
};






