// #autoload
// #name = madMute
// #version = 0.1
// #status = testing
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #include = support/mute_tools.cs
// #include = support/team_tracker.cs

// does not save options.  this is intentional and will not be fixed.  i don't feel like dealing with
// my own teammates "forgetting" they had a mute preference on and missing instructions.

if(!isObject(madMute))
{
	new ScriptObject(madMute)
	{
		class = madMute;
		
		keyList = false;
	};
}

package madMutePackage
{
	function clientCmdChatMessage(%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10)
	{		
		%global = strstr(detag(%msgString), "\c4");
		%clan = strstr(teamTracker.myTag, $PlayerList[%sender].name);
		%team = strstr(detag(%msgString), "\c3");
		%admin = ($PlayerList[%sender].isAdmin || $PlayerList[%sender].isSuperAdmin);
				
		if((%global != -1) && $madMuteGlobal)
			return mute;
		else if((%clan != -1) && $madMuteNonClan)
			return mute;
		else if((%team != -1) && $madMuteTeam)
			return mute;		
		else if(!%admin && $madMuteNonAdmin)
			return mute;
		
		parent::clientCmdChatMessage(%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);
	}
	
	// for multiple mute options will need a gui for configuration
	
	function ClientCmdDisplayHuds()
	{
		if($madMuteHideChat)
		{
			parent::ClientCmdDisplayHuds();
			outerChatHud.setVisible(false);
		}
		else
			parent::ClientCmdDisplayHuds();
	}

	function OptionsDlg::onWake(%this)
	{
		if(!madMute.keyList)
		{
			$RemapName[$RemapCount] = "\c5mute options";
			$RemapCmd[$RemapCount]  = "madMuteOptionsMenu";
			$RemapCount++;	
			
			madMute.keyList = true;			
		}
		parent::onWake(%this);
	} // end function onWake
	
	function madMuteOptionsMenu(%val)
	{
		if(%val)
			Canvas.pushDialog(madMuteConfigDlg);
	}
	
	function madMuteConfigDlg::onWake(%this)
	{
		CursorOn();	
	}

	function madMuteConfigDlg::onOK(%this)
	{
		canvas.popDialog(madMuteConfigDlg);
		CursorOff();
		clientCmdDisplayHuds();
	}
	
		
}; // end package
activatePackage(madMutePackage);


// gui for new mute options

//--- OBJECT WRITE BEGIN ---
new GuiControl(madMuteConfigDlg) {
	profile = "GuiDefaultProfile";
	horizSizing = "width";
	vertSizing = "height";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	helpTag = "0";

	new ShellPaneCtrl() {
		profile = "ShellDlgPaneProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "125 104";
		extent = "330 250";
		minExtent = "48 92";
		visible = "1";
		helpTag = "0";
		text = "Mute Options";
		noTitleBar = "0";

		new ShellBitmapButton() {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "111 195";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "madMuteConfigDlg::onOK();";
			helpTag = "0";
			text = "OK";
			simpleStyle = "0";
		};
		
		new ShellToggleButton() {
			profile = "ShellRadioProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "96 28";
			extent = "150 30";
			minExtent = "26 27";
			visible = "1";
			variable = "$madMuteGlobal";
			helpTag = "0";
			text = "Mute All Global Chat";
		};
		
		new ShellToggleButton() {
			profile = "ShellRadioProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "96 63";
			extent = "150 30";
			minExtent = "26 27";
			visible = "1";
			variable = "$madMuteTeam";
			helpTag = "0";
			text = "Mute All Team Chat";
		};
		
		new ShellToggleButton() {
			profile = "ShellRadioProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "96 98";
			extent = "150 30";
			minExtent = "26 27";
			visible = "1";
			variable = "$madMuteNonClan";
			helpTag = "0";
			text = "Mute All Non-Clan Chat";
		};
		
		new ShellToggleButton() {
			profile = "ShellRadioProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "96 133";
			extent = "150 30";
			minExtent = "26 27";
			visible = "1";
			variable = "$madMuteNonAdmin";
			helpTag = "0";
			text = "Mute All Non-Admin Chat";
		};
		
		new ShellToggleButton() {
			profile = "ShellRadioProfile";
			horizSizing = "right";
			verSizing = "bottom";
			position = "96 168";
			extent = "150 30";
			minExtent = "26 27";
			visible = "1";
			variable = "$madMuteHideChat";
			helpTag = "0";
			text = "Hide Chat Hud";
		};
	};
};
