// #autoload
// #name = madMouse
// #version = 3.0
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts

// rewrite of the mouse configuration functions to enable greater functionality in the mouse.
// basically what i'm doing is making the mouse z-axis binding more closely resemble the keyboard
// binding.  this should facilitate scriptable additions to the mousewheel functionality without
// causing conflicts.  and while i was at it, i redid the mouse config dialog to simplify
// binding to meta+mousewheel

function MouseConfigDlg::onWake( %this )
{
   	MouseXSlider.setValue( moveMap.getScale( mouse, xaxis ) / 2 );
   	MouseYSlider.setValue( moveMap.getScale( mouse, yaxis ) / 2 );
   	InvertMouseTgl.setValue( moveMap.isInverted( mouse, yaxis ) );

   	MouseZActionMenu.clear();
   	MouseAltZActionMenu.clear();
   	MouseCtrlZActionMenu.clear();
   	MouseShiftZActionMenu.clear();
   	
   	MouseConfigDlg.buildZActionMenu(); // builds a global array of all of the z-axis options
   	
   	for(%i = 1; %i < $MouseRemapCount; %i++)
   	{
   		MouseZActionMenu.add($MouseRemapName[%i], %i);
   	 	MouseAltZActionMenu.add($MouseRemapName[%i], %i);
   	 	MouseCtrlZActionMenu.add($MouseRemapName[%i], %i);
   	 	MouseShiftZActionMenu.add($MouseRemapName[%i], %i);
   	}
   	   	   	
   	%bind[0] = moveMap.getCommand("mouse", "zaxis");
   	%selId[0] = 1;
   	
   	%bind[1] = moveMap.getCommand("mouse", "alt zaxis");
   	%selId[1] = 1;
   	
   	%bind[2] = moveMap.getCommand("mouse", "ctrl zaxis");
   	%selId[2] = 1;
   	
   	%bind[3] = moveMap.getCommand("mouse", "shift zaxis");
   	%selId[3] = 1;
   	   	
   	for(%j = 0; %j <= 3; %j++)
   	{
   		for(%i = 1; %i < $MouseRemapCount; %i++)
   		{
   			if(%bind[%j] $= $MouseRemapCmd[%i])
   				%selId[%j] = %i;
   		}
   	}
   	MouseZActionMenu.setSelected(%selId[0]);
   	MouseAltZActionMenu.setSelected(%selId[1]);
   	MouseCtrlZActionMenu.setSelected(%selId[2]);
   	MouseShiftZActionMenu.setSelected(%selId[3]);   	
}

// now build the z-axis option list - overriding this function makes it straightforward to add new
// options to the z-axis menu in a fashion similar to adding keybinds to OptionsDlg::onWake, ie to add
// a new z-axis option you would use the following syntax in a script:
//
//function MouseConfigDlg::buildZActionMenu()
//{
//	parent::buildZActionMenu();
//	$MouseRemapName[$MouseRemapCount] = "<your function description>";
//	$MouseRemapCmd[$MouseRemapCount] = "<your function name>";
//	$MouseRemapCount++;
//}
//

function MouseConfigDlg::buildZActionMenu()
{
	$MouseRemapCount = 0;
	$MouseRemapName[$MouseRemapCount] = ""; // not used, just initializing for completeness
	$MouseRemapCmd[$MouseRemapCount] = ""; // not used, just initializing for completeness
	$MouseRemapCount++;
	$MouseRemapName[$MouseRemapCount] = "Nothing";
	$MouseRemapCmd[$MouseRemapCount] = "";
	$MouseRemapCount++;
	$MouseRemapName[$MouseRemapCount] = "Cycle Weapon";
	$MouseRemapCmd[$MouseRemapCount] = "cycleWeaponAxis";
	$MouseRemapCount++;
	$MouseRemapName[$MouseRemapCount] = "Next Weapon Only";
	$MouseRemapCmd[$MouseRemapCount] = "cycleNextWeaponOnly";
	$MouseRemapCount++;
}

	
function MouseConfigDlg::onOK( %this )
{
   	%xSens = MouseXSlider.getValue() * 2;
   	%ySens = MouseYSlider.getValue() * 2;
   	moveMap.bind( mouse, xaxis, "S", %xSens, "yaw" );
   	%yFlags = InvertMouseTgl.getValue() ? "SI" : "S";
   	moveMap.bind( mouse, yaxis, %yFlags, %ySens, "pitch" );

	%newbind = MouseZActionMenu.getSelected();
	if(%newbind <= 1)
		moveMap.unbind(mouse, zaxis);
	else
		moveMap.bind(mouse, zaxis, $MouseRemapCmd[%newbind]);
	
	%newbind = MouseAltZActionMenu.getSelected();
	if(%newbind <= 1)
		moveMap.unbind(mouse, "alt zaxis");
	else
		moveMap.bind(mouse, "alt zaxis", $MouseRemapCmd[%newbind]);
	
	%newbind = MouseCtrlZActionMenu.getSelected();
	if(%newbind <= 1)
		moveMap.unbind(mouse, "ctrl zaxis");
	else
		moveMap.bind(mouse, "ctrl zaxis", $MouseRemapCmd[%newbind]);
	
	%newbind = MouseShiftZActionMenu.getSelected();
	if(%newbind <= 1)
		moveMap.unbind(mouse, "shift zaxis");
	else
		moveMap.bind(mouse, "shift zaxis", $MouseRemapCmd[%newbind]);
		

	Canvas.popDialog(MouseConfigDlg);
}


// gui edit

//--- OBJECT WRITE BEGIN ---
new GuiControl(MouseConfigDlg) {
	profile = "DlgBackProfile";
	horizSizing = "width";
	vertSizing = "height";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	helpTag = "0";

	new ShellPaneCtrl() {
		profile = "ShellDlgPaneProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "125 44";
		extent = "390 391";
		minExtent = "48 92";
		visible = "1";
		helpTag = "0";
		text = "CONFIGURE MOUSE";
		noTitleBar = "0";

		new ShellBitmapButton() {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "50 326";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "Canvas.popDialog(MouseConfigDlg);";
			accelerator = "escape";
			helpTag = "0";
			text = "CANCEL";
			simpleStyle = "0";
		};
		new ShellBitmapButton() {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "220 326";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "MouseConfigDlg::onOK();";
			helpTag = "0";
			text = "OK";
			simpleStyle = "0";
		};
		new GuiTextCtrl() {
			profile = "ShellTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "86 36";
			extent = "94 22";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "X-Axis Sensitivity:";
		};
		new GuiTextCtrl(MouseXText) {
			profile = "ShellAltTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "185 36";
			extent = "28 20";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "(0.5)";
		};
		new ShellSliderCtrl(MouseXSlider) {
			profile = "ShellSliderProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "96 51";
			extent = "170 24";
			minExtent = "12 24";
			visible = "1";
			variable = "value";
			altCommand = "MouseXSlider.sync();";
			helpTag = "0";
			range = "0.000000 1.000000";
			ticks = "1000";
			value = "0.480769";
			usePlusMinus = "1";
		};
		new ShellToggleButton() {
			profile = "ShellRadioProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "247 73";
			extent = "71 30";
			minExtent = "26 27";
			visible = "1";
			variable = "$pref::Input::LinkMouseSensitivity";
			helpTag = "0";
			text = "LINK";
		};
		new GuiTextCtrl() {
			profile = "ShellTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "86 85";
			extent = "93 22";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Y-Axis Sensitivity:";
		};
		new GuiTextCtrl(MouseYText) {
			profile = "ShellAltTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "184 85";
			extent = "28 20";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "(0.5)";
		};
		new ShellSliderCtrl(MouseYSlider) {
			profile = "ShellSliderProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "96 100";
			extent = "170 24";
			minExtent = "12 24";
			visible = "1";
			variable = "value";
			altCommand = "MouseYSlider.sync();";
			helpTag = "0";
			range = "0.000000 1.000000";
			ticks = "1000";
			value = "0.480769";
			usePlusMinus = "1";
		};
		new ShellToggleButton(InvertMouseTgl) {
			profile = "ShellRadioProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "125 138";
			extent = "140 30";
			minExtent = "26 27";
			visible = "1";
			helpTag = "0";
			text = "INVERT Y-AXIS";
		};
		// begin mouse wheel option panels
		new GuiTextCtrl() {
			profile = "ShellTextRightProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "47 183";
			extent = "110 22";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Mouse Wheel:";
		};
		new ShellPopupMenu(MouseZActionMenu) {
			profile = "ShellPopupProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "159 174";
			extent = "180 36";
			minExtent = "49 36";
			visible = "1";
			helpTag = "0";
			maxPopupHeight = "200";
			buttonBitmap = "gui/shll_pulldown";
			rolloverBarBitmap = "gui/shll_pulldownbar_rol";
			selectedBarBitmap = "gui/shll_pulldownbar_act";
			noButtonStyle = "0";
		};
		new GuiTextCtrl() {
			profile = "ShellTextRightProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "47 223";
			extent = "110 22";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Alt+Mouse Wheel:";
		};
		new ShellPopupMenu(MouseAltZActionMenu) {
			profile = "ShellPopupProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "159 214";
			extent = "180 36";
			minExtent = "49 36";
			visible = "1";
			helpTag = "0";
			maxPopupHeight = "200";
			buttonBitmap = "gui/shll_pulldown";
			rolloverBarBitmap = "gui/shll_pulldownbar_rol";
			selectedBarBitmap = "gui/shll_pulldownbar_act";
			noButtonStyle = "0";
		};
		new GuiTextCtrl() {
			profile = "ShellTextRightProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "47 263";
			extent = "110 22";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Ctrl+Mouse Wheel:";
		};
		new ShellPopupMenu(MouseCtrlZActionMenu) {
			profile = "ShellPopupProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "159 254";
			extent = "180 36";
			minExtent = "49 36";
			visible = "1";
			helpTag = "0";
			maxPopupHeight = "200";
			buttonBitmap = "gui/shll_pulldown";
			rolloverBarBitmap = "gui/shll_pulldownbar_rol";
			selectedBarBitmap = "gui/shll_pulldownbar_act";
			noButtonStyle = "0";
		};
		new GuiTextCtrl() {
			profile = "ShellTextRightProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "47 303";
			extent = "110 22";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Shift+Mouse Wheel:";
		};
		new ShellPopupMenu(MouseShiftZActionMenu) {
			profile = "ShellPopupProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "159 294";
			extent = "180 36";
			minExtent = "49 36";
			visible = "1";
			helpTag = "0";
			maxPopupHeight = "200";
			buttonBitmap = "gui/shll_pulldown";
			rolloverBarBitmap = "gui/shll_pulldownbar_rol";
			selectedBarBitmap = "gui/shll_pulldownbar_act";
			noButtonStyle = "0";
		};		

	};
};
//--- OBJECT WRITE END ---