// #autoload
// #name = madMortarTimer
// #version = 0.0
// #status = ghetto
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts

// when you fire a mortar, a timer starts (and is displayed in a hud).  each time a mortar is fired the timer resets.

$mortarTimer::keyBind = false;
$mortarTimer::active = true;
$mortarTimer::timeout = 10;

function resetMortarTimer()
{
	if($mortarTimer::active)
	{
		mortarTimerHud.setVisible(true);
		$mortarTimer::startTime = getSimTime();
		echo($mortarTimer::startTime);
		updateMortarTimer();
	}
}

function updateMortarTimer()
{
	cancel($mortarTimer::schedule);
	%currentTimer = ((getSimTime() - $mortarTimer::startTime) / 1000);
	mortarTimerText.setText(%currentTimer);
	if(%currentTimer > $mortarTimer::timeout)
		clearMortarTimer();	
	else	
		$mortarTimer::schedule = schedule(1000, 0, updateMortarTimer);
}

function clearMortarTimer()
{
	echo("clearing mortar timer");
	cancel($mortarTimer::schedule);
	mortarTimerHud.setVisible(false);
}

function toggleMortarTimer(%val)
{
	if(%val)
		$mortarTimer::active = !$mortarTimer::active;
}

function mortarTimerHudCreate()
{
	mortarTimerHudDestroy();
	
	new ShellFieldCtrl(mortarTimerHud)
	{
		profile = "GuiDefaultProfile";
		horizSizing = "right";
		vertSizing = "center";
		position = "300 250";  
		extent = "64 20";
		minExtent = "8 8";
		visible = "1";
				
		new GuiMLTextCtrl(mortarTimerText)
		{
			profile = "clockProfile";
			horizSizing = "left";
			vertSizing = "top";
			position = "2 2";
			extent = "58 16";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};		
	};
	
	playGui.add(mortarTimerHud);		
	
}

function mortarTimerHudDestroy()
{
	if(isObject(mortarTimerHud))
	{
		playGui.remove(mortarTimerHud);
		mortarTimerHud.delete();
	}
}

package MortarTimerPackage
{
	function LoadingGui::onWake(%this)
	{
		mortarTimerHudCreate();
		parent::onWake(%this);		
	}
		
	function OptionsDlg::onWake(%this)
	{
		if(!$mortarTimer::keyBind)
		{
			$RemapName[$RemapCount] = "\c5toggle mortar timer";
			$RemapCmd[$RemapCount] = "toggleMortarTimer";
			$RemapCount++;	
			
			$RemapName[$RemapCount] = "\c5clear mortar timer";
			$RemapCmd[$RemapCount] = "clearMortarTimer";
			$RemapCount++;
						
			$mortarTimer::keyBind = true;
		}
		
		parent::onWake(%this);
	}
	
	function clientCmdSetWeaponsHudAmmo(%slot, %ammoAmount)
	{
		if(%slot == 7)
		{
			$mortarAmmoCurrent = %ammoAmount;
			if($mortarAmmoOld - $mortarAmmoCurrent == 1)
				resetMortarTimer();
			$mortarAmmoOld = $mortarAmmoCurrent;
		}
	
		parent::clientCmdSetWeaponsHudAmmo(%slot, %ammoAmount);
	}		
	
	function clientCmdSetWeaponsHudClearAll()
	{
		parent::clientCmdSetWeaponsHudClearAll();
		$mortarAmmoOld = 0;
	}
	
	function clientCmdSetWeaponsHudItem(%slot, %ammoAmount, %addItem)
	{
		if(%addItem && (%slot == 7))
			$mortarAmmoOld = %ammoAmount;
		parent::clientCmdSetWeaponsHudItem(%slot, %ammoAmount, %addItem);
	}
};
activatePackage(MortarTimerPackage);
