// #autoload
// #name = madLoadout
// #version = 0.6
// #status = release
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #credit = Crunchy

// update - removed mousewheel loadout cycling - will move to a seperate script
// update - fixed a problem when not bringing up the inv hud before using quickpacks
// update - added support for multiple quickpacks


if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::loadouthud::loaded)
{
	$madPref::loadouthud::popup = true;
	$madPref::loadouthud::loaded = true;
	$madPref::loadouthud::echo = false;
}

if(!isObject(madLoadout))
{
	new ScriptObject(madLoadout)
	{
		class = madLoadout;
		
		echo = false;  // echo loadout selections in chat hud
	};
}

function madLoadout::popup(%this)
{
	madLoadoutHud.setVisible(true);
	madLoadoutHud.schedule(8000, 0, setVisible, false);
}
	
function madLoadout::destroy(%this)
{
	if(isObject(madLoadoutHud))
	{
		playGui.remove(madLoadoutHud);
		madLoadoutHud.delete();
	}		
}
	
function madLoadout::create(%this)
{
	%this.destroy();
	
	new ShellFieldCtrl("madLoadoutHud")
	{
		profile = "HudScoreProfile";
		horizSizing = "left";
		vertSizing = "bottom";
		position = "0 0";  // should be able to use = %x SPC %y
		extent = "130 46";
		minExtent = "8 8";
		visible = "0";
				
		new GuiMLTextCtrl(madLoadoutText)
		{
			profile = "madLoadoutProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "3 5";
			extent = "124 16";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};
	
		new GuiMLTextCtrl(madPackText)
		{
			profile = "madLoadoutProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "3 21";
			extent = "124 16";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};
	
	};

	playgui.add(madLoadoutHud);			
}

package madLoadoutPackage
{
	// handle suppression of chat hud messages
	// will probably need a couple of extra functions here to handle quick packs and such
		
	function loadFavorite(%index, %echo)
	{
		parent::loadFavorite(%index, $madPref::loadouthud::echo);
		
		%current = "<just:center><color:ffffff>" @ $pref::FavNames[%index];
		madLoadoutText.setText(%current);
		madLoadout.loadout = $pref::Favorite[%index];
		
		// determine pack (from Crunchy's double faves until i look into other ways to do it)
		%armor = getField($pref::Favorite[%index], 1);
		switch$(%armor)
		{
			case "Scout":
				%pack = getField($pref::Favorite[%index], 9);
			case "Assault":
				%pack = getField($pref::Favorite[%index], 11);
			case "Juggernaut":
				%pack = getField($pref::Favorite[%index], 13);
		}
		%pack = "<just:center><color:00ffff>" @ %pack;
		madPackText.setText(%pack);

		if($madPref::loadouthud::popup)
			madLoadout.popup();	
	}
	
	// editing this function to mute chat hud messages and port to loadout hud
	
	function addQuickPackFavorite( %pack, %item )
	{
		if(%item $= "")
			%item = "Pack";
		%packFailMsg = "You cannot use that equipment with your selected loadout.";
		if ( !isObject($Hud['inventoryScreen'].staticData[1, 1]) || $Hud['inventoryScreen'].staticData[1, 1].getValue() $= ""  ) 
		{
			//if the player hasnt brought up the inv screen we use his current fav
			%currentFav = madLoadout.loadout;

			for ( %i = 0; %i < getFieldCount( %currentFav ); %i++ ) 
			{
				%type = getField( %currentFav, %i );
				%equipment = getField( %currentFav, %i++ );
				
				%invalidPack = checkPackValidity(%pack, %equipment, %item );
				if(%invalidPack)
				{
					addMessageHudLine( %packFailMsg );
					return;
			
				}
			// Success--------------------------------------------------
				if ( %type $= %item )
					%favList = %favList @ %type TAB %pack @ "\t";
				else 
					%favList = %favList  @ %type TAB %equipment @ "\t";  
			}
			madLoadout.loadout = %favList;
		}
		else 
		{
			//otherwise we go with whats on the invScreen (even if its asleep)
			%armor =  $Hud['inventoryScreen'].data[0, 1].getValue();
			
			// check pack validity with armor
			%invalidPack = checkPackValidity(%pack, %armor, %item );
			if(%invalidPack)
			{
				addMessageHudLine( %packFailMsg );
				return;
			
			}
		   	%favList = $Hud['inventoryScreen'].data[0, 1].type TAB %armor;
			for ( %i = 1; %i < $Hud['inventoryScreen'].count; %i++ ) 
			{
				%type = $Hud['inventoryScreen'].data[%i, 1].type;
				%equipment = $Hud['inventoryScreen'].data[%i, 1].getValue();

				if(%type $= %item)
					%equipment = %pack;
			
			// Special Cases again------------------------------------------------
				%invalidPack = checkPackValidity(%pack, %equipment, %item );
				if(%invalidPack)
				{
					addMessageHudLine( %packFailMsg );
					return;
				
				}

				%favList = %favList TAB %type TAB %equipment;
			}
			madLoadout.loadout = %favList;			
		}
		commandToServer( 'setClientFav', %favList );

		if($madPref::loadouthud::echo)
			addMessageHudLine( "Inventory updated to " @ %pack @ "." );
		%pack = "<just:center><color:ffff00>" @ %pack;
		madPackText.setText(%pack);
		if($madPref::loadouthud::popup)
			madLoadout.popup();	
	}	
	
	// create hud for loadout display
	
	function LoadingGui::onWake(%this)
	{
		parent::onWake(%this);

		madLoadout.create();
		madLoadoutHud.setVisible(!$madPref::loadouthud::popup);
		
		if(isObject(HudMover))
			hudmover::addhud(madLoadoutHud, "loadout hud");	
	}
	
	
};
activatePackage(madLoadoutPackage);

new GuiControlProfile("madLoadoutProfile")
{
	fontType = "Univers Condensed";
	fontSize = 16;
	fontColor = "255 255 255";
	justify = "center"; 				
};