// #autoload
// #name = madKill
// #version = 1.0
// #author = Monk
// #warrior = tao|Mad Monk
// #description = kill/teamkill popup 
// #category = Monk's scripts
// #include = support/team_tracker.cs
// #include = support/callback.cs

if(!isObject(madKill))
{
	new ScriptObject(madKill)
	{
		class = madKill;
		
		killColor[0] = "ffffff";
		killColor[1] = "00ff00";
		duration = 3000;
	};
}

package madKillPackage
{
	function DispatchLaunchMode()
	{
		parent::DispatchLaunchMode();
		madKill.setup();
	} // end function DispatchLaunchMode

	function LoadingGui::onWake(%this)
	{
		madKill.create();
		madKillHud.setVisible(false);
						
		if(isObject(HudMover))
			hudmover::addhud(madKillHud, "kill popup");
		
		parent::onWake(%this);	
	}
	
	function madKill::setup()
	{
		callback.add(CallbackMsgLegitKill, "madKill.onKill");
		callback.add(CallbackMsgHeadShotKill, "madKill.onKill");
		callback.add(CallbackMsgVehicleKill, "madKill.onTurretKill");
		callback.add(CallbackMsgCTurretKill, "madKill.onTurretKill");
		callback.add(CallbackMsgTeamKill, "madKill.onTeamKill");
		
		new GuiControlProfile("madKillText")
		{
			fontType = "Univers";
			fontSize = 16;
			fontColor = "255 255 0";
			justify = "center"; 				
		};
	} // end function setup	

	// kill handling functions
	
	function madKill::onKill(%this, %msgType, %msgString, %victimName, %vgen, %vposs, %killerName, %kgen, %kposs, %damageType, %weapon)
	{
		%killer = detag(%killerName);
		%victim = detag(%victimName);
				
		if(%killer $= teamTracker.myName && %victim !$= teamTracker.myName)
		{
			// insert kill popup routines	
			%damageType = detag(%damageType);
			%weapon = detag(%weapon);
			%tag = "<just:center><color:" @ madKill.killColor[0] @ ">";
			%message = %tag @ "You smacked " @ %victim @ " with your " @ %weapon;
			madKillText.setText(%message);
			madKill.popup();
		}
		else
			return;
	}  // end function onKill
	
	function madKill::onTeamKill(%this, %msgType, %msgString, %victimName, %vgen, %vposs, %killerName, %kgen, %kposs, %damageType, %weapon)
	{
		%killer = detag(%killerName);
		if(%killer $= teamTracker.myName)
		{
			%tag = "<just:center><color:" @ madKill.killColor[1] @ ">";
			%message = %tag @ "wtf!  wrong team!";
			madKillText.setText(%message);
			madKill.popup();
		}
		else
			return;		
	} // end function onTeamKill
	
	function madKill::onTurretKill(%this, %msgType, %msgString, %victimName, %vgen, %vposs, %killerName, %kgen, %kposs, %damageType, %weapon)
	{
		%killer = detag(%killerName);
		%victim = detag(%victimName);
		
		if(%killer $= teamTracker.myName)
		{
			if(teamTracker.getPlayerTeamId(%victim) == teamTracker.friendlyTeamID)
			{
				%tag = "<just:center><color:" @ madKill.killColor[1] @ ">";
				%message = %tag @ "wtf!  wrong team!";
				madKillText.setText(%message);
				madKill.popup();
			}				
			else
			{
				%damageType = detag(%damageType);
				%weapon = detag(%weapon);
				%tag = "<just:center><color:" @ madKill.killColor[0] @ ">";
				%message = %tag @ "You smacked " @ %victim @ " with your " @ %weapon;
				madKillText.setText(%message);
				madKill.popup();
			}						
		}
		else
			return;	
	}
		
	function madKill::popup()
	{
		madKillHud.setVisible(true);

		if (madKillHud.schedule !$= "")
		{
			cancel(madKillHud.schedule);
			madKillHud.schedule = "";
		}
		madKillHud.schedule = schedule(madKill.duration, 0, eval, "madKillHud.setVisible(false);");		
	} // end function popup
	
	
	// hud functions

	function madKill::create()
	{
		madKill.destroy();
		
		%xCenter = getword($pref::Video::resolution, 0) / 2;
		%yCenter = getword($pref::Video::resolution, 1) / 2;
		%x = %xCenter - 200;
		%y = %yCenter + 120;
		
		
		new ShellFieldCtrl("madKillHud")
		{
			profile = "GuiDefaultProfile";
			horizSizing = "center";
			vertSizing = "center";
			position = %x SPC %y;  // should be able to use = %x SPC %y
			extent = "400 38";
			minExtent = "8 8";
			visible = "1";
					
			new GuiMLTextCtrl(madKillText)
			{
				profile = "madKillText";
				horizSizing = "center";
				vertSizing = "top";
				position = "3 4";
				extent = "396 16";
				minExtent = "8 8";
				visible = "1";
				helpTag = "0";
				lineSpacing = "2";
				allowColorChars = "1";
				maxChars = "-1";
			};			
		};		
		
		playgui.add(madKillHud);
		
	} // end function create
	
	function madKill::destroy()
	{
		if(isObject(madKillHud))
		{
			playGui.remove(madKillHud);
			madKillHud.delete();
		}		
	} // end function destroy	


}; // end package
activatePackage(madKillPackage);
