// #autoload
// #name = madfps
// #version = 1.1
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = framerate hud

if(!isObject(madfps))
{
	new ScriptObject(madfps)
	{
		class = madfps;

		label = "<color:ffff00>FPS:<color:ffffff> ";
	};
}

function madfps::create(%this)
{
	%this.destroy();

	new ShellFieldCtrl(madfpsHud)
	{
		profile = "GuiDefaultProfile";
		horizSizing = "right";
		vertSizing = "center";
		position = "0 70";  
		extent = "64 20";
		minExtent = "8 8";
		visible = "1";
					
		new GuiMLTextCtrl(madfpsHudText)
		{
			profile = "madStatusHudProfile";
			horizSizing = "left";
			vertSizing = "top";
			position = "2 2";
			extent = "58 16";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
		};		
	};
		
	playGui.add(madfpsHud);
} // end function create
	
function madfps::destroy(%this)
{
	if(isObject(madfpsHud))
	{
		playGui.remove(madfpsHud);
		madfpsHud.delete();
	}
} // end function destroy
	
function madfps::update(%this)
{
	madfpsHudText.setText(%this.label @ mFloor($fps::real));
	cancel(%this.updateThread);
	%this.updateThread = %this.schedule(1000, update);		
} // end function update

package madfpsPackage
{
	function LoadingGui::onWake(%this)
	{
		madfps.create();
		madfps.update();
		madfpsHud.setVisible(true);
		
		if(isObject(HudMover))
			hudmover::addhud(madfpsHud, "fps hud");
				
		parent::onWake(%this);
	} // end function onWake
}; // end package
activatePackage(madfpsPackage);

new GuiControlProfile("madStatusHudProfile")
{
	fontType = "Univers Condensed";
	fontSize = 16;
	fontColor = "0 0 0";
	justify = "center";
};