// #autoload
// #name = madDeploy
// #version = 2.2
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = brings up deploy sensor when you acquire a deployable pack, auto-announces remote inv deployment
// #include = support/loadout.cs
// #include = support/callback.cs
// #include = support/mute_tools.cs

// maybe add messages for other deploy events? - left out so far due to excess chat spam

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::deploy::loaded)
{
	$madPref::deploy::announce = true;
	$madPref::deploy::loaded = true;
}

if(!isObject(madDeploy))
{
	new ScriptObject(madDeploy)
	{
		class = madDeploy;

	};
}

function madDeploy::test(%this)
{
	if(strstr(loadout.getPack(), "Deployable") != -1)
	{
		%this.pack = loadout.getPack();
		useBackPack(true);
	}			
}

function madDeploy::announceAtInv(%this, %msgType, %msgString)
{
	if(strstr(%msgString, "Inventory") != -1 && $madPref::deploy::announce)
	{		
		%msg = detag(%msgString);
		%msg = strreplace(%msg, "Your team has", "We have");
		commandToServer('TeamMessageSent', %msg);
	}
}
	
function madDeploy::announceDeploy(%this, %msgType, %msgString)
{
	if(%this.pack $= "InventoryDeployable"  && $madPref::deploy::announce)
	{
		%msg = "\c2[\c3 Remote Inv deployed \c2]";
		commandToServer('TeamMessageSent', %msg);
	}			
}

package madDeployPackage
{
	function clientCmdSetWeaponsHudActive(%slot, %ret, %vis)
	{
		parent::clientCmdSetWeaponsHudActive(%slot, %ret, %vis);
		if(strstr(loadout.getPack(), "Deployable") != -1)
		{
			madDeploy.pack = loadout.getPack();
			schedule(100, 0, eval, "useBackPack(true);");	
		}
	}

	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		parent::quit();
	} // end prefs save
}; // end package
activatePackage(madDeployPackage);

callback.add(CallbackMsgDeployFailed, "useBackPack(true);");
callback.add(CallbackMsgItemPickup, "madDeploy.test();");
callback.add(CallbackMsgTeamDeploySuccess, "madDeploy.test();");
callback.add(CallbackMsgTeamDepObjCount, "madDeploy.announceAtInv");
callback.add(CallbackMsgTeamDeploySuccess, "madDeploy.announceDeploy");