// #autoload
// #name = madCenterPrint
// #version = 2.1
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = options for center print and bottom print
// #credits = MeBaD

$madCprint::keyList = false;

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::cprint::loaded)
{
	$madPref::cprint::transCenterPrint = true;
	$madPref::cprint::transBottomPrint = true;
	$madPref::cprint::noCenterPrint = true;
	$madPref::cprint::loaded = true;
}

function clearCtrPrint(%val) // keybind to clear centerprint messages
{
	if(%val)
		clientCmdClearCenterPrint();
	else
		return;
} // end function clearCtrPrint

package madCenterPrintPackage
{
	function OptionsDlg::onWake(%this)
	{
		if(!$madCprint::keyList)
		{
			// bind key to clear center print messages
			$RemapName[$RemapCount] = "\c5clear center print";
			$RemapCmd[$RemapCount] = "clearCtrPrint";
			$RemapCount++;
		
			$madCprint::keyList = true;
		}
		parent::onWake(%this);
	} // end function OptionsDlg::onWake
	
	function clientCmdCenterPrint(%message, %time, %lines)
	{
		if($madPref::cprint::noCenterPrint)
			clientCmdBottomPrint(%message, %time, %lines);
		else
			parent::clientCmdCenterPrint(%message, %time, %lines);
	} // end function clientCmdCenterPrint
					
	function clientCmdClearCenterPrint()
	{
		if($madPref::cprint::noCenterPrint)
			clientCmdClearBottomPrint();
		parent::clientCmdClearCenterPrint();
	} // end function clientCmdClearCenterPrint
	
	function DispatchLaunchMode()
	{
		parent::DispatchLaunchMode();
		if($madPref::cprint::transBottomPrint)
			BottomPrintDlg.profile = "GuiConsoleProfile";
		if($madPref::cprint::transCenterPrint)
			CenterPrintDlg.profile = "GuiConsoleProfile";		
	} // end function DispatchLaunchMode

	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	} // end function quit

}; // end package
activatePackage(madCenterPrintPackage);
	
			