// #autoload
// #name = madChainZoom
// #version = 2.0
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = changes fov when you start chaining, restores it when you stop - no effect when zooming

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::chainzoom::loaded)
{
	$madPref::chainzoom::fov = 90;
	$madPref::chainzoom::loaded = true;
}

package madChainZoomPackage
{
	function mouseFire(%val)
	{
		parent::mouseFire(%val);
		
		if(!$ZoomOn) // don't want to interfere with manual zooming
		{
			if(%val && $madChainZoom::zoom)
				setFov($madPref::chainzoom::fov);
			else
				setFov($pref::Player::defaultFov);
		}
	} // end function mouseFire

   	function clientCmdSetWeaponsHudActive(%slot, %ret, %vis)
    	{
		parent::clientCmdSetWeaponsHudActive(%slot, %ret, %vis);
		if(%slot == 2 || %slot == 13) // updated to work for tr2 chaingun
			$madChainZoom::zoom = true;
		else
		{
			$madChainZoom::zoom = false;
			if(!$ZoomOn)
				setFov($pref::Player::defaultFov); // just making sure proper fov was restored
		}
	} // end function clientCmdSetWeaponsHudActive

	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	} // end function quit
	
}; // end package
activatePackage(madChainZoomPackage);
