// #autoload
// #name = madAutoChat
// #version = 3.2
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = automated chat messages for various events
// #include = support/callback.cs
// #include = support/loadout.cs
// #include = support/mute_tools.cs

// anything else to add?

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::autochat::loaded)
{
	$madPref::autochat::flagGrab = true;
	$madPref::autochat::genBoom = true;
	$madPref::autochat::genRep = true;
	$madPref::autochat::vPadBoom = true;
	$madPref::autochat::vPadRep = true;
	$madPref::autochat::turretBoom = true;
	$madPref::autochat::turretRep = true;
	$madPref::autochat::announceRepairs = true;
	$madPref::autochat::announceDeath = false; // this one's annoying unless needed
	$madPref::autochat::announceDeps = true;	
	$madPref::autochat::loaded = true;
}


if(!isObject(madAutoChat))
{
	new ScriptObject(madAutoChat)
	{
		class = madAutoChat;

		// initializations (don't change these)
		depInvs = 0;
		depTurrets = 0;
	};
}


function madAutoChat::setup()
{		
	callback.add(CallbackMsgCTFFlagTaken, "madAutoChat.flagGrabbed");
	callback.add(CallbackMsgCTFFlagDropped, "madAutoChat.helpCancel");
	callback.add(CallbackMsgCTFFlagCapped, "madAutoChat.helpCancel");
	
	callback.add(CallbackMsgGenDes, "madAutoChat.genDestroyed");
	callback.add(CallbackMsgGenRep, "madAutoChat.genRepaired");
	
	callback.add(CallbackMsgVSDes, "madAutoChat.vPadDestroyed");
	callback.add(CallbackMsgVStationRep, "madAutoChat.vPadRepaired");
	
	callback.add(CallbackMsgTurretDes, "madAutoChat.turretDestroyed");
	callback.add(CallbackMsgTurretRep, "madAutoChat.turretRepaired");
	
	callback.add(CallbackMsgRepairPackRepairingObj, "madAutoChat.repairing");
	callback.add(PlayerDeath, "madAutoChat.announceDeath");

	// deployable tracking
	callback.add(CallbackMsgDepTurDes, "madAutoChat.depTurretDestroyed");
	callback.add(CallbackMsgDepInvDes, "madAutoChat.depInvDestroyed");
} // end function setup
	
function madAutoChat::genDestroyed(%this, %msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7)
{
	if((strstr(%msgString, "You received a") != -1) && $madPref::autochat::genBoom)
	{
		%message = "== enemy generator destroyed ==~wene.generator";
		commandToServer('TeamMessageSent', %message);
	}	
} // end function genDestroyed

function madAutoChat::vPadDestroyed(%this, %msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7)
{
	if((strstr(%msgString, "You received a") != -1) && $madPref::autochat::vPadBoom)	
	{
		%message = "== enemy v-pad destroyed ==~wene.vehicle";
		commandToServer('TeamMessageSent', %message);
	}
} // end function vPadDestroyed

function madAutoChat::turretDestroyed(%this, %msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7)
{
	if((strstr(%msgString, "You received a") != -1) && $madPref::autochat::turretBoom)	
	{	
		%message = "== enemy base turret destroyed ==~wene.turrets";
		commandToServer('TeamMessageSent', %message);
	}
} // end function turretDestroyed

function madAutoChat::genRepaired(%this, %msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7)
{
	if((strstr(%msgString, "You received a") != -1) && $madPref::autochat::genRep)		
	{
		%message = "-- gens are back online --~wself.rep.generator";
		commandToServer('TeamMessageSent', %message);
	}
} // end function genRepaired

function madAutoChat::vPadRepaired(%this, %msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7)
{
	if((strstr(%msgString, "You received a") != -1) && $madPref::autochat::vPadRep)		
	{
		%message = "-- v-pad back online --~wself.rep.vehicle";
		commandToServer('TeamMessageSent', %message);
	}
} // end function vPadRepaired		
			
function madAutoChat::turretRepaired(%this, %msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7)
{
	if((strstr(%msgString, "You received a") != -1) && $madPref::autochat::turretRep)		
	{
		%message = "-- base turret back online --~wself.rep.turrets";
		commandToServer('TeamMessageSent', %message);
	}
} // end function turretRepaired 	
			
function madAutoChat::repairing(%this, %msgType, %msgString, %tgtName, %repTgt)
{
	if($madPref::autochat::announceRepairs)
	{
		%message = "\c2[ \c3" @ detag(%msgString) @ " \c2]";
		commandToServer('TeamMessageSent', %message);
	}
} // end function repairing

function madAutoChat::announceDeath(%this)
{
	if($madPref::autochat::announceDeath)
	{
		%message = "\c2[ \c3DEAD / Out of Position \c2]";
		commandToServer('TeamMessageSent', %message);
	}
	if(%this.depDestroyed && $madPref::autochat::announceDeps)
	{
		%message = "\c2[ \c3" @ %this.depTurrets @ " Turrets \c2] [ \c3" @ %this.depInvs @ " Remote Invs \c2] \c3killed this run";
		commandToServer('TeamMessageSent', %message);
		
		%this.depTurrets = 0;
		%this.depInvs = 0;
		%this.depDestroyed = false;		
	}
} // end function announceDeath
	
// deployable tracking
	
function madAutoChat::depTurretDestroyed(%this, %msgType, %msgString, %score)
{
	if(!%this.depDestroyed)
		%this.depDestroyed = !%this.depDestroyed;
	%this.depTurrets++;
} // end function depTurretDestroyed

function madAutoChat::depInvDestroyed(%this, %msgType, %msgString, %score)
{
	if(!%this.depDestroyed)
		%this.depDestroyed = !%this.depDestroyed;
	%this.depInvs++;
} // end function depInvDestroyed

// flag grab functions
	
function madAutoChat::flagGrabbed(%this, %msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType)
{
	if($madPref::autochat::flagGrab)
	{
		if(strstr(%msgString, "You took the") != -1)
		{
			%speed = mFloor(getControlObjectSpeed()) * 3.6;
			if(loadout.getRepairKit() > 0)
				%kit = "\c2have rep kit!";
			else
				%kit = "\c2NO rep kit!";
			%message = "\c1[ \c2" @ %speed @ " kph \c1] - \c1[" @ %kit @ "\c1]~wflg.flag";
			commandToServer('TeamMessageSent', %message);
			%this.gotIt = %this.schedule(3000, helpMe);
		}
	}
} // end function flagGrabbed
	
function madAutoChat::helpMe(%this)
{
	commandToServer('CannedChat', 'ChatHelp', false);
} // end function helpMe
	
function madAutoChat::helpCancel(%this, %msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType)
{
	%youDroppedIt = (strstr(%msgString, "You dropped the") != -1);
	%youCappedIt = (strstr(%msgString, "You captured the") != -1);
	if(%youDroppedIt || %youCappedIt)
		cancel(%this.gotIt);
} // end function helpCancel

package madAutoChatPackage
{
	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	} // end function quit
}; // end package
activatePackage(madAutoChatPackage);		

madAutoChat.setup();

					