// #autoload
// #name = madAmmo
// #version = 3.2
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = includes info on grenades and health kit in a revised ammo hud - hudmover compatible
// #status = final
// #credit = Ego for the idea about the rep kit indicator

// updating to allow user-selected item info in ammo hud (including beacons for Shin)
// also changed font, and repair kit representation because i liked Ego's idea

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::ammohud::loaded)
{
	$madPref::ammohud::showGrenades = true;
	$madPref::ammohud::showMines = true;
	$madPref::ammohud::showKit = true;
	$madPref::ammohud::showBeacons = false;	
	$madPref::ammohud::hideInvHud = true;
	$madPref::ammohud::hideWpnHud = true;
	$madPref::ammohud::loaded = true;
}

if(!isObject(madAmmo))
{
	new ScriptObject(madAmmo)
	{
		class = madAmmo;
		
	};
}

function madAmmo::update(%this)
{
	%update = %this.ammo;
	if($madPref::ammohud::showKit)
		%update = %update @ %this.kit;
	if($madPref::ammohud::showGrenades)
		%update = %update @ "\n" @ %this.grenades;
	if($madPref::ammohud::showMines)
		%update = %update @ "\n" @ %this.mines;
	if($madPref::ammohud::showBeacons)
		%update = %update @ "\n" @ %this.beacons;
	madAmmoHudText.setText(%update);		
}

function madAmmo::create(%this)
{
	%this.destroy();
	
	new ShellFieldCtrl("madAmmoHud")
	{
		profile = "GuiConsoleProfile";
		horizSizing = "left";
		vertSizing = "bottom";
		position = "100 100";  // should be able to use = %x SPC %y
		extent = "36 52";
		minExtent = "8 8";
		visible = "1";
				
		new GuiMLTextCtrl(madAmmoHudText)
		{
			profile = "madAmmoHudProfile";
			horizSizing = "left";
			vertSizing = "bottom";
			position = "3 3";
			extent = "33 10";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			lineSpacing = "1";
			allowColorChars = "1";
			maxChars = "-1";
		};
	};		
	
	playgui.add(madAmmoHud);
} // end function madAmmo::create
	
function madAmmo::destroy(%this)
{
	if(isObject(madAmmoHud))
	{
		playGui.remove(madAmmoHud);
		madAmmoHud.delete();
	}
} // end function madAmmo::destroy

package madAmmoPackage
{
	function LoadingGui::onWake(%this)
	{
		madAmmo.create();
		madAmmoHud.setVisible(true);
								
		if(isObject(HudMover))
			hudmover::addhud(madAmmoHud, "new ammo hud");
					
		parent::onWake(%this);
	}  // end function LoadingGui::onWake
			
	// handle ammo and inv updating (rewritten)
	
	function clientCmdSetAmmoHudCount(%amount)
	{
		parent::clientCmdSetAmmoHudCount(%amount);
		if(%amount == -1)
			madAmmo.ammo = "";
		else
			madAmmo.ammo = "<color:ffffff>" @ %amount;
		madAmmo.update();		
	}
	
	// testing inventory functions
	
	function clientCmdSetInventoryHudAmount(%slot, %amount)
	{
		if(%slot == 0)
			madAmmo.grenades = "<color:ffffff>" @ %amount;
		else if(%slot == 1)
			madAmmo.mines = "<color:ffffff>" @ %amount;
		else if(%slot == 2)
			madAmmo.beacons = "<color:00ffff>" @ %amount;
		else if(%slot == 3)
		{
			if(%amount == 2)
				madAmmo.kit = "<color:00ff00>++";
			else if(%amount == 1)
				madAmmo.kit = "<color:00ff00>+";
			else
				madAmmo.kit = "<color:ff0000>-";
		}
		madAmmo.update();
		
		parent::clientCmdSetInventoryHudAmount(%slot, %amount);
	}
	
	function clientCmdSetInventoryHudClearAll()
	{
		parent::clientCmdSetInventoryHudClearAll();
		
		madAmmo.grenades = "";
		madAmmo.mines = "";
		madAmmo.beacons = "";
		madAmmo.kit = "";
		
		madAmmo.update();		
	}
	
	function ClientCmdDisplayHuds()
	{
		parent::ClientCmdDisplayHuds();
		ammoHud.setVisible(false);
		if($madPref::ammohud::hideInvHud)
			inventoryHud.setVisible(false);
		if($madPref::ammohud::hideWpnHud)
			weaponsHud.setVisible(false);
		madAmmoHud.setVisible(true);	
	}
	
	function clientcmdTogglePlayHuds(%val)
	{
		parent::clientcmdTogglePlayHuds(%val);
		ammoHud.setVisible(false);
		if($madPref::ammohud::hideInvHud)
			inventoryHud.setVisible(false);
		if($madPref::ammohud::hideWpnHud)
			weaponsHud.setVisible(false);
		madAmmoHud.setVisible(%val);
	}

	function hudFirstPersonToggled()
	{
		parent::hudFirstPersonToggled();
		ammoHud.setVisible(false);
		if($madPref::ammohud::hideInvHud)
			inventoryHud.setVisible(false);
		if($madPref::ammohud::hideWpnHud)
			weaponsHud.setVisible(false);
		madAmmoHud.setVisible($firstPerson);
	}	
	
	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	} // end prefs save
}; // end package madAmmo
activatePackage(madAmmoPackage);

new GuiControlProfile("madAmmoHudProfile")
{
	fontType = "Verdana";
	fontSize = 10;
	fontColor = "0 0 0";
	justify = "center";
};