// #autoload
// #name = mad3rdFlag
// #version = 3.1
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = flips player to 3rd person view and back on flag grab (no effect if already in 3rd person).  works for ctf and rabbit.
// #include = support/callback.cs
// #include = support/team_tracker.cs
// #include = support/mute_tools.cs

if(!isObject(mad3rdFlag))
{
	new ScriptObject(mad3rdFlag)
	{
		class = mad3rdFlag;
	
		delay = 400; // time in ms to stay in 3rd person
	};
}

function mad3rdFlag::gotFlag(%this, %msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType)
{
	if(strstr(%msgString, "You took the") != -1)
	{
		%this.pov = $firstPerson;
		if($firstPerson)
			$firstPerson = !$firstPerson;
		%this.schedule(%this.delay, restore);
	}
} // end function gotFlag	

function mad3rdFlag::rabbitGotFlag(%this, %msgType, %msgString, %rabbit, %vgen, %vposs, %killername, %kgen, %kposs, %damageType)
{
	if(detag(%rabbit) $= teamTracker.myName)
	{
		%this.pov = $firstPerson;
		if($firstPerson)
			$firstPerson = !$firstPerson;
		%this.schedule(%this.delay, restore);
	}
} // end function rabbitGotFlag
	
function mad3rdFlag::cancelView(%this, %msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType)
{
	%youDroppedIt = (strstr(%msgString, "You dropped the") != -1);
	%youCappedIt = (strstr(%msgString, "You captured the") != -1);
	if(%youDroppedIt || %youCappedIt)
		%this.restore();
} // end function cancelView

function mad3rdFlag::restore(%this)
{
	$firstPerson = %this.pov;
} // end function restore

callback.add(CallbackMsgCTFFlagTaken, "mad3rdFlag.gotFlag");
callback.add(CallbackMsgCTFFlagDropped, "mad3rdFlag.cancelView");
callback.add(CallbackMsgCTFFlagCapped, "mad3rdFlag.cancelView");
callback.add(CallbackMsgRabbitFlagTaken, "mad3rdFlag.rabbitGotFlag");	
