// #autoload
// #name = mad1Ret
// #version = 3.0
// #status = final
// #author = Monk
// #warrior = tao|Mad Monk
// #category = Monk's scripts
// #description = makes it convenient to use 1 ret for everything (without having 20 ret files)

if(isFile("prefs/madPrefs.cs") && !$madPrefsLoaded)
{
	exec("prefs/madPrefs.cs");
	$madPrefsLoaded = true;
}
else if(!$madPref::1ret::loaded)
{
	$madPref::1ret::showRing = false;
	$madPref::1ret::ringOpacity = 1.0;
	$madPref::1ret::retOpacity = 1.0;
	$madPref::1ret::retFile = "gui/RET_cross.png";	
	$madPref::1ret::loaded = true;
}

package mad1RetPackage
{
	function clientCmdSetWeaponsHudActive(%slot, %ret, %vis)
	{
		parent::clientCmdSetWeaponsHudActive(%slot, %ret, %vis); // left this intact for a reason, just don't recall what it was
		
		reticleHud.opacity = $madPref::1ret::retOpacity;
		reticleFrameHud.opacity = $madPref::1ret::ringOpacity;
		reticleHud.setBitmap($madPref::1ret::retFile);
		reticleFrameHud.setVisible($madPref::1ret::showRing);
	}

	function clientCmdSetRepairReticle()
	{
		parent::clientCmdSetRepairReticle();
		
		reticleHud.opacity = $madPref::1ret::retOpacity;
		reticleFrameHud.opacity = $madPref::1ret::ringOpacity;
		reticleHud.setBitmap($madPref::1ret::retFile);
		reticleFrameHud.setVisible($madPref::1ret::showRing);
	}	
	
	function quit()
	{
		if(!$madPrefsSaved)
		{
			export("$madPref::*", "prefs/madPrefs.cs", false);			
			$madPrefsSaved = true;
		}
		
		parent::quit();
	} // end prefs save	
	

};
activatePackage(mad1RetPackage);

