// #autoload
// #name = Bold Chat Hud
// #version = 1.1
// #date = June 27, 2001
// #status = final
// #author = Daniel Trevino
// #warrior = liq
// #email = liqy@swbell.net
// #web = http://www.toejamsplace.com/
// #description = Makes the ChatHud have bold text. It can also make the hud transparent.

//-------USER EDIT SECTION-------//

// Do you want the ChatHud to be transparent?
$TransChatHud = true;

// Do you want bold text in the hud?
$BoldChat = true;

//-------END USER EDIT SECTION-------//

package boldChatHud {

	function LoadingGui::onWake(%this) {

		OuterChatHud.extent = "640 " @ getWord(OuterChatHud.extent, 1);
		ChatScrollHud.extent = "636 " @ getWord(ChatScrollHud.extent, 1);
		ChatHud.extent = "636 " @ getWord(ChatHud.extent, 1);
		if ($TransChatHud) {
			OuterChatHud.profile = "GuiConsoleProfile";
		}
		if ($BoldChat) {
			createChatProfile();
		}
		parent::onWake(%this);
	}

	function createChatProfile() {

		GuiBoldChatHudProfile.delete();

		new GuiControlProfile ("GuiBoldChatHudProfile") {
			fontType = $ShellBoldFont;
			fontSize = $ShellFontSize;
			fontColor = "44 172 181";
			fontColors[1] = "4 235 105";
			fontColors[2] = "219 200 128";
			fontColors[3] = "77 253 95";
			fontColors[4] = "40 231 240";
			fontColors[5] = "200 200 50 200";
			autoSizeWidth = true;
			autoSizeHeight = true;
		};

		ChatHud.profile = "GuiBoldChatHudProfile";
	}
};
activatePackage(boldChatHud);
