// #name = borMovie
// #version = 1.3
// #date = April 14, 2002
// #author = borlaK and jsut
// #warrior = borlaK|RT
// #description = Create Movies .. basically hacked PJ's script.. Creates a folder each time you hit record, with the name of the demo and a # (ie>Ung vs Bor-001).  No overwriting.  You need to create a /base/movies folder, thx.. also you may have to restart T2 after you make the initial binds.  Batch additions by jsut
// #status = working

//
// Changes - November 20, 2002
// - fixed mod paths problem
// - added fps choosing option
// - fixed the restarting when you bind keys problem
// - fixed a bug when you open the batch gui over and over again
// - fixed some issues with the batch not saving right
//

GlobalActionMap.bind(getfield(moveMap.getBinding( "borMakeMovie" ),0), getfield(moveMap.getBinding( "borMakeMovie" ),1), borMakeMovie);
GlobalActionMap.bind(getfield(moveMap.getBinding( "borStopMovie" ),0), getfield(moveMap.getBinding( "borStopMovie" ),1), borStopMovie);
GlobalActionMap.bind(getfield(moveMap.getBinding( "borStartBatchProcess" ),0), getfield(moveMap.getBinding( "borStartBatchProcess" ),1), borStartBatchProcess);

if (!$pref::borMovie::fps){
   $pref::borMovie::fps = 30;
}

/////////////////////
// BINDED COMMANDS //
/////////////////////
function borMakeMovie(%val)
{
    if(%val && !$screenGetThread) {

        $borTimeStore = $timeAdvance;
        $timeAdvance = 1000 / $pref::borMovie::fps;

        %movieName = borCheckLastMovie();

        $screenGetThread = schedule( $timeAdvance, 0, "borMovieGetScreen", %movieName , 0);        
    }
}

function borStopMovie()
{
    cancel($screenGetThread);
    $screenGetThread = 0;
    $timeAdvance = $borTimeStore;

}

function borStartBatchProcess(%val){
    
    if (%val && !$borMovie::ingame && !$borMovie::dialogOpen) {
        borMovieCreateGUI();
        $borMovie::dialogOpen = 1;
        canvas.pushDialog("borMovieGUI");
    }
}


//////////////////////////////////////////
// BATCH AND SCREENSHOT/MOVIE FUNCTIONS //
//////////////////////////////////////////
function borMovieGetScreen(%movieName, %frameNumber)
{
    if(%frameNumber < 10)
        %frameNumber = "0" @ %frameNumber;
    if(%frameNumber < 100)
        %frameNumber = "0" @ %frameNumber;
    if(%frameNumber < 1000)
        %frameNumber = "0" @ %frameNumber;
    if(%frameNumber < 10000)
        %frameNumber = "0" @ %frameNumber;

    screenshot(%movieName @ "screen" @ %frameNumber @ ".png");

    $screenGetThread = schedule( $timeAdvance, 0, "borMovieGetScreen", %movieName , %frameNumber + 1);
}

function borCheckLastMovie()
{
    %sel = RecordingsDlgList.getSelectedId();
    %borMovieDir = getField(RecordingsDlgList.getRowTextById(%sel), 0);
    %mod = getmodpaths();
    %mod = nextToken(%mod,curmod,";");
    for(%i = 0; %i < 999; %i++)
    {
        if(%i < 10)
            %num = "0";
        if(%i < 100)
            %num = "0" @ %num;

        %filetext = "movies/" @ %borMovieDir @ "-" @ %num @ %i @ "/test";

        if(!isfile(%filetext))
        {
            %file = new FileObject();
            %file.openForWrite(%filetext);
            %file.close();
            %file.delete();
            break;
        }
    }
    return %curmod @ "/movies/" @ %borMovieDir @ "-" @ %num @ %i @ "/";
}

function borBatchme(){

    if (borReadConfig()){
        Canvas.pushDialog(RecordingsDlg);
        

        $borMovie::currentplaybackcount = 0;
        $borMovie::batch = true;
        borStartNextDemo();
    }else{
        error($borMovie::error);
    }
}

function borStartNextDemo(){    
    //echo("borStartNextDemo");
    
    if (!isobject(borjsutMovieGui)){
        createborjsutMovieGui();
        
        if ($pref::borMovie::noReticle){
            bjretCenterHud.visible = 0;
        
        }
        
        echo("created funny gui");
    }
    
    %name = $borMovie::moviequeue[$borMovie::currentplaybackcount];
    $borMovie::currentplaybackcount++;

    if (%name $= ""){
        $borMovie::batch = false;
//        echo("i guess we're done");

        OP_MasterVolumeSlider.setValue( $pref::Audio::masterVolume);
        return;
    }

    %count = 0;
    %found = false;
    
    %rowText = RecordingsDlgList.getRowTextByID(%count);
    while(%rowText !$= "" && !%found){        
        %file = getField(%rowText, 0);

        if (%name $= %file){
            RecordingsDlgList.setSelectedByID(%count);
            %found = true;
            //echo("selectedit");
        }
        %count++;
        %rowText = RecordingsDlgList.getRowTextByID(%count);
    }
    //echo("hihi " @ %found);
    
    if (%found) {
        //echo("starting demo?");
        StartSelectedDemo();
//        GlobalActionMap.unbind(keyboard, escape);    
//        GlobalActionMap.bind(keyboard, escape, borKillDemoByHand);
    }
}


///////////////////////
// READ/WRITE CONFIG //
///////////////////////
function borReadConfig(){
    %file = new FileObject();
    if (!%file.openForRead("borMovie.cfg")) {
        $borMovie::error = "no config file found base/borMoviecfg";
        return false;
    }

    $borMovie::moviequeuecount = 0;
    deleteVariables("$borMovie::config*");
    
    for(%i = 0; !%file.isEOF(); %i++) {
        %line = %file.readLine();
        
        $borMovie::rawconfig[%i] = %line;

        %line = nextToken(%line,filename,",");
        %stopat = nextToken(%line,startat,",");

    // make sure time is in 24hour format
        %startat = nextToken(%startat,minutes,":");
        nextToken(%startat,seconds,",");
    if(%minutes < 10 && strlen(%minutes) == 1)
        %startat = "0" @ %minutes @ ":" @ %seconds;
    else
        %startat = %minutes @ ":" @ %seconds;

        %stopat = nextToken(%stopat,minutes,":");
        nextToken(%stopat,seconds,",");
    if(%minutes < 10 && strlen(%minutes) == 1)
        %stopat = "0" @ %minutes @ ":" @ %seconds;
    else
        %stopat = %minutes @ ":" @ %seconds;
        
        //echo("filename: " @ %filename);
        //echo("startat: " @ %startat);
        //echo("stopat: " @ %stopat);
        
        %scenenum = $borMovie::config[%filename];
        if (%scenenum $= "") {
            %scenenum = 0;
            
            $borMovie::moviequeue[$borMovie::moviequeuecount] = %filename;
            $borMovie::moviequeuecount++;
        }
        
        $borMovie::config[%filename]++;
        
        $borMovie::config[%filename @ %scenenum @ "startat"] = %startat;
        $borMovie::config[%filename @ %scenenum @ "stopat"] = %stopat;
        
    }
    $borMovie::nummovies = %i;
    %file.close();
    %file.delete();

    return true;
}
function borWriteConfig(){
    %file = new FileObject();
    if (!%file.openForWrite("borMovie.cfg")) {
        $borMovie::error = "no config file found base/borMovie.cfg";
        return false;
    }
    
    %count = 0;
    %line = borMovieListDlg.getRowText(%count);
    
    while (%line !$= ""){        
        %file.writeLine(%line);
        
        %count++;
        %line = borMovieListDlg.getRowText(%count);
    }

    %file.close();
    %file.delete();
}

//////////////////////////////////
// MOVIE ADD/EDIT GUI FUNCTIONS //
//////////////////////////////////
function borMovieEdit(%num){
    //echo(%num);
    
    %startat = "";
    %stopat = "";
    %filename = "";
    
    %line = borMovieListDlg.getRowTextById(%num);
    if (%line !$= ""){
        %line = nextToken(%line,filename,",");
        %stopat = nextToken(%line,startat,",");
    }
    
    borMovieDemoList.setSelected($borMovie::filenametoid[%filename]);
    //echo(%filename);
    //echo($borMovie::filenametoid[%filename]);    
    
    borMovieStopAt.setText(%stopat);
    borMovieStartAt.setText(%startat);
    borWriteConfig();
    canvas.pushdialog(borMoviePickerGUI);
}

function borMovieAdd(%num){
    //echo(%num);
    
    %startat = borMovieStartAt.getValue();
    %stopat = borMovieStopAt.getValue();
    %filename = borMovieDemoList.getText();
    
    //echo(%filename @ %startat @ %stopat);
    
    %line = borMovieListDlg.getRowTextById(%num);
    //echo(%line);
    if (%line !$= ""){    
        //echo("exists");
        borMovieListDlg.removeRowById(%num);
        borMovieListDlg.addRow(%num,%filename @","@ %startat @","@ %stopat);
    }else{
        //echo("new");
        borMovieListDlg.addRow($borMovie::nummovies,%filename @","@ %startat @","@ %stopat);
        $borMovie::nummovies++;
    }
    
    borMovieListDlg.sort(0);
    borWriteConfig();
    canvas.popdialog(borMoviePickerGUI);
}

function borMovieDelete(%num){
    borMovieListDlg.removeRowById(%num);
    
    borMovieListDlg.sort(0);
    borWriteConfig();
    canvas.popdialog(borMoviePickerGUI);
}

/////////////////
// THE PACKAGE //
/////////////////
package borMovie {
    function OptionsDlg::onWake(%this)
    {
        if (!$borMovieSelect)
        {
            $RemapName[$RemapCount] = "Start Making Movie";
            $RemapCmd[$RemapCount]  = "borMakeMovie";
            $RemapCount++;
            $RemapName[$RemapCount] = "Stop Making Movie";
            $RemapCmd[$RemapCount]  = "borStopMovie";
            $RemapCount++;
            $RemapName[$RemapCount] = "Batch Create Movie";
            $RemapCmd[$RemapCount]  = "borStartBatchProcess";
            $RemapCount++;
            
            $borMovieSelect = true;
        }
        return parent::onWake(%this);
    }

    function OptionsDlg::onSleep(%this)
    {
        GlobalActionMap.bind(getfield(moveMap.getBinding( "borMakeMovie" ),0), getfield(moveMap.getBinding( "borMakeMovie" ),1), borMakeMovie);
        GlobalActionMap.bind(getfield(moveMap.getBinding( "borStopMovie" ),0), getfield(moveMap.getBinding( "borStopMovie" ),1), borStopMovie);
        GlobalActionMap.bind(getfield(moveMap.getBinding( "borStartBatchProcess" ),0), getfield(moveMap.getBinding( "borStartBatchProcess" ),1), borStartBatchProcess);
        return parent::onSleep(%this);
    }

    
    function StartSelectedDemo()
    {
        // first unit is filename
        %sel = RecordingsDlgList.getSelectedId();
        %rowText = RecordingsDlgList.getRowTextById(%sel);
        
        $borMovie::currentlyplaying = getField(%rowText, 0);

        parent::StartSelectedDemo();

        if($borMovie::batch && $pref::borMovie::noSound)
            OP_MasterVolumeSlider.setValue(0);
    }    
    
    function stopDemoPlayback(){
        //echo("stopdemoplayback");
        
        if ($screenGetThread){
            borStopMovie(true);
        }
        $borMovie::killdemo = false;
        
        parent::stopDemoPlayback();
    }
    
    function demoPlaybackUpdate(%msec) {        
      if ($borMovie::batch) {        


        
        %time = msToMinSec(%msec);
        %count = 0;
        %moreSections = false;
        %close = false;
        %over = true;
        
        while($borMovie::config[$borMovie::currentlyplaying @ %count @ "startat"] !$= ""){
            //echo("msec " @ %msec);
            //echo("startat " @ MinSectoms($borMovie::config[$borMovie::currentlyplaying @ %count @ "startat"]));
            //echo("stopat " @ MinSectoms($borMovie::config[$borMovie::currentlyplaying @ %count @ "stopat"]));
            
            if ( 
                 // if it's twenty seconds till our demo starts
                 (%msec + 20000 > MinSectoms($borMovie::config[$borMovie::currentlyplaying @ %count @ "startat"])
                 && %msec < MinSectoms($borMovie::config[$borMovie::currentlyplaying @ %count @ "startat"]))
                 
                 ||
                 
                 // we are in a demo
                 (%msec > MinSectoms($borMovie::config[$borMovie::currentlyplaying @ %count @ "startat"])
                 && %msec < MinSectoms($borMovie::config[$borMovie::currentlyplaying @ %count @ "stopat"]))
                 
                 ){
                 
                 //echo("close");
                 %close = true;
            }
            
            if (%msec < MinSectoms($borMovie::config[$borMovie::currentlyplaying @ %count @ "stopat"])){
                %over = false;
            }
                        
            //echo(%msec);
        //echo(MinSectoms(%time));

            if (!$borMovie::config[$borMovie::currentlyplaying @ %count @ "completed"] && !%moreSections){
                %moreSections = true;
                //echo("more to come " @ %count);
            }

            if (%time $= $borMovie::config[$borMovie::currentlyplaying @ %count @ "startat"]
                      && !$screenGetThread) {
                borMakeMovie(true);
            }
        
            if (%time $= $borMovie::config[$borMovie::currentlyplaying @ %count @ "stopat"]
                      && $screenGetThread) {
                $borMovie::config[$borMovie::currentlyplaying @ %count @ "completed"] = true;
                borStopMovie(true);
                
            }

            %count++;
        }        

        if (!%over && $pref::borMovie::noHuds && !$borMovie::noHudsInit && canvas.getContent().getName() !$= "borjsutMovieGui"){
            canvas.setContent(borjsutMovieGui);
            canvas.hideCursor();
            echo ("changing canvas");
        }
        
        if (%close || %over){
            $DemoPlaybackIndex = 5;
            updateDemoPlaybackStatus();
            
            if (%over && !$borMovie::finalreset && canvas.getContent().getName() !$= "playGui") {
                canvas.setContent(playGui);
                canvas.showCursor();
                $borMovie::finalreset = true;
                echo("back to playgui");
            }
            
        }else{
            $DemoPlaybackIndex = 8;
            updateDemoPlaybackStatus();
        }
        
        if ($borMovie::batch && !%moreSections && !$borMovie::killdemo) {
            $borMovie::killdemo = schedule( 1000, 0, "stopDemoPlayback");
        }
      }
      return parent::demoPlaybackUpdate(%msec);
    }
    
    function demoPlaybackComplete(){
        //echo("demoplaybackcomplete");

        if ($borMovie::batch){
            schedule( 2000, 0, "borStartNextDemo");
        }
        parent::demoPlaybackComplete();
    }

    function ServerConnectionAccepted(){
        
        $borMovie::ingame = true;
        return parent::ServerConnectionAccepted();
    }

    function DisconnectedCleanup(){
        $borMovie::ingame = false;
        return parent::DisconnectedCleanup();
    }

};


//////////
// GUIS //
//////////
function borMovieCreateGUI(){ 
new GuiControl(borMovieGUI) {
    profile = "DlgBackProfile";
    horizSizing = "width";
    vertSizing = "height";
    position = "0 0";
    extent = "640 480";
    minExtent = "8 8";
    visible = "1";
    hideCursor = "0";
    bypassHideCursor = "0";
    helpTag = "0";

    new ShellPaneCtrl() {
        profile = "ShellDlgPaneProfile";
        horizSizing = "center";
        vertSizing = "center";
        position = "125 47";
        extent = "390 385";
        minExtent = "48 92";
        visible = "1";
        hideCursor = "0";
        bypassHideCursor = "0";
        helpTag = "0";
        text = "borMovieBatch";
        longTextBuffer = "0";
        maxLength = "255";
        noTitleBar = "0";

        new ShellScrollCtrl() {
            profile = "NewScrollCtrlProfile";
            horizSizing = "center";
            vertSizing = "top";
            position = "20 34";
            extent = "350 211";
            minExtent = "24 52";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            helpTag = "0";
            willFirstRespond = "1";
            hScrollBar = "alwaysOff";
            vScrollBar = "dynamic";
            constantThumbHeight = "0";
            defaultLineHeight = "15";
            childMargin = "0 2";
            fieldBase = "gui/shll_field";

            new GuiScrollContentCtrl() {
                profile = "GuiDefaultProfile";
                horizSizing = "center";
                vertSizing = "center";
                position = "4 6";
                extent = "342 199";
                minExtent = "8 8";
                visible = "1";
                hideCursor = "0";
                bypassHideCursor = "0";
                helpTag = "0";

                new ShellTextList(borMovieListDlg) {
                    profile = "ShellTextArrayProfile";
                    horizSizing = "center";
                    vertSizing = "center";
                    position = "0 0";
                    extent = "342 144";
                    minExtent = "8 8";
                    visible = "1";
                    hideCursor = "0";
                    bypassHideCursor = "0";
                    altCommand = "borMovieEdit(borMovieListDlg.getSelectedID);";
                    helpTag = "0";
                    enumerate = "1";
                    resizeCell = "1";
                    columns = "0";
                    fitParentWidth = "1";
                    clipColumnText = "0";
                };
            };
        };
        new ShellBitmapButton() {
            profile = "ShellButtonProfile";
            horizSizing = "right";
            vertSizing = "top";
            position = "15 245";
            extent = "120 38";
            minExtent = "32 38";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            command = "borMovieEdit(borMovieListDlg.getSelectedID());";
            helpTag = "0";
            text = "Edit";
            simpleStyle = "0";
        };
        new ShellBitmapButton() {
            profile = "ShellButtonProfile";
            horizSizing = "right";
            vertSizing = "top";
            position = "135 245";
            extent = "120 38";
            minExtent = "32 38";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            command = "borMovieEdit($borMovie::nummovies);";
            helpTag = "0";
            text = "Add";
            simpleStyle = "0";
        };
        new ShellBitmapButton() {
            profile = "ShellButtonProfile";
            horizSizing = "right";
            vertSizing = "top";
            position = "255 245";
            extent = "120 38";
            minExtent = "32 38";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            command = "borMovieDelete(borMovieListDlg.getSelectedID());";
            helpTag = "0";
            text = "Delete";
            simpleStyle = "0";
        };
        new ShellBitmapButton() {
            profile = "ShellButtonProfile";
            horizSizing = "right";
            vertSizing = "top";
            position = "135 285";
            extent = "120 38";
            minExtent = "32 38";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            command = "borWriteConfig(); borBatchme();";
            helpTag = "0";
            text = "StartBatch";
            simpleStyle = "0";
        };
        new ShellBitmapButton() {
            profile = "ShellButtonProfile";
            horizSizing = "right";
            vertSizing = "bottom";
            position = "135 325";
            extent = "120 38";
            minExtent = "32 38";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            command = "Canvas.popDialog(borMovieGUI);";
            accelerator = "escape";
            helpTag = "0";
            text = "Close";
            simpleStyle = "0";
        };
        new ShellToggleButton() {
            profile = "ShellRadioProfile";
            horizSizing = "right";
            vertSizing = "bottom";
            position = "260 290";
            extent = "103 27";
            minExtent = "26 27";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            variable = "$pref::borMovie::noHuds";
            helpTag = "0";
            text = "No Huds";
            longTextBuffer = "0";
            maxLength = "255";
        };
        new ShellToggleButton() {
            profile = "ShellRadioProfile";
            horizSizing = "right";
            vertSizing = "bottom";
            position = "22 289";
            extent = "103 30";
            minExtent = "26 27";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            variable = "$pref::borMovie::noSound";
            helpTag = "0";
            text = "No Sound";
            longTextBuffer = "0";
            maxLength = "255";
        };
        new ShellToggleButton() {
            profile = "ShellRadioProfile";
            horizSizing = "right";
            vertSizing = "bottom";
            position = "259 331";
            extent = "104 30";
            minExtent = "26 27";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            variable = "$pref::borMovie::noReticle";
            helpTag = "0";
            text = "No Reticle";
            longTextBuffer = "0";
            maxLength = "255";
        };
    	new GuiTextCtrl() {
    	    profile = "ShellMediumTextProfile";
    	    horizSizing = "right";
    	    vertSizing = "bottom";
    	    position = "25 335";
    	    extent = "30 22";
    	    minExtent = "8 8";
    	    visible = "1";
    	    helpTag = "0";
    	    text = "fps:";
    	    maxLength = "255";
    	};
	new ShellTextEditCtrl() {
	    profile = "NewTextEditProfile";
	    horizSizing = "right";
	    vertSizing = "bottom";
	    position = "45 325";
	    extent = "50 30";
	    visible = "1";
	    hideCursor = "0";
	    bypassHideCursor = "0";
	    variable = "$pref::borMovie::fps";
	    helpTag = "0";
	    maxLength = "255";
	};
    };
};
//--- OBJECT WRITE END ---
    new GuiControl(borMoviePickerGUI) {
    profile = "DlgBackProfile";
    horizSizing = "width";
    vertSizing = "height";
    position = "0 0";
    extent = "640 480";
    minExtent = "8 8";
    visible = "1";
    helpTag = "0";
    
    new ShellPaneCtrl() {
        profile = "ShellDlgPaneProfile";
        horizSizing = "center";
        vertSizing = "center";
        position = "147 142";
        extent = "500 140";
        minExtent = "48 92";
        visible = "1";
        helpTag = "0";
        text = "borMoviePicker";
        noTitleBar = "0";
    
            new ShellPopupMenu(borMovieDemoList) {
                profile = "ShellPopupProfile";
                horizSizing = "right";
                vertSizing = "bottom";
                position = "20 40";
                extent = "150 38";
                minExtent = "49 36";
                visible = "1";
                hideCursor = "0";
                bypassHideCursor = "0";
                helpTag = "0";
                text = "Choose Demo";
                longTextBuffer = "0";
                maxLength = "255";
                maxPopupHeight = "200";
                buttonBitmap = "gui/shll_pulldown";
                rolloverBarBitmap = "gui/shll_pulldownbar_rol";
                selectedBarBitmap = "gui/shll_pulldownbar_act";
                noButtonStyle = "0";
            };
            new GuiTextCtrl() {
                profile = "ShellMediumTextProfile";
                horizSizing = "right";
                vertSizing = "bottom";
                position = "180 50";
                extent = "40 38";
                minExtent = "8 8";
                visible = "1";
                helpTag = "0";
                text = "Start At:";
                maxLength = "255";
            };
            new ShellTextEditCtrl(borMovieStartAt) {
                profile = "NewTextEditProfile";
                horizSizing = "relative";
                vertSizing = "relative";
                position = "230 40";
                extent = "100 64";
                minExtent = "32 38";
                visible = "1";
                hideCursor = "0";
                bypassHideCursor = "0";
                helpTag = "0";
                maxLength = "255";
                historySize = "0";
            };
            new GuiTextCtrl() {
                profile = "ShellMediumTextProfile";
                horizSizing = "right";
                vertSizing = "bottom";
                position = "340 50";
                extent = "40 38";
                minExtent = "8 8";
                visible = "1";
                helpTag = "0";
                text = "Stop At:";
                maxLength = "255";
            };
            new ShellTextEditCtrl(borMovieStopAt) {
                profile = "NewTextEditProfile";
                horizSizing = "relative";
                vertSizing = "relative";
                position = "390 40";
                extent = "100 64";
                minExtent = "32 38";
                visible = "1";
                hideCursor = "0";
                bypassHideCursor = "0";
                helpTag = "0";
                maxLength = "255";
                historySize = "0";
            };
            new ShellBitmapButton() {
                profile = "ShellButtonProfile";
                horizSizing = "right";
                vertSizing = "bottom";
                position = "290 80";
                extent = "100 38";
                minExtent = "32 38";
                visible = "1";
                command = "borMovieAdd(borMovieListDlg.getSelectedID());";
                accelerator = "escape";
                helpTag = "0";
                text = "OK";
                simpleStyle = "0";
            };
            new ShellBitmapButton() {
                profile = "ShellButtonProfile";
                horizSizing = "right";
                vertSizing = "bottom";
                position = "390 80";
                extent = "100 38";
                minExtent = "32 38";
                visible = "1";
                command = "Canvas.popDialog(borMoviePickerGUI);";
                accelerator = "escape";
                helpTag = "0";
                text = "CLOSE";
                simpleStyle = "0";
            };
        };
    };
}

function borMovieGUI::onWake(%this){
    if (!%this.initialized) {
        borReadConfig();
        
        %count = 0;
        %text = $borMovie::rawconfig[%count];
        while (%text !$= ""){
            borMovieListDlg.addRow(borMovieListDlg.rowCount(),%text);
            %count++;
            %text = $borMovie::rawconfig[%count];
        }
        borMovieListDlg.sort(0);
        
        %search = "recordings/*.rec";
        %ct = 0;
        
        for(%file = findFirstFile(%search); %file !$= ""; %file = findNextFile(%search)){
            %fileName = fileBase(%file);
            
            borMovieDemoList.add(%fileName,%ct);
            $borMovie::filenametoid[%fileName] = %ct;
            //echo("$borMovie::filenametoid["@%fileName @"] = "@%ct);
            %ct++;      
        }
    }
}
function borMovieGUI::onSleep(%this){
    borWriteConfig();
    $borMovie::dialogOpen = 0;
}

///////////
// UTILS //
///////////
function minSectoMs(%str){
    %sec = nextToken(%str,min,":");
    
    return (%min * 60000) + (%sec * 1000);
}


function borKillDemoByHand()
{
    $borMovie::batch = 0;
    demoPlaybackComplete();
}

activatePackage(borMovie);




function createborjsutMovieGui() {

//--- OBJECT WRITE BEGIN ---
new GameTSCtrl(borjsutMovieGui) {
	profile = "GuiContentProfile";
	horizSizing = "right";
	vertSizing = "bottom";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	hideCursor = "1";
	bypassHideCursor = "0";
	helpTag = "0";
	beaconBaseTextureName = "gui/beacon_base";
	beaconTargetTextureName = "gui/crosshairs";
	beaconTargetPeriod = "4000";
	beaconsVisible = "1";
	enemyBeaconLineBeginColor = "0.000000 1.000000 0.000000 0.200000";
	enemyBeaconLineEndColor = "0.000000 1.000000 0.000000 0.800000";
	vehicleBeaconLineBeginColor = "1.000000 0.000000 0.000000 0.200000";
	vehicleBeaconLineEndColor = "1.000000 0.000000 0.000000 0.800000";
	friendBeaconLineBeginColor = "1.000000 1.000000 0.000000 0.200000";
	friendBeaconLineEndColor = "1.000000 1.000000 0.000000 0.800000";
	beaconLineWidth = "2.5";
	beaconTextYOffset = "14";
	showAlternateTarget = "0";
	frinedBeaconLineEndColor = "1 1 0 0.8";

	new GuiControl(bjretCenterHud) {
		profile = "GuiDefaultProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "192 112";
		extent = "256 256";
		minExtent = "8 8";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";
			wrap = "0";

		new HudCrosshair(bjreticleHud) {
			profile = "GuiButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "112 112";
			extent = "32 32";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			fillColor = "0.250000 0.250000 0.250000 0.250000";
			frameColor = "0.000000 1.000000 0.000000 1.000000";
			opacity = "0.5";
			bitmap = "gui/ret_blaster";
			autoCenter = "1";
			autoResize = "1";
			flipVertical = "0";
			flipHorizontal = "0";
		};
		new GuiTextCtrl(ammoHud) {
			profile = "GuiAmmoHudProfile";
			horizSizing = "left";
			vertSizing = "top";
			position = "75 150";
			extent = "80 20";
			minExtent = "8 8";
			visible = "0";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			longTextBuffer = "0";
			maxLength = "255";
		};
		new HudPulsingBitmap(deploySensor) {
			profile = "GuiButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "90 90";
			extent = "75 75";
			minExtent = "8 8";
			visible = "0";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			fillColor = "0.250000 0.250000 0.250000 0.250000";
			frameColor = "0.000000 1.000000 0.000000 1.000000";
			opacity = "0.5";
			bitmap = "gui/hud_ping";
			autoCenter = "1";
			autoResize = "1";
			flipVertical = "0";
			flipHorizontal = "0";
			color = "0 0 0 0";
			pulse = "0";
			pulseRate = "1000";
		};
		new HudCrosshair(reticleFrameHud) {
			profile = "GuiButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "96 96";
			extent = "64 64";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			fillColor = "0.250000 0.250000 0.250000 0.250000";
			frameColor = "0.000000 1.000000 0.000000 1.000000";
			opacity = "0.5";
			bitmap = "gui/hud_retrng";
			autoCenter = "1";
			autoResize = "1";
			flipVertical = "0";
			flipHorizontal = "0";
		};
	};

	new HudNavDisplay(navHud) {
		profile = "GuiHudNavProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "0 0";
		extent = "640 480";
		minExtent = "8 8";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";
		fillColor = "0.250000 0.250000 0.250000 0.250000";
		frameColor = "0.000000 1.000000 0.000000 1.000000";
		opacity = "0.5";
		autoCenter = "0";
		autoResize = "0";
		flipVertical = "0";
		flipHorizontal = "0";
		renderXYProjection = "0";
		renderEdgeMarkers = "1";
		markerHitRadius = "2";
		markerAngle = "30";
		markerLen = "20";
		defaultMarkerColor = "0 255 220 220";
		acquireScreenRadius = "75";
		playerEyeZOffset = "0.4";
		damageRectSize = "50 12";
		infoOffset = "24 24";
		minProjectSize = "10";
		acquireBoxCheckDistance = "50";
		targetLockedFrameColor = "255 0 0 255";
		damageFrameColor = "255 255 255 255";
		minMarkerScale = "0.5";
		markerScaleDistance = "1000";
		markerImageNames[0] = "small_triangle";
		markerImageNames[1] = "small_square";
		markerImageNames[2] = "small_diamond";
		markerImageNames[3] = "small_cross";
		markerImageNames[4] = "small_circle";
		markerTextEdgeOffset = "2";
		renderMarkerText = "1";
		protectedStatics = "0";
		enemyBeaconColor = "0 255 0 255";
		friendBeaconColor = "255 255 0 255";
		vehicleBeaconColor = "0 255 0 255";
		imageOffset = "2";
		missileMarker1 = "gui/RET_missile_marker";
		missileMarker2 = "gui/RET_missile_marker_red";
		missileFlash1 = "gui/RET_missile_horizflash_red";
		missileFlash2 = "gui/RET_missile_vertflash_red";
		LOSMarkerUpdate = "250";
	};
};
//--- OBJECT WRITE END ---

}
