// #autoload
// #name = FrostyVolume
// #version = 1.0
// #date = February 10, 2002
// #author = Frosty
// #email = frostycubes@earthink.net
// #description = Change master sound volume in game with a nice hud.
// #credit = Diogenes as I got the idea from DioGamma and I stole his Gui 8)
// #status = Working

if(!isObject(FrostyV))
{
    new ScriptObject(FrostyV)
    {
        class = FrostyV;
    };
}

package FrostyVolume
{
    function FrostyVolumeBind(%val)
    {
        if(!%val)
            return;

        FrostyV.status = !FrostyV.status;

        if(FrostyV.status)
        {
            Canvas.pushDialog("FrostyVolumeDlg");
            cursorOn();
        }
        else
            FrostyV.volumeDone();
    }

	function FrostyV::update(%this)
    {
        %volume = FrostyVSlider.getValue();
        alxListenerf( AL_GAIN_LINEAR, %volume );
		FrostyVCurrent.setvalue(mFloor($pref::Audio::masterVolume * 100) / 100);
        $pref::Audio::masterVolume = %volume;
	}

    function FrostyV::setup(%this)
    {
        if(%this.setup)
            return;

        new GuiControl(FrostyVolumeDlg) {
            profile = "GuiDefaultProfile";
            horizSizing = "right";
            vertSizing = "bottom";
            position = "0 0";
            extent = "640 480";
            minExtent = "8 8";
            visible = "1";
            hideCursor = "0";
            bypassHideCursor = "0";
            helpTag = "0";

            new ShellPaneCtrl() {
                profile = "ShellPaneProfile";
                horizSizing = "center";
                vertSizing = "center";
                position = "196 194";
                extent = "215 127";
                minExtent = "48 92";
                visible = "1";
                hideCursor = "0";
                bypassHideCursor = "0";
                helpTag = "0";
                text = "FrostyVolume";
                maxLength = "255";
                noTitleBar = "0";

                new ShellFieldCtrl() {
                        profile = "ShellFieldProfile";
						horizSizing = "right";
						vertSizing = "bottom";
						position = "16 26";
						extent = "184 85";
						minExtent = "16 18";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						helpTag = "0";
					};

					new GuiTextCtrl() {
						profile = "ShellTextProfile";
						horizSizing = "right";
						vertSizing = "bottom";
						position = "20 30";
						extent = "97 22";
						minExtent = "8 8";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						helpTag = "0";
						text = "Master Volume:";
						maxLength = "255";
					};
					new GuiTextCtrl(FrostyVCurrent) {
						profile = "ShellTextProfile";
						horizSizing = "right";
						vertSizing = "bottom";
						position = "120 30";
						extent = "97 22";
						minExtent = "8 8";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						helpTag = "0";
						text = $pref::Audio::masterVolume;
						maxLength = "255";
					};
					new ShellSliderCtrl(FrostyVSlider) {
						profile = "ShellSliderProfile";
						horizSizing = "right";
						vertSizing = "bottom";
						position = "20 50";
						extent = "170 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						altCommand = "FrostyV.update();";
						helpTag = "0";
						range = "0.000000 1.000000";
						ticks = "1000";
						value = $pref::Audio::masterVolume;
						usePlusMinus = "1";
					};

					new ShellBitmapButton() {
						profile = "ShellButtonProfile";
						horizSizing = "right";
						vertSizing = "bottom";
						position = "39 73";
						extent = "130 30";
						minExtent = "26 27";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						command = "FrostyV.volumeDone();";
						helpTag = "0";
						text = "DONE";
						simpleStyle = "0";
				    };
			};
		};
        FrostyVSlider.setValue($pref::Audio::masterVolume);

        %this.setup = true;
    }

    function FrostyV::volumeDone(%this)
    {
        Canvas.popDialog("FrostyVolumeDlg");
        cursorOff();
    }

    function DispatchLaunchMode()
    {
        parent::DispatchLaunchMode();

        FrostyV.setup();
    }

    function OptionsDlg::onWake(%this)
    {
        if(!$FrostyVbound)
        {
            $RemapName[$RemapCount] = "FrostyVolume";
            $RemapCmd[$RemapCount] = "FrostyVolumeBind";
            $RemapCount++;
            $FrostyVbound = true;
        }
        parent::onWake(%this);
    }
};
activatePackage(FrostyVolume);
