// #autoload
// #name = FrostyScore
// #version = 1.4
// #date = January 18, 2002
// #author = Frosty
// #email = frostycubes@earthink.net
// #description = Shows your kills, deaths, and name of last kill you had in a nice little HUD next to objectiveHUD.
// #credit = Halide, who helped me throughout this whole script constantly, even with my bitchin ;D Also for the objectiveHUD docking code.
// #status = Working

if(!isObject(FrostyS))
{
    if(isFile("prefs/FrostyPrefs.cs") && !$FrostyPrefsLoaded)
    {
        exec("prefs/FrostyPrefs.cs");
        $FrostyPrefsLoaded = true;
    }

    if($FrostyPref::Score::Enabled $= "")
        $FrostyPref::Score::Enabled = true;

    new ScriptObject(FrostyS)
    {
        class = FrostyS;
    };
}

package FrostyScore
{
    function FrostyS::setup(%this)
    {
        if(%this.setup)
            return;

     	addMessageCallBack('msgVehicleKill', FrostyScoreKillCallback);
	    addMessageCallBack('msgCTurretKill', FrostyScoreKillCallback);
	    addMessageCallBack('msgTurretKill', FrostyScoreKillCallback);
	    addMessageCallBack('msgSelfKill', FrostyScoreKillCallback);
	    addMessageCallBack('MsgLegitKill', FrostyScoreKillCallback);
	    addMessageCallBack('MsgHeadshotKill', FrostyScoreKillCallback);
	    addMessageCallBack('msgExplosionKill', FrostyScoreKillCallback);
    	addMessageCallBack('msgSuicide', FrostyScoreKillCallback);

	    addMessageCallback('MsgClientJoin', FrostyScoreJoinCallback);

        if(isObject(HalFPSping))
            %HalFPSping = 46;
        else
            %HalFPSping = 0;

        %x = getWord(objectiveHud.position, 0) + getWord(objectiveHud.extent, 0) + %HalFPSping;
        %y = getWord(objectiveHud.position, 1);

        new HudScoreCtrl(FCscoreHUD)
        {
            profile = "HudScoreProfile";
            horizSizing = "right";
            vertSizing = "top";
            extent = "110 16";
            minExtent = "8 8";
            position = %x SPC %y;
            visible = $FrostyPref::Score::Enabled;

            new GuiTextCtrl(FCscoreHUDLast)
            {
                profile = "GuiTextObjHudCenterProfile";
                horizSizing = "center";
                vertSizing = "bottom";
                position = "13 3";
                extent = "110 16";
                visible = "1";
                text = "Last Kill";
            };

            new GuiTextCtrl(FCscoreHUDKills)
            {
                profile = "GuiTextObjHudCenterProfile";
                horizSizing = "center";
                vertSizing = "bottom";
                position = "13 19";
                extent = "110 16";
                visible = "1";
                text = "Kills:" SPC "0" SPC "Deaths:" SPC "0";
            };
        };
        playGui.add(FCscoreHUD);

        if (isObject(HudMover))
            hudmover::addhud(FCscoreHUD, "FrostyScore");


        FCscoreHUD.enableHorzSeparator();

        %this.setup = true;
    }

    function FrostyS::Update(%this, %reload)
    {
        if(%reload) {
            %this.deaths = 0;
            %this.kills = 0;

            FCscoreHUDKills.setValue("Kills:" SPC %this.kills SPC "Deaths:" SPC %this.deaths);
            FCscoreHUDLast.setValue("Last Kill");
        }

        if(isObject(HalFPSping))
            %HalFPSping = 46;
        else
            %HalFPSping = 0;

        %x = getWord(objectiveHud.position, 0) + getWord(objectiveHud.extent, 0) + %HalFPSping;
        %y = getWord(objectiveHud.position, 1);

        FCscoreHUD.position = %x SPC %y;
    }

    function FrostyScoreJoinCallback(%msgType, %msgString, %clientName, %clientId, %targetId, %isAI, %isAdmin, %isSuperAdmin, %isSmurf, %guid)
    {
        if(StrStr(%msgString, "Welcome to Tribes2") != -1)
            FrostyS.clientName = detag(%clientName);
    }

    function FrostyScoreKillCallback(%msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType)
    {
        %killerName = detag(%killerName);
        %victimName = detag(%victimName);

        if(FrostyS.clientName $= "<NULL>")
        {
            FCscoreHUDKills.setValue("Error: <NULL>");
            FCscoreHUDLast.setvalue("Error: <NULL>");
            %error = true;
        }

        if(!%error)
        {
            if(%killerName $= FrostyS.clientName)
            {
                if(%killerName $= %victimName)
                {
                    FrostyS.deaths++;
                    FCscoreHUDKills.setValue("Kills:" SPC FrostyS.kills SPC "Deaths:" SPC FrostyS.deaths);
                    %check = true;
                }

                if(!%check)
                {
                    FrostyS.kills++;
                    FCscoreHUDKills.setValue("Kills:" SPC FrostyS.kills SPC "Deaths:" SPC FrostyS.deaths);
                    FCscoreHUDLast.setValue(%victimName);
                    %check = false;
                }
            }

            if((%victimName $= FrostyS.clientName) && (!%check))
            {
                FrostyS.deaths++;
                FCscoreHUDKills.setValue("Kills:" SPC FrostyS.kills SPC "Deaths:" SPC FrostyS.deaths);
                %check = false;
            }
        }
    }

    function FrostyScoreBind(%val)
    {
        if(%val)
        {
            $FrostyPref::Score::Enabled = !$FrostyPref::Score::Enabled;

            if($FrostyPref::Score::Enabled)
            {
                addMessageHudLine("\c2FrostyScore Enabled");
                FrostyS.Update();
            }
            else
                addMessageHudLine("\c2FrostyScore Disabled");

            FCscoreHUD.setVisible($FrostyPref::Score::Enabled);
        }
    }

    function FrostyScoreReloadBind(%val)
    {
        if(%val)
            FrostyS.Update(true);
    }

    function DispatchLaunchMode()
    {
        parent::DispatchLaunchMode();

        FrostyS.setup();
    }

    function playGui::onWake(%this)
    {
        parent::onWake(%this);

        FrostyS.Update();
    }

    function loadingGui::onWake(%this)
    {
        parent::onWake(%this);

        FrostyS.Update(true);
    }

    function DebriefGui::onWake(%this)
    {
        parent::onWake(%this);

        FrostyS.Update(true);
    }

    function clientCmdTogglePlayHuds(%val)
    {
        parent::clientCmdTogglePlayHuds(%val);

        FCscoreHUD.setVisible(%val);
    }

    function quit()
    {
        if(!$FrostyPrefsSaved)
        {
            export("$FrostyPref::*", "prefs/FrostyPrefs.cs", false);
            $FrostyPrefsSaved = true;
        }

        parent::quit();
    }

    function OptionsDlg::onWake(%this)
    {
        if(!$FCscoreBound)
        {
            $RemapName[$RemapCount] = "Frosty Score";
            $RemapCmd[$RemapCount] = "FrostyScoreBind";
            $RemapCount++;
            $RemapName[$RemapCount] = "Frosty Score Reload";
            $RemapCmd[$RemapCount] = "FrostyScoreReloadBind";
            $RemapCount++;
            $FCscoreBound = true;
        }
        parent::onWake(%this);
    }
};
activatePackage(FrostyScore);
