// #autoload
// #name = FrostyAutoRepair
// #version = 1.1B
// #date = December 03, 2001
// #author = Frosty
// #email = frostycubes@earthink.net
// #description = Automatically starts repairing object on Repairgun mount, stops repairing and mounts previous weapon when done
// #credit = Halide, helped me fix some bugs and clean up code
// #status = Working

if(!isObject(FrostyAR))
{
	new ScriptObject(FrostyAR)
	{
		class = FrostyAR;
		// this delay is how long to keep repairing if they lose the target
		delay = 1000;
	};
}

package	FrostyAutoRepair
{
//  ----------- Override mouseFire() function -----------
	function mouseFire(%val)
	{
		if(!FrostyAR.active)
			parent::mouseFire(%val);
	}

//	------------- Starts and stop repairs ---------------
	function FrostyAR::repair(%this, %val)
	{
		// cancel if we lost a target and we found a new one...
		cancel(%this.schedule);

		%this.active = %val;
		$mvTriggerCount0 = %val;

		if(!%val)
            schedule(200, 0, use, %this.prevWeapon);
	}
//	-----------------------------------------------------
//	---- Check to see if repairs done or any errors -----
	function defaultMessageCallback(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10)
	{
		if(StrStr(%msgString, "Repair pack activated") != -1 || StrStr(%msgString, "Repairing") != -1)
			FrostyAR.repair(true);
		else if(StrStr(%msgString, "Repairs completed") != -1 || StrStr(%msgString, "Target is not damaged") != -1)
			FrostyAR.repair(false);
		else if(StrStr(%msgString, "No target to repair") != -1)
			FrostyAR.schedule = FrostyAR.schedule(FrostyAR.delay, repair, false);

		parent::defaultMessageCallback(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);
	}
//	-----------------------------------------------------
//	--- Called when user unmounts Repairgun (Icon off) --
	function clientCmdsetRepairPackIconOff()
	{
		FrostyAR.repair(false);

		parent::clientCmdsetRepairPackIconOff();
	}
//	-----------------------------------------------------
//	-------- Convert slot numbers to weapon names -------
	function clientCmdSetWeaponsHudBitmap(%slot, %name, %bitmap)
	{
		FrostyAR.weaponName[%slot] = %name;

		parent::clientCmdSetWeaponsHudBitmap(%slot, %name, %bitmap);
	}

	function clientCmdSetWeaponsHudActive(%slot)
	{
		FrostyAR.setWeapons(%slot);

		parent::clientCmdSetWeaponsHudActive(%slot);
	}

	function FrostyAR::setWeapons(%this, %slot)
	{
		if(%slot != -1)
			%this.prevWeapon = %this.weaponName[%slot];
	}
//	-----------------------------------------------------
//	---------- Just checks to prevent errors ------------

// ####### dont know if you need this ?? ########
	function clientCmdTogglePlayHuds(%val)
	{
		parent::clientCmdTogglePlayHuds(%val);

		if(FrostyAR.active)
			FrostyAR.repair(false);
	}
//	-----------------------------------------------------
};
activatePackage(FrostyAutoRepair);
