// #autoload
// #name = grentrack
// #version = 1.0
// #status = release
// #author = Ego
// #warrior = -Ego-
// #category = EgoScripts
// #description = Tracks Grenade Type
// #status = release
// #include = support/loadout.cs
// #include = support/callback.cs
// #credit = Fragbait

//		GetCurrentGren(); Returns currently carried grenade type
//		GetSelectedGren(); Returns the type of grenade you will buy next
//
//		Values returned are :-
//		Grenade
//		Whiteout Grenade
//		Concussion Grenade
//		Flare Grenade
//		Deployable Camera



$GrenadepickupText["some grenades"] = "Grenade";
$GrenadepickupText["some flash grenades"] = "Whiteout Grenade";
$GrenadepickupText["some concussion grenades"] = "Concussion Grenade";
$GrenadepickupText["some flare grenades"] = "Flare Grenade";
$GrenadepickupText["a deployable camera"] = "Deployable Camera";

function GrenReSpawn() {
	$currentGren = "Grenade";
     	GrenRefreshSelected();
}

function GrenFavChange(%index) {
    	$GrenSelectedFav = $pref::Favorite[$pref::FavCurrentSelect];
    	for (%i = 0; %i < getFieldCount($GrenSelectedFav); %i++) {
        	%type = getField($GrenSelectedFav, %i);
        	%equipment = getField($GrenSelectedFav, %i++);
        	if(%type $= "Grenade") {
            		$SelectedGren = %equipment;
        	}
    	}
}

function GrenQuickChange(%pack, %item) {
    	if((%item $= "Grenade") || (%item $= "grenade")) {
        	$SelectedGren = %pack;
    	}
}

function GrenInvUsed() {
    $currentGren = $SelectedGren;
}

function GrenRefreshSelected() {
    	for (%i = 1; %i < $Hud['inventoryScreen'].count; %i++) {
        	%type = $Hud['inventoryScreen'].data[%i, 1].type;
        	%equipment = $Hud['inventoryScreen'].data[%i, 1].getValue();
        	if(%type $= "Grenade") {
        	    $SelectedGren = %equipment;
        	}
    	}
}

function GrenAmmoPickedUp(%Msgtype, %msgtext, %itemtext) {
    	if($GrenadepickupText[%itemtext] !$= "")
        	$currentGren = $GrenadepickupText[%itemtext];
}

package GrenTrackPackage {
	
function DispatchLaunchMode() {
	parent::DispatchLaunchMode();
	callback.add(PlayerUseInv, "GrenInvUsed();");
	callback.add(PlayerSpawn, "GrenRespawn();");
	addMessageCallback('MsgItemPickup', GrenAmmoPickedUp);		
}
	
function toggleCursorHuds(%val) {
    	parent::toggleCursorHuds(%val);
    	if(%val $= 'inventoryScreen')
    	    GrenRefreshSelected();
}

function loadFavorite(%index, %echo) {
    parent::loadFavorite(%index, %echo);
    GrenFavChange(%index);
}

function addQuickPackFavorite(%pack, %item){
    parent::addQuickPackFavorite(%pack, %item);
    GrenQuickChange(%pack, %item);
}

function addQuickChangeFavorite(%pack, %item){
    parent::addQuickChangeFavorite(%pack, %item);
    GrenQuickChange(%pack, %item);
}

function GetCurrentGren() {
	return $CurrentGren;
}

function GetSelectedGren() {
	return $SelectedGren;
}

};
activatePackage(GrenTrackPackage);
