// #autoload
// #name = Automissile
// #version = 1.55
// #date = September 09, 2001
// #category = Automation
// #author = John Kelly
// #warrior = DeLukas
// #email = DeLukas@thzclan.com
// #web = http://www.thzclan.com
// #description = Adds a toggle button for automated missile fire
// #readme = scripts/autoexec/delukas/automissle.txt
// #status = release
// ---------------------------------------------------------------------------
// Copyright John Kelly 2001
// Distribution of this file allowed as long as copyright information
// remains intact.

if(!isObject(Inventory_Support)){
 //error("TEST LOADOUT !!!");
 exec("support/loadout.cs");
}

function MissileToggle(%val) {
	if (%val) { //at keypress
        //commandToServer('TeamMessageSent', "Key Press");


			if ($MissileIsToggled){ //is it already on?
               //commandToServer('TeamMessageSent', "Toggled off");
				$MissileIsToggled = false;//if yes turn it off
                %time = 0;
                schedule((%time += 250), 0, AutoMissileOff);
                //commandToServer('TeamMessageSent', "Toggle OFF");
                }
			else{
				$MissileIsToggled = true;//if no turn it on
                //commandToServer('TeamMessageSent', "Toggle ON");
                if(loadout.getCurrentWeapon() $= "MissileLauncher"){
                //commandToServer('TeamMessageSent', "ML");
                 %time = 0;
                 schedule((%time += 250), 0, AutoMissileOn);
                 if($ALocked){
                  if(($mvTriggerCount0 & 1) == 0) missileFire();
                  }

                }
            }
	}
 }

function AutoMissilehudMover() {
	if (isObject(HM) && isObject(HudMover))
		hudmover::addhud(AutoMissileNotifyHUD, "AutoMissile");
}

function AutoMissileOn()
{
    //commandToServer('TeamMessageSent', "HUD ON");
    AutoMissileNotifyHUD.position = "348 229";
    if (isObject(HM) && isObject(HudMover))
         AutoMissileNotifyHUD.position = $hudposAutoMissileNotifyHUD;
    AutoMissileNotifyHUD.visible = 1;
}

function AutoMissileOff()
{
	if ((!(loadout.getCurrentWeapon() $= "MissileLauncher")) || (!$MissileIsToggled)) AutoMissileNotifyHUD.visible = 0;
}

package MissileToggle {

	function clientCmdSetRepairReticle() {
 		parent::clientCmdSetRepairReticle();


        %time = 0;
        // commandToServer('TeamMessageSent', "Repair");
        schedule((%time += 250), 0, AutoMissileOff);
    	}

	function clientCmdSetWeaponsHudActive(%slot) {
		parent::clientCmdSetWeaponsHudActive(%slot);
		if($WeaponNames[%slot] $= "MissileLauncher"){
         if($MissileIsToggled){
            //commandToServer('TeamMessageSent', "Toggled and Mounted");
           %time = 0;
           schedule((%time += 250), 0, AutoMissileOn);
           }
        }
        else{
          %time = 0;
          //commandToServer('TeamMessageSent', "Not Missile Laucher");
          schedule((%time += 250), 0, AutoMissileOff);
         }
    }


   function GameConnection::onTargetLocked( %con, %state ){


   if( %state $= "true" )
   {
       $ALocked = true;

      if( !%con.targetTone ) {
         %con.targetTone = alxPlay( "sLockedTone", 0, 0, 0 );
         if($MissileIsToggled){
            if(($mvTriggerCount0 & 1) == 0) missileFire();
         }
    }

   }
   else
   {

      if( %con.targetTone $= "" )
         return;
      $ALocked = false;
      if( %con.targetTone ){
         alxStop( %con.targetTone );
          if(($mvTriggerCount0 & 1) == 1)
			missileFire();
      }

      %con.targetTone = "";
   }
}
    
	function OptionsDlg::onWake( %this ) {//Classic key binding
		if($MissileToggleBind $= "false") {
			$RemapName[$RemapCount]="AutoMissile";
			$RemapCmd[$RemapCount]="MissileToggle";
			$RemapCount++;
			$MissileToggleBind = "true";
		}
		parent::onWake( %this );
	}
 
 	function PlayGui::onWake( %this )
	{

		parent::onWake( %this );

		if(!isObject(PlayGui)) return;

		if(isObject(AutoMissileNotifyHUD)) PlayGui.remove(AutoMissileNotifyHUD);

		new GuiTextCtrl(AutoMissileNotifyHUD) {
			profile = "CenterPrintTextProfile";
			horizSizing = "relative";
			vertSizing = "center";
			position = "348 229";
			extent = "140 22";
			minExtent = "8 8";
			visible = "0";
			helpTag = "0";
			text = "AUTO";
			maxLength = "255";
		};

  AutoMissilehudMover();
		PlayGui.add(AutoMissileNotifyHUD);
	}
 
 function missileFire(%val){
   $mvTriggerCount0 += $mvTriggerCount0 & 1 == %val ? 2 : 1;
 }
 
};
$MissileIsToggled = true;
$MissileToggleBind = "false";
$ALocked = false;
activatePackage(MissileToggle);  //Run this script
