// shows your role in a small hud below your health/energy
// finally got around to make it compatible with freehuds (added to playgui instead of hudclusterback)

function Tr2RoleHudCreate(%refresh)
{
   new GuiControlProfile ("Tr2RoleHudProfile")
   {
      fontType = "Verdana Bold";
      fontSize = "12";
      justify = "center";
      fontColor = "240 240 240";
   };
   
   
   %xPos = getWord(HeatHud.position, 0) + getWord(HudClusterBack.position, 0);
   %yPos = getWord(HeatHud.position, 1) + getWord(HudClusterBack.position, 1) + 10;
   
   %xExt = getWord(HeatHud.extent, 0);
   %yExt = 18;
   
   if(%refresh)
   {
      Tr2RoleHud.position = %xPos SPC %yPos;
      return;
   }      
   
   new GuiControl(Tr2RoleHud) 
   {
      profile = "GuiDefaultProfile";
      horizSizing = "right";
      vertSizing = "bottom";
      position = %xPos SPC %yPos;
      extent = %xExt SPC %yExt;
      minExtent = "8 8";
      visible = "1";
      hideCursor = "0";
      bypassHideCursor = "0";
      helpTag = "0";

      new ShellFieldCtrl() 
      {
         profile = "GuiChatBackProfile";
         horizSizing = "right";
         vertSizing = "bottom";
         position = "0 0";
         extent = %xExt SPC %yExt;
         minExtent = "16 18";
         visible = "1";
         hideCursor = "0";
         bypassHideCursor = "0";
         helpTag = "0";
      };
   };
   
   new GuiTextCtrl(Tr2RoleHudText) 
   {
      profile = "Tr2RoleHudProfile";
      horizSizing = "right";
      vertSizing = "bottom";
      position = "3 2";
      extent = (%xExt - 3) SPC (%yExt - 2);
      minExtent = "8 8";
      visible = "1";
      hideCursor = "0";
      bypassHideCursor = "0";
      helpTag = "0";
      longTextBuffer = "0";
      maxLength = "256";
      text = "";
   };   
   Tr2RoleHud.add(Tr2RoleHudText);
   playGui.add(Tr2RoleHud);
   
   if(isObject(HudMover)) hudmover::addhud(Tr2RoleHud, "TR2 Role Hud");
}

function HandleRoleChange(%msgType, %msgString)
{   
   if(strStr(%msgString, "Offense") != -1)
      Tr2RoleHudText.setValue("Offense");
   
   if(strStr(%msgString, "Defense") != -1)
      Tr2RoleHudText.setValue("Defense");
   
   if(strStr(%msgString, "Goalie") != -1)
      Tr2RoleHudText.setValue("Goalie");
}

function Tr2RoleHudCaptureGameType(%msgType, %msgString, %game)
{
   if(detag(%game) $= "TR2Game")
      Tr2RoleHud.setVisible(true);
   else
      Tr2RoleHud.setVisible(false);

}

package Tr2RoleHud
{
   function DispatchLaunchMode()
   {
      addMessageCallback('TR2ArmorChange', HandleRoleChange);
      addMessageCallback('MsgClientReady', Tr2RoleHudCaptureGameType);
      Tr2RoleHudCreate(0); // dont refresh as the playgui isnt woken yet
      parent::DispatchLaunchMode();
   }
   
   function PlayGui::onWake(%this)
   {
      if(!$Tr2RoleHudRefreshed)
      {
         schedule(1100, 0, Tr2RoleHudCreate, 1); // refresh
         $Tr2RoleHudRefreshed = true;   
      }
      
      parent::onWake(%this);
   }   	   
};
activatePackage(Tr2RoleHud);