// #autoload
// #name = SoundNotify
// #date = September 16, 2002
// #author = Da_Timsta
// #warrior = Da_Timsta
// #email = timsta@email.dk
// #web = http://da-timsta.soo.dk/
// #description = Notifies you with a sound on kills, repkit pickups and repkit use.

package soundNotify
{
	function RepKitPickup(%msgType, %msgString)
	{
		if(strStr(%msgString, "You picked up a repair kit.") != -1) 
			alxPlay(alxCreateSource(AudioChat, "health.wav"));
	}
	
	function KillSoundJoin(%msgType, %msgString, %clientName, %clientId, %targetId, %isAI, %isAdmin, %isSuperAdmin, %isSmurf, %guid)
	{
		if(StrStr(%msgString, "Welcome to Tribes") != -1)
			$myClientName = detag(%clientName);
	}

	function KillSoundKill(%msgType, %msgString, %victimName, %victimGender, %victimPoss, %killerName, %killerGender, %killerPoss, %damageType)
	{
		if($myClientName $= detag(%killerName))
			alxPlay(alxCreateSource(AudioChat, "kill.wav"));
	}

	function DispatchLaunchMode() 
	{
 		addMessageCallback('MsgItemPickup', RepKitPickup); 		
 		addMessageCallback('MsgClientJoin', KillSoundJoin);
		addMessageCallBack('MsgLegitKill', KillSoundKill);
		addMessageCallBack('MsgHeadshotKill', KillSoundKill);
		addMessageCallBack('msgExplosionKill', KillSoundKill);
		addMessageCallBack('MsgRearshotKill', KillSoundKill);
		addMessageCallBack('msgVehicleKill', KillSoundKill);
		addMessageCallBack('msgTR2Knockdown', KillSoundKill); // Team Rabbit 2
		parent::DispatchLaunchMode();
	}
};

activatePackage(soundNotify);