// #autoload
// #name = RearView
// #version = 1.0
// #date = August 2, 2002
// #warrior = Da_Timsta
// #email = da_timsta@soo.dk
// #web = http://da-timsta.soo.dk/
// #description = looks behind you on a keypress.
// #status = release

function rearView(%val)
{
	if (%val) 
	{
		// find out if we're in 1st or 3rd person amd save it
		$CurrentViewState = $firstPerson;
      
		// turn on freelook
		toggleFreeLook(true);
      
		// go in third person if we arent allready.
		toggleFirstPerson($firstPerson);   
      
		// turn around - have to schedule this, because it is buggy otherwise
		%yawValue = (56542.5 / $cameraFOV) / 2;  // the magic number 56542.5! (found by testing)
		$RearViewScheduleID = schedule(35, 0, yaw, %yawValue);
	}
	else
	{
		// cancel the schedule is you tapped the button faster than 35ms :P
		if(isEventPending($RearViewScheduleID))
			cancel($RearViewScheduleID);

		// go back to first person if we started out that way
		toggleFirstPerson($CurrentViewState);
           
		// turn off freelook
		toggleFreeLook(false);
	}
}	

package rearView 
{
	// set up keybinds
	function setUpFavPrefs()
	{
		$RemapName[$RemapCount]="Rear View";
		$RemapCmd[$RemapCount]="rearView";
		$RemapCount++;
		return parent::setUpFavPrefs();
	}

    
	function clientCmdSetDefaultVehicleKeys(%inVehicle)
	{
		parent::clientCmdSetDefaultVehicleKeys( %inVehicle );
		
		if (%inVehicle)
			passengerKeys.copyBind(moveMap, rearView);
	}
};

activatePackage(rearView);