// a new smaller event hud for tr2

function newTR2EventHudCreate()
{
   new GuiControlProfile ("newTR2EventNameProfile")
   {
      fontType = "Verdana Bold";
      fontSize = "12";
   };
   
   new GuiControlProfile ("newTR2EventValueProfile")
   {
      fontType = "Verdana Bold";
      fontSize = "12";
      justify = "center";
      fontColor = "240 240 240";
   };
   
   %height = 18;
   %padding = 2;
   %tr2ObjHudWidth = 245;
   %newJackpotWidth = 35;
   
   %xPos = getWord(ObjectiveHud.position, 0);
   %yPos = getWord(ObjectiveHud.position, 1) - %height - %padding;   
   
   %xExt = %tr2ObjHudWidth + %newJackpotWidth + %padding;
   %yExt = %height;
   
   new GuiControl(newTR2EventHud) 
   {
      profile = "GuiDefaultProfile";
      horizSizing = "right";
      vertSizing = "bottom";
      position = %xPos SPC %yPos;
      extent = %xExt SPC %yExt;
      minExtent = "8 8";
      visible = "0";
      hideCursor = "0";
      bypassHideCursor = "0";
      helpTag = "0";
   
      new ShellFieldCtrl() 
      {
         profile = "GuiChatBackProfile";
         horizSizing = "right";
         vertSizing = "bottom";
         position = "0 0";
         extent = %xExt SPC %yExt;
         minExtent = "16 18";
         visible = "1";
         hideCursor = "0";
         bypassHideCursor = "0";
         helpTag = "0";
      };
   };
   
   %xExt = %tr2ObjHudWidth - 3;
   %yExt = %height - 2;   
   new GuiMLTextCtrl(newTR2EventHudNames) 
   {
      profile = "newTR2EventNameProfile";
      horizSizing = "right";
      vertSizing = "bottom";
      position = "3 2";
      extent = %xExt SPC %yExt;
      minExtent = "8 8";
      visible = "1";
      hideCursor = "0";
      bypassHideCursor = "0";
      helpTag = "0";
      lineSpacing = "2";
      allowColorChars = "0";
      maxChars = "256";
   };
   
   %xPos = %tr2ObjHudWidth + %padding;   
   %xExt = %newJackpotWidth;
   %yExt = %height - 2;   
   new GuiTextCtrl(newTR2EventHudValue) 
   {
      profile = "newTR2EventValueProfile";
      horizSizing = "right";
      vertSizing = "bottom";
      position = %xPos SPC "2";
      extent = %xExt SPC %yExt;
      minExtent = "8 8";
      visible = "1";
      hideCursor = "0";
      bypassHideCursor = "0";
      helpTag = "0";
      longTextBuffer = "0";
      maxLength = "256";
      text = "";
   };   
   newTR2EventHud.add(newTR2EventHudNames);
   newTR2EventHud.add(newTR2EventHudValue);
   playGui.add(newTR2EventHud);
   
   if(isObject(HudMover)) hudmover::addhud(newTR2EventHud, "New TR2 Event Hud");
}

function newTR2EventHandleEvent(%msgType, %msgString, %name, %message, %value)
{
   if(!(objectiveHud.gameType $= "TR2Game"))
      return;
   
   newTR2EventHudNames.setText(%name);
   newTR2EventHudValue.setValue(%value);
   
   if(%name $= "")
      newTR2EventHudNames.setText("<color:A0A0FF>Infield Grab");
   
   if(isEventPending($newTR2EventSchedule))
      cancel($newTR2EventSchedule);
         
   newTR2EventHud.setVisible(true);
   $newTR2EventSchedule = newTR2EventHud.schedule(4000, setVisible, false);
}

package newTR2Event
{
   function DispatchLaunchMode()
   {
      addMessageCallback('MsgTR2Event', newTR2EventHandleEvent);
      playGui.remove(TR2EventPopup); // remove the old boring tr2 hud
      parent::DispatchLaunchMode();
   }
   
   function PlayGui::onWake(%this)
   {
      if(!$newTR2EventCreated)
      {
         schedule(1100, 0, newTR2EventHudCreate);
         $newTR2EventCreated = true;
      }
      
      parent::onWake(%this);
   }
};
activatePackage(newTR2Event);