// new smaller jackpot hud for tr2 atached to the objective hud

// choose the colors you want for jackpot below (low) and above (high) the 40 points
// you need to score a goal in TR2
$jackpotLowColor = "<color:8C8C8C>";
$jackpotHighColor = "<color:F0F0F0>";

// -- dont edit below here --

function newJackpotCreate(%refresh)
{
   // as we only need the hud in tr2, we might as well hardcode the tr2 obj hud extent
   %tr2ObjHudExtent = "245 37";
   %tr2ObjHudPos = ObjectiveHud.position;
   %padding = 2;
   
   %xPos = getWord(%tr2ObjHudPos, 0) + getWord(%tr2ObjHudExtent, 0) + %padding;
   %yPos = getWord(%tr2ObjHudPos, 1);
   %xExt = "35";
   %yExt = getWord(%tr2ObjHudExtent, 1);
   
   if(%refresh)
   {
      newJackpotHud.position = %xPos SPC %yPos;
      return;
   }
   
   new GuiControlProfile ("newJackpotProfile")
   {
      fontType = "Verdana Bold";
      fontSize = "16";
   };
   
   new GuiControl(newJackpotHud) 
   {
      profile = "GuiDefaultProfile";
      horizSizing = "right";
      vertSizing = "bottom";
      position = %xPos SPC %yPos;
      extent = %xExt SPC %yExt;
      minExtent = "8 8";
      visible = "1";
      hideCursor = "0";
      bypassHideCursor = "0";
      helpTag = "0";
   
      new ShellFieldCtrl() 
      {
         profile = "GuiChatBackProfile";
         horizSizing = "right";
         vertSizing = "bottom";
         position = "0 0";
         extent = %xExt SPC %yExt;
         minExtent = "16 18";
         visible = "1";
         hideCursor = "0";
         bypassHideCursor = "0";
         helpTag = "0";
      };
   };
      
   new GuiMLTextCtrl(newJackpotText) 
   {
      profile = "newJackpotProfile";
      horizSizing = "right";
      vertSizing = "bottom";
      position = "0 9";
      extent = %xExt SPC (%yExt - 9);
      minExtent = "8 8";
      visible = "1";
      hideCursor = "0";
      bypassHideCursor = "0";
      helpTag = "0";
      lineSpacing = "2";
      allowColorChars = "0";
      maxChars = "256";
   };
   newJackpotHud.add(newJackpotText);   
   newJackpotText.setText("<just:center>" @ $jackpotLowColor @ "0");
   playGui.add(newJackpotHud);
   
   if(isObject(HudMover)) hudmover::addhud(newJackpotHud, "New Jackpot Hud");
}

function newJackpotHandleNewBonus(%msgType, %msgString, %text, %color)
{     
      if(%text < 40)
         newJackpotText.setText("<just:center>" @ $jackpotLowColor @ %text);
      else
         newJackpotText.setText("<just:center>" @ $jackpotHighColor @ %text);
}

function newJackpotCaptureGameType(%msgType, %msgString, %game)
{
   if(detag(%game) $= "TR2Game")
      newJackpotHud.setVisible(true);
   else
      newJackpotHud.setVisible(false);
}

package newJackpot
{
   function DispatchLaunchMode()
   {
      addMessageCallback('MsgTR2Bonus', newJackpotHandleNewBonus);
      addMessageCallback('MsgClientReady', newJackpotCaptureGameType);
      PlayGui.remove(TR2BonusHud);
      newJackpotCreate(0); // dont refresh as the playgui isnt created yet
      parent::DispatchLaunchMode();
   }
   
   function PlayGui::onWake(%this)
   {
      if(!$newJackpotRefreshed)
      { 
         schedule(1100, 0, newJackpotCreate, 1); // refresh
         $newJackpotRefreshed = true;
      }
      parent::onWake(%this);
   }
};
activatePackage(newJackpot);