// pops up your chathud and weaponshud when "used"
// also includes muting features for the chathud to make it popup less :-)

// popup delays in ms
$PopUpChatHudDelay = 3000;
$PopUpWeaponsHudDelay = 1500;

// muting of different events
$MuteRoleChange = true;
$MuteRepKitPickup = false;
$MuteRepKitUse = true;
$MuteFlagMessages = true;
$MuteCantPassToSelf = true;

// what do you want to pop up?
$PopUpChatHud = false;
$PopUpWeaponsHud = true;

// a couple of huds i like to remove
$RemoveInvHud = true;
$RemoveBackpackHud = true;

// -- dont edit below this line --

function ToggleChatHudPopup(%val)
{
   if(!%val)
      return;
   
   if($PopUpChatHud)
   {
      $PopUpChatHud = false;
      clientCmdBottomPrint("ChatHudPopup Disabled", 3, 1);
   
      if(isEventPending($HudPopUpChatSchedule))
         cancel($HudPopUpChatSchedule);
      
      OuterChatHud.setVisible(true);
   }
   else
   {
      $PopUpChatHud = true;
      clientCmdBottomPrint("ChatHudPopup Enabled", 3, 1);
      OuterChatHud.setVisible(false);
   }
}

package hudPopUp
{
   function clientCmdSetWeaponsHudActive(%slot, %ret, %vis)
   {
      parent::clientCmdSetWeaponsHudActive(%slot, %ret, %vis);
      
      if(!$PopUpWeaponsHud)
         return;
      
      if(isEventPending($HudPopUpWeaponSchedule))
         cancel($HudPopUpWeaponSchedule);
         
      weaponsHud.setVisible(true);
      $HudPopUpWeaponSchedule = weaponsHud.schedule($PopUpWeaponsHudDelay, setVisible, false);
   }
   
   function addMessageHudLine(%text)
   {
      //------------
      // Muting
      //------------
      if((strStr(%text, "\c3ROLE CHANGE:  \c4") != -1) && $MuteRoleChange)
         return;

      if((strStr(%text, "\c0You picked up a repair kit.") != -1) && $MuteRepKitPickup)
         return;

      if((strStr(%text, "\c2Repair Kit Used.") != -1) && $MuteRepKitUse)
         return;
         
      if((strStr(%text, "\c2") != -1) && (strStr(%text, "flag") != -1) && $MuteFlagMessages)
         return;
         
      if((strStr(%text, "\c1You can't pass to yourself!") != -1) && $MuteCantPassToSelf)
         return;
         
      //-----------
      // ChatPopUp
      //-----------
      parent::addMessageHudLine(%text);
      
      if(!$PopUpChatHud)
         return;
         
      if(%text $= "")
      {
         OuterChatHud.setVisible(false);
         return;
      }         
      
      if(isEventPending($HudPopUpChatSchedule))
         cancel($HudPopUpChatSchedule);
      
      OuterChatHud.setVisible(true);
      $HudPopUpChatSchedule = OuterChatHud.schedule($PopUpChatHudDelay, setVisible, false);      
   }
   
   // keybind to toggle the chatpopup. usefull for pregame talk etc.
   function setUpFavPrefs()
   {
     $RemapName[$RemapCount]="Toggle ChatHudPopup";
     $RemapCmd[$RemapCount]="ToggleChatHudPopup";
     $RemapCount++;

     return parent::setUpFavPrefs();
   }
   
   function DispatchLaunchMode()
   {
      if($RemoveInvHud) playGui.remove(InventoryHud);
      if($RemoveBackpackHud) playGui.remove(backPackFrame);
      
      parent::DispatchLaunchMode();
   }

};
activatePackage(hudPopUp);