// #autoload
// #name = MBM Watcher
// #version = 1.01
// #date = March 1, 2004.
// #author = Barbarian
// #warrior = Barb4rian
// #email = conanford@hotmail.com
// #web = http://ctrl-c-ctrl-v.com/t2
// #description = Displays data from MBM 5 in a hud
// #readme = scripts/barbarian/mbm_watcher.t2ml
// #category = Barbarian
// #status = release
// #config = MBMWatchGUI
// #credit = UberGuy
// #credit = EmuZombie, for the idea

if (!isobject(MBMWatch))
    	new ScriptObject(MBMWatch)
	{
	        class = MBMWatch;
		version = 1.0;
		thread = 0;
		width = 0;
		height = 0;
    	};


function MBMWatch::loadPrefs(%this, %force) {
	// this is after Uberguy's method
	if (!$Barbarianpref::loaded || %force) 
	{

		// set the defaults
		$Barbarianpref::mbmwatch::logfile="MBM 5 Interval Log.csv";	
		$Barbarianpref::mbmwatch::logtime = 10;
		$Barbarianpref::mbmwatch::transparent = false;
		// grow hud vertically or horizontally
		$Barbarianpref::mbmwatch::growvertical = true;
		$Barbarianpref::mbmwatch::color = "124 252 0";
		
		// mbm 5 name of the item
		// supports up to 4 items
		// i.e. Temp 1, Fan 1, +12.00 etc. or whatever custom names they have.
		
		$Barbarianpref::mbmwatch::slot1 = "";
		$Barbarianpref::mbmwatch::slot2 = "";
		$Barbarianpref::mbmwatch::slot3 = "";
		$Barbarianpref::mbmwatch::slot4 = "";
				
		exec("prefs/barbarianprefs.cs");

		$Barbarianpref::loaded = 1;

		// these are not saved in the prefs file
		
		$MBMWatch::maxfields = 4;
		// for vertically growing hud, height of hud for number of items.  We will use one field width (below)
		// for this kind of hud.
		$MBMWatch::Ht[1] = 16;
		$MBMWatch::Ht[2] = 32;
		$MBMWatch::Ht[3] = 48;
		$MBMWatch::Ht[4] = 64;
		$MBMWatch::Htsingle = 16;

		// for horizontally growing hud, we will use one line from above, and will calculate the width based on
		// number of fields
		$MBMWatch::Wd[1] = 75;
		$MBMWatch::Wd[2] = 150;
		$MBMWatch::Wd[3] = 225;
		$MBMWatch::Wd[4] = 300;
		$MBMWatch::Wdsingle = 75;

	}
}

function MBMWatch::resetcolors(%this)
{
	// function by Uberguy
	if(isobject(MBMWatchExample))
		MBMWatchExample.profile="GuiTextProfile";
	for(%i=1; %i<=$MBMwatch::maxfields; %i++)
	{
		%ob = "MBMWatchText" @ %i;
		if(isobject(%ob))
			%ob.profile="GuiTextProfile";
	}

	if (isObject(MBMWatchTextProfile)) MBMWatchTextProfile.delete();

	new GuiControlProfile(MBMWatchTextProfile) {
		fontType = "Verdama";
		fontSize = "14";
		justify = "center";
		fontcolor=$Barbarianpref::mbmwatch::color;
		fontColors[0] = $Barbarianpref::mbmwatch::color;
		fontColors[6] = $PlayerNameColor;
		fontColors[7] = $TribeTagColor;
		fontColors[8] = $SmurfNameColor;
		fontColors[9] = $BotNameColor;
	};

	if(isobject(MBMWatchExample))
		MBMWatchExample.profile="MBMWatchTextProfile";
	for(%i=1; %i<=$MBMwatch::maxfields; %i++)
	{
		%ob = "MBMWatchText" @ %i;
		if(isobject(%ob))
			%ob.profile="MBMWatchTextProfile";
	}

	
}

function MBMWatchHUD::onResize(%this, %width, %height)
{
	// because HudManager loves to resize it, it seems.
	MBMWatch.reset();
}

function MBMWatch::reset(%this)
{
	error("RESET");
	%dirty=false;
	MBMWatchHUD.profile = $Barbarianpref::mbmwatch::transparent ? GuiConsoleProfile : GuiChatBackProfile;

	%highest = 1;
	// figure out the highest non-blank field in the setup (i.e. how many fields are we displaying)
	// if there are none we will still display one (empty) field
	for(%i=1; %i<=$MBMwatch::maxfields; %i++)
		if($Barbarianpref::mbmwatch::slot[%i] !$= "")
			%highest=%i;
	
	if(%highest != $MBMWatch::numentries)
		%dirty = true;

	$MBMWatch::numentries = %highest;

	for(%i=1; %i<=$MBMwatch::maxfields; %i++)
	{
		%ob = "MBMWatchText" @ %i;
		%ob.setvisible( %i <= $MBMWatch::numentries);
	}

	// position the individual fields and calc overall hud size
	if($Barbarianpref::mbmwatch::growvertical)
	{
		for(%i=1; %i<=$MBMWatch::numentries; %i++)
		{
			%ob = "MBMWatchText" @ %i;
			%ob.setposition(4,$MBMWatch::Ht[%i]-$MBMWatch::Htsingle);
		}
		%width=$MBMWatch::Wdsingle+10;
		%height=$MBMWatch::Htsingle*$MBMWatch::numentries+4;
	}
	else
	{
		for(%i=1; %i<=$MBMWatch::numentries; %i++)
		{
			%ob = "MBMWatchText" @ %i;
			%ob.setposition($MBMWatch::Wd[%i]-$MBMWatch::Wdsingle,2);
		}
		%width=$MBMWatch::Wdsingle*$MBMWatch::numentries+10;
		%height=$MBMWatch::Htsingle+4;
	}

	MBMWatch.width = %width;
	MBMWatch.height = %height;

	if( (%width != getword(MBMWatchHud.extent,0)) || (%height != getword(MBMWatchHud.extent,1)) )
		%dirty = true;
	MBMWatchHUD.extent = %width SPC %height;

//	if(%dirty) 	// only set position if this is the first time in MBMWatch.reset this session 
//	{		// or if the width or height has changed.  Hopefully this will prevent interferring with Hudmanager/mover
//		// set position
//		// just above objective hud, preferably
//		%xpos = 0;
//		%ypos = getWord($pref::Video::resolution, 1) - getword(MBMWatchHud.extent,1) - 37;
//
//		MBMWatchHUD.setposition(%xpos,%ypos);
//	}

}

function MBMWatch::setup(%this)
{
	%this.resetcolors();

	if(!isobject(MBMWatchHUD))
	{
		// default left hand side, we reset this in MBMWatch.reset()
		%x = 0;
		%y = mFloor(getWord($pref::Video::resolution, 1)/2);
				
		new ShellFieldCtrl(MBMWatchHUD) {
			profile = $Barbarianpref::mbmwatch::transparent ? GuiConsoleProfile : GuiChatBackProfile;
			horizSizing = "center";
			vertSizing = "bottom";
			position = %x SPC %y;
			extent = "310 20";
			minExtent = "16 18";
			visible = "1";
			hideCursor = "1";
			bypassHideCursor = "0";
			helpTag = "0";

			new GuiTextCtrl(MBMWatchText1) {
				profile = "MBMWatchTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "0 2";
				extent = "75 16";
				visible = "0";
				text = "";
			};
			new GuiTextCtrl(MBMWatchText2) {
				profile = "MBMWatchTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "75 2";
				extent = "75 16";
				visible = "0";
				text = "";
			};
			new GuiTextCtrl(MBMWatchText3) {
				profile = "MBMWatchTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "150 2";
				extent = "75 16";
				visible = "0";
				text = "";
			};
			new GuiTextCtrl(MBMWatchText4) {
				profile = "MBMWatchTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "225 2";
				extent = "75 16";
				visible = "0";
				text = "";
			};
		};
	}
}

function MBMWatch::savePrefs(%this) {
	export("$Barbarianpref::*", "prefs/barbarianprefs.cs", false);
}

function MBMWatch::update(%this)
{
	for(%i=1; %i<=$MBMWatch::numentries; %i++)
	{
		%ob = "MBMWatchText" @ %i;
		%ob.settext($Barbarianpref::mbmwatch::slot[%i] @ ":" SPC $MBMWatch::Value[%i]);
	}
	// Hudmanager will keep resizing this script when you come back from options unless this is here.
	MBMWatchHUD.extent = MBMWatch.width SPC MBMWatch.height;

}

function MBMWatchUpdate()
{
	if(MBMWatch.thread != 0)
		cancel(MBMWatch.thread);

	if(MBMLogFile.openForRead($Barbarianpref::mbmwatch::logfile))
	{
		if(!MBMLogFile.isEOF())
			%names = MBMLogFile.readLine();
		if(!MBMLogFile.isEOF())
			%values = MBMLogFile.readLine();

		MBMLogFile.close();
	}

	if( (%names $= "" ) || (%values $= "") )
	{
		error(formatTimeString("hh:nn:ss A") SPC "MBMWatchUpdate: Cannot read from " @ $Barbarianpref::mbmwatch::logfile);
		for(%i=1;%i<=$MBMWatch::numentries;%i++)
			$MBMWatch::Value[%i]="";
	}
	else
	{


		// data will look something like this -- but maybe without custom names
		// ; deliminated
		// will use nextToken(%text,%value,";") or similar on it;
		// names = ;;;CPU;MB;ref;Core 0;Core 1;+3.3;+5.00;+12.00;-12.00;-5.00;CPUFan;MBFan;Fan 3;
		// values = 24/02/2004;1:42:34 AM;1731 MHz;39 C;28 C;22 C;1.76 V;0.32 V;3.39 V;4.95 V;12.13 V;0.00 V;0.00 V;5720 RPM;2410 RPM;0 RPM;
		// also notice we can grab the TIME the reading was taken at--if this matches the last time, will just return and not update

		//nextToken skips past empty values so on keys it will go right to first temp value, so we must read the first three now
		%values=nextToken(%values,value,";"); // date
		%values=nextToken(%values,value,";"); // time
		if($MBMWatch::lastupdate $= %value)
		{
			// we already have these values, schedule for the next update and don't
			// waste any more precious fps on time wasting cpu cycles
			MBMWatch.thread = schedule(1000*$Barbarianpref::mbmwatch::logtime, 0, MBMWatchUpdate);
			return;
		}
		$MBMWatch::lastupdate = %value;
		
		// reset values to blank
		for(%i=1;%i<=$MBMWatch::numentries;%i++)
			$MBMWatch::Value[%i]="";

		%values=nextToken(%values,value,";"); // mhz

		while(%names !$= "")
		{
			%names=nextToken(%names,thename,";");
			%values=nextToken(%values,value,";");

			if(%thename !$= "")
				for(%i=1;%i<=$MBMWatch::numentries;%i++)
					if( %thename $= $Barbarianpref::mbmwatch::slot[%i])
					{
						// ho ho what is this?
						// this lets us use the same names for temps and fans, for example
						// in MBM 5, you could name the CPU temp and fan both "CPU"
						// just make sure in the MBM Watch script page to put two entries
						// for CPU then, and you are set!
						if($MBMWatch::Value[%i] $= "")
						{
							$MBMWatch::Value[%i]=%value;	
							break;
						}
					}

		}

		// it's as simple as that!
	}
	// call the update function
	MBMWatch.update();

	MBMWatch.thread = schedule(1000*$Barbarianpref::mbmwatch::logtime, 0, MBMWatchUpdate);
}

package MBMWatchpkg {

	function quit() {
		// after Uberguy's method
		if (!$BarbarianPrefsSaved) {
			MBMWatch.savePrefs();
			$BarbarianPrefsSaved = true;
		}

		if(isobject(MBMLogFile))
		{
			MBMLogFile.close();
			MBMLogFile.delete();
		}

		parent::quit();
	}

	function LoadingGui::onwake(%this)
	{
		parent::onwake(%this);
		if(isObject(HM) && isObject(HudMover))
			hudmover::addhud(MBMWatchHUD, "MBM Watch");
		playGui.add(MBMWatchHUD);
	}

	function PlayGui::onwake(%this)
	{
		parent::onwake(%this);
		if(MBMWatch.thread != 0)
			cancel(MBMWatch.thread);
		// one second for first schedule
		// as soon as this executes then it will be scheduled as per user preferences
		MBMWatch.thread = schedule(1000, 0, MBMWatchUpdate);


		if(!isobject(MBMLogFile))
		{
			new FileObject(MBMLogFile);
		}
		MBMWatch.reset();

	}

	function PlayGui::onSleep(%this)
	{
		parent::onSleep(%this);
		if(MBMWatch.thread != 0)
			cancel(MBMWatch.thread);		
	}

}; // package

activatepackage(MBMWatchpkg);

MBMWatch.loadprefs(true);
MBMWatch.setup();
MBMWatch.reset();

if (!isObject(MBMWatchGUI)) {
	// portions are from Uberguy's Timehud
	// color sliders are from Uberguy's UberChat
	new GuiControl(MBMWatchGUI) {
		profile = "GuiDefaultProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "0 21";
		extent = "300 300";
		minExtent = "300 300";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";

		new ShellFieldCtrl() {
			profile = "ShellFieldProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "0 0";
			extent = "300 300";
			minExtent = "16 18";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";

			new GuiTextCtrl() {
				profile = "DebriefHeadlineTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "60 27";
				extent = "179 32";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "MBM Watcher Options";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(MBMWatchTrans) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 53";
				extent = "106 30";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$Barbarianpref::mbmwatch::transparent";
				command = "MBMWatch.Reset();";
				helpTag = "0";
				text = "Transparent HUD";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(MBMWatchVert) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 73";
				extent = "106 30";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$Barbarianpref::mbmwatch::growvertical";
				command = "MBMWatch.Reset();";
				helpTag = "0";
				text = "Grow Vertically";
				longTextBuffer = "0";
				maxLength = "255";
			};

			new GuiTextCtrl(MBMWatchTime) {
				profile = "TaskHudTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 113";
				extent = "47 60";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "Check every " @ $Barbarianpref::mbmwatch::logtime SPC "s";
				longTextBuffer = "0";
				maxLength = "255";
				fontcolor = "0 255 0";
				};
			new ShellFieldCtrl() {
				profile = "ShellFieldProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "26 127";
				extent = "96 27";
				minExtent = "16 18";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";

				new ShellSliderCtrl(MBMWatch_Time) {
					profile = "ShellSliderProfile";
					horizSizing = "center";
					vertSizing = "center";
					position = "5 1";
					extent = "86 24";
					minExtent = "12 24";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					variable = "value";
					command = "MBMWatchGui.settime(1);";
					altCommand = "MBMWatchGui.settime(0);";
					helpTag = "0";
					range = "1 30";
					ticks = "10";
					value = $Barbarianpref::mbmwatch::logtime;
					usePlusMinus = "0";

					format = "%1.0f";
				};
			};

			new ShellTextEditCtrl() {
				profile = "NewTextEditProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 154";
				extent = "85 30";
				minExtent = "10 10";
				visible = "1";
				variable = "$Barbarianpref::mbmwatch::slot1";
				command = "MBMWatch.Reset();";
				helpTag = "0";
				historySize = "0";
				maxLength = "256";
				password = "0";
				glowOffset = "9 9";
			};

			new ShellTextEditCtrl() {
				profile = "NewTextEditProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 184";
				extent = "85 30";
				minExtent = "10 10";
				visible = "1";
				variable = "$Barbarianpref::mbmwatch::slot2";
				command = "MBMWatch.Reset();";
				helpTag = "0";
				historySize = "0";
				maxLength = "256";
				password = "0";
				glowOffset = "9 9";
			};
			new ShellTextEditCtrl() {
				profile = "NewTextEditProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 214";
				extent = "85 30";
				minExtent = "10 10";
				visible = "1";
				variable = "$Barbarianpref::mbmwatch::slot3";
				command = "MBMWatch.Reset();";
				helpTag = "0";
				historySize = "0";
				maxLength = "256";
				password = "0";
				glowOffset = "9 9";
			};
			new ShellTextEditCtrl() {
				profile = "NewTextEditProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 244";
				extent = "85 30";
				minExtent = "10 10";
				visible = "1";
				variable = "$Barbarianpref::mbmwatch::slot4";
				command = "MBMWatch.Reset();";
				helpTag = "0";
				historySize = "0";
				maxLength = "256";
				password = "0";
				glowOffset = "9 9";
			};
			new ShellBitmapButton() {
				profile = "ShellButtonProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "120 244";
				extent = "85 30";
				minExtent = "32 38";
				visible = "1";
				command = "MBMWatch.Reset();";
				helpTag = "0";
				text = "APPLY";
				simpleStyle = "0";
			};
	

			new ShellFieldCtrl() {
				profile = "ShellFieldProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "150 62";
				extent = "119 143";
				minExtent = "16 18";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";

				new GuiTextCtrl(MBMWatchGreen) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 52";
					extent = "60 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "GREEN ("   @ getWord($Barbarianpref::mbmwatch::color,1) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "0 255 0";
				};
				new GuiTextCtrl(MBMWatchRed) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 8";
					extent = "41 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "RED ("   @ getWord($Barbarianpref::mbmwatch::color,0) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "255 0 0";
				};
				new GuiTextCtrl(MBMWatchBlue) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 94";
					extent = "46 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "BLUE ("   @ getWord($Barbarianpref::mbmwatch::color,2) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "0 0 255";
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 22";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(MBMWatch_Red) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "MBMWatchGui.setColors(1);";
						altCommand = "MBMWatchGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($Barbarianpref::mbmwatch::color,0);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 66";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(MBMWatch_Green) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "MBMWatchGui.setColors(1);";
						altCommand = "MBMWatchGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($Barbarianpref::mbmwatch::color,1);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 108";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(MBMWatch_Blue) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "MBMWatchGui.setColors(1);";
						altCommand = "MBMWatchGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($Barbarianpref::mbmwatch::color,2);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};

			}; // Color changer thingy
			new GuiTextCtrl(MBMWatchExample) {
				profile = "MBMWatchTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "154 205";
				extent = "111 14";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "Example Text";
				longTextBuffer = "0";
				maxLength = "255";
			};


		};  //ShellField
		
	};
}

function MBMWatchGui::settime(%this, %done)
{
	%time=mCeil(MBMWatch_Time.value);
	MBMWatchTime.setValue("Check every " @ %time SPC "s");
	if(%done)
		$Barbarianpref::mbmwatch::logtime=%time;
}

function MBMWatchGui::setColors(%this, %done) 
{

	// function by Uberguy
	%R = mCeil(MBMWatch_Red.value);
	%G = mCeil(MBMWatch_Green.value);
	%B = mCeil(MBMWatch_Blue.value);

	MBMWatchRed.setValue("RED ("   @ %R @ ")");
	MBMWatchGreen.setValue("GREEN (" @ %G @ ")");
	MBMWatchBlue.setValue("BLUE ("  @ %B @ ")");

	if (%done) {
		$Barbarianpref::mbmwatch::color=%R SPC %G SPC %B;
		MBMWatchExample.setvisible(false);
		MBMWatchText.setvisible(false);

		MBMWatch.resetcolors();

		MBMWatchExample.setvisible(true);
		MBMWatchText.setvisible(true);
	}
}

function MBMWatchGui::onWake(%this)
{

}


