// #autoload
// #name = Crew HUD
// #version = 0.2
// #date = January 2, 2004.
// #author = Barbarian
// #warrior = Barb4rian
// #email = conanford@hotmail.com
// #web = http://barb4rian.tripod.com/crewhud.html
// #description = Displays bomber/havoc/tank crew in small HUD when you are in the vehicle, when names are known (i.e. someone boarded after you).  Hudmanager compatiable.
// #category = Barbarian
// #config = CrewHUDGUI
// #include = support/team_tracker.cs
// #readme = scripts/barbarian/CrewHUD.txt
// #status = Beta
// #credit = The following people whose scripts I used for reference
// #credit = Lou Cypher
// #credit = Ilys
// #credit = Sweeper
// #credit = Uberguy


if (!isObject(CrewHUD))
    new ScriptObject(CrewHUD) {
        class = CrewHUD;
	version = 0.1;
	savename = "";
	vehtype="";
	picture="";
	active=false;
	Force=false;
	myposition=-1;
	extensions=false;
    };


function CrewHUD::SetupTextLocations(%this)
{
	if(%this.picture $= "gui/hud_veh_icon_hapc.png")
	{
		CrewHUDName0.setposition(39,72);
		CrewHUDName1.setposition(39,97);
		CrewHUDName2.setposition(0,33);
		CrewHUDName3.setposition(0,54);
		CrewHUDName4.setposition(80,54);
		CrewHUDName5.setposition(80,33);
	}
	else if(%this.picture $= "gui/hud_veh_icon_bomber.png")
	{
		CrewHUDName0.setposition(39,29);
		CrewHUDName1.setposition(39,42);
		CrewHUDName2.setposition(39,90);
	}
	else if(%this.picture $= "gui/hud_veh_icon_assault.png")
	{
		CrewHUDName0.setposition(39,32);
		CrewHUDName1.setposition(39,64);
	}
	else
	{
		echo("error: CrewHUD: unrecognized vehicle");
	}
}


function CrewHUD::detribifyname(%this,%name)
{
	// we want the base name only for the player, if possible
	%name = detag(%name);

	%p6 = strstr(%name,"\c6");
	%p7 = strstr(%name,"\c7");
	%p10 = strstr(%name,"\x10");
	%p11 = strstr(%name,"\x11");
	
	// three cases: tribe tag after, before, or none
	// name will look like this: \x10\c6Barb4rian\c7.cs\x11
	// or \x10\c7=[OI]=\c6OnSale\x11
	// or \x10\c6Username\x11
	//    \x10\c7|HV| \c6_coldblood_\x11

	if( (%p7 == -1) && (%p6 != -1) && (%p11 != -1) )
	{
		// no tribe tag, simple.
		%detribed=stripMLControlChars(getSubStr(%name,%p6+1,%p11-1));
		return( %detribed );
	}
	if ( (%p7 > %p6) && (%p6 != -1) && (%p7 != -1) )
	{
		// tribes tag is after name..
		//sometimes no-tribe tags too
		%detribed=stripMLControlChars(getSubStr(%name,%p6+1,%p7-1));
		return( %detribed );
	}
	if ( (%p7 < %p6) && (%p6 != -1) && (%p7 != -1) && (%p11 != -1))
	{
		// tribes tag precedes name
		%detribed=stripMLControlChars(getSubStr(%name,%p6+1,%p11-1));
		return( %detribed );
	}
	
	// but if none matched
	return( stripMLcontrolchars(%name) );
}



function CrewHUD::Reset(%this)
{
	// these pref settings are handled by this
	//if ($pref::CrewHud::trans $= "") $pref::CrewHUD::trans = false;
	//if ($pref::CrewHud::showbitmap $= "") $pref::CrewHud::showbitmap = true;

	// occupied seats saying (occupied) when no name is known are handled by the function called 
	// at the bottom of this one
	//if ($pref::CrewHud::showoccupied $= "") $pref::CrewHud::showoccupied = true;

	// $pref::CrewHud::enable is also handled by CrewHudMenu()

	if(CrewHUD.active)
	{
		// shutdown the hud if visible
		CrewHUDMenuExit(true);
	}
	CrewHUDHUD.profile = $pref::CrewHud::trans ? GuiConsoleProfile : GuiChatBackProfile;
	
	if($pref::CrewHud::showbitmap)
		CrewHUDPicture.setVisible(true);
	else
		CrewHUDPicture.setVisible(false);

	if(playGui.isMember(CrewHUDHUD)) playGui.remove(CrewHUDHUD);
	playGui.add(CrewHUDHUD);

	if(CrewHUD.active)
	{
		// recycle the hud if visible
		CrewHUDMenu(true);
	}
		
}

function CrewHUD::ResetList(%this)
{
	// maintains the passengers list
	for(%i=0;%i<6;%i++)
	{
		$CrewHUD::passengers[%i]="";
	}
	CrewHUD.savename="";
}

function CrewHUD::ResetSeats()
{
	// maintains the seating array
	for(%i=0;%i<6;%i++)
	{
		$CrewHUD::seats[%i]=false;
	}
}

function CrewHUD::resetcolors(%this)
{
	// function by Uberguy
	if(isobject(CrewHUDExample))
		CrewHUDExample.profile="GuiTextProfile";
	for(%i=0;%i<6;%i++)
	{
		%p=CrewHUDName @ %i;
		if(isobject(%p))
			%p.profile="GuiTextProfile";
	}


	if (isObject(CrewNameTextProfile)) CrewNameTextProfile.delete();
	new GuiControlProfile ("CrewNameTextProfile")
	{
		fontType = "Univers Condensed";
		fontSize = 12;
		fontColor = $pref::CrewHud::color;
		justify = "left";
	};

	if(isobject(CrewHUDExample))
		CrewHUDExample.profile="CrewNameTextProfile";

	for(%i=0;%i<6;%i++)
	{
		%p=CrewHUDName @ %i;
		if(isobject(%p))
			%p.profile="CrewNameTextProfile";
	}

}

function CrewHUD::Setup(%this)
{
	if(! %this.extensions)
	{
		// setup script extensions, these functions extend the functionality of other scripts of mine
		$ChatAlertCheckMessage_sub[$ChatAlertCheckMessage_subs+0] = "CrewHUD";
		$ChatAlertCheckMessage_subs++;
		// +0 is necessary because if this is the first extension, index will be "" instead of 0 otherwise
		// this eliminates the need for another if or any of that silliness
		$ChatMacroProcess_sub[$ChatMacroProcess_subs+0] = "CrewHUD";
		$ChatMacroProcess_subs++;
		%this.extensions=true;
	}
	if ($pref::CrewHud::enable $= "") $pref::CrewHud::enable = true;
	if ($pref::CrewHud::trans $= "") $pref::CrewHUD::trans = false;
	if ($pref::CrewHud::showbitmap $= "") $pref::CrewHud::showbitmap = true;
	if ($pref::CrewHud::showoccupied $= "") $pref::CrewHud::showoccupied = true;
	if ($pref::CrewHud::color $= "") $pref::CrewHud::color = "124 252 0";
	if ($pref::CrewHud::extendmacros $= "") $pref::CrewHud::extendmacros = true;
	if ($pref::CrewHud::extendalert $= "") $pref::CrewHud::extendalert = true;

	// Setup vehicles here, with which picture to show
	$CrewHUD::PicBomber="gui/hud_veh_icon_bomber.png";
	$CrewHUD::PicHAPC="gui/hud_veh_icon_hapc.png";
	$CrewHUD::PicAssault="gui/hud_veh_icon_assault.png";
	$CrewHUD::PicFLPC="gui/hud_veh_icon_hapc.png";
	$CrewHUD::PicTACBomber="gui/hud_veh_icon_bomber.png";
	$CrewHUD::PicTACHAPC="gui/hud_veh_icon_hapc.png";
	$CrewHUD::PicDefault="gui/hud_veh_icon_hapc.png";

	CrewHUD.resetcolors();

	if (!isObject(CrewHUDHUD)) {
		//--- OBJECT WRITE BEGIN ---
	new ShellFieldCtrl(CrewHUDHUD) {
		profile = $pref::CrewHud::trans ? GuiConsoleProfile : GuiChatBackProfile;
		horizSizing = "left";
		vertSizing = "bottom";
		position = "0 384";
		extent = "128 128";
		minExtent = "8 8";
		visible = "0";
		hideCursor = "1";
		bypassHideCursor = "0";
		
			new GuiBitmapCtrl(CrewHUDPicture) {
				profile = "GuiDefaultProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "0 0";
				extent = "128 128";
				visible = $pref::CrewHud::showbitmap ? 1 : 0;
				bitmap = "gui/hud_hv_icon_hapc.png";
			};
			new GuiTextCtrl(CrewHUDName0) {
				profile = "CrewNameTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "39 77";
				extent = "48 16";
				visible = "1";
				text = "";
			};
			new GuiTextCtrl(CrewHUDName1) {
				profile = "CrewNameTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "39 94";
				extent = "48 16";
				visible = "1";
				text = "";
			};


			new GuiTextCtrl(CrewHUDName2) {
				profile = "CrewNameTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "0 30";
				extent = "48 16";
				visible = "1";
				text = "";
			};


			new GuiTextCtrl(CrewHUDName3) {
				profile = "CrewNameTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "0 55";
				extent = "48 16";
				visible = "1";
				text = "";
			};


			new GuiTextCtrl(CrewHUDName4) {
				profile = "CrewNameTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "80 55";
				extent = "48 16";
				minExtent = "8 8";
				visible = "1";
				text = "";
			};


			new GuiTextCtrl(CrewHUDName5) {
				profile = "CrewNameTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "80 30";
				extent = "48 16";
				minExtent = "8 8";
				visible = "1";
				text = "";
			};
		//--- OBJECT WRITE END ---
		};

	} // if

	
}

function CrewHUD::updatenames()
{
	if(CrewHUD.active)
		for(%i=0; %i<6; %i++)
		{
			%pass = "CrewHUDName" @ %i;
			if(isObject(%pass))
			{
				if(%i < $CrewHUD::numseats)
				{	
					if ( ( $CrewHUD::passengers[%i] $= "" ) && ($CrewHUD::seats[%i]) && ($pref::CrewHud::showoccupied))
						%thetext="(occupied)";
					else
						%thetext=$CrewHUD::passengers[%i];
				}
				else
					%thetext=" ";
				%pass.settext(%thetext);
			}
		}
}


function CrewHUDMenu(%this)
{
	if(%this && ( CrewHUD.picture !$= "" ) && ($pref::CrewHud::enable))
	{
		CrewHUD.active=true;
		CrewHUD.updatenames();
		CrewHUDPicture.setbitmap(CrewHUD.picture);

		//Canvas.pushDialog(CrewHUDHUD);
		CrewHUDHUD.setVisible(true);
		
	}
}

function CrewHUDMenuExit(%this)
{
	if(%this)
	{
		//Canvas.popDialog(CrewHUDHUD);
		CrewHUDHUD.setVisible(false);
		CrewHUD.active=false;	
	}
}

function CrewHUD::ChatAlertCheckMessage(%this,%flag,%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10)
{
	// extension for ChatAlert
	if($pref::CrewHud::extendalert)
	{
		if ( detag(%sender) != TeamTracker.getmanagerid()) // don't bother if we are the sender
		{
			// all we want to do is check if sender is someone in our vehicle
			// The names of the passengers in CrewHud::passengers[] are already detagged, detribed, and stripped
			// %originator=CrewHUD.detribifyname(%a1);
			%originator=%this.detribifyname(TeamTracker.getClientName(%sender,1));
			for(%i=0;%i<6;%i++)
				if( ( $CrewHud::passengers[%i] !$= "" ) && (%originator $= $CrewHud::passengers[%i]) )
					%flag=true;
		}
	}
	return(%flag);
}

function CrewHUD::ChatMacroProcess(%this,%fmtString)
{
	// extension for ChatMacros, if it is installed
	if($pref::CrewHud::extendmacros)
	{
		// If ChatMacros is installed, adds the following keys to global and team chat:
		// %vtype = type of vehicle you're in
		// %myseat= what vehicle seat you occupy
		// %seat1 = name of pilot, or "Pilot" if unknown
		// %seat2 = name of second passenger, or "Tailgunner" (havoc), "Bombardier" (all others) if unknown
		// %seat3 = name of third passenger or "Bombardier" for all except havoc, "Passenger" for havoc

		if( strstr(%fmtstring,"%vtype") != -1)
		{
			%tempvalue=CrewHUD.vehtype;
			%fmtString = strreplace(%fmtString, "%vtype", %tempvalue);
		}
		if( strstr(%fmtstring,"%seat1") != -1)
		{
			// "passenger 1" i.e. pilot, trys to get their name
			%tempvalue=($CrewHud::passengers[0] !$= "") ? $CrewHud::passengers[0] : "Pilot";
			%fmtString = strreplace(%fmtString, "%seat1", %tempvalue);
		}

		if(CrewHud.picture $= "gui/hud_veh_icon_hapc.png")
		{
			// in a havoc, main operators are pilot, tailgunner, and passengers as a group
			if( strstr(%fmtstring,"%seat2") != -1)
			{
				%tempvalue=($CrewHud::passengers[1] !$= "") ? $CrewHud::passengers[1] : "Tailgunner";
				%fmtString = strreplace(%fmtString, "%seat2", %tempvalue);
			}
			if( strstr(%fmtstring,"%seat3") != -1)
			{
				%tempvalue="Passenger";
				%fmtString = strreplace(%fmtString, "%seat3", %tempvalue);
			}
	
			if( strstr(%fmtstring,"%myseat") != -1)
			{
				if(CrewHud.myposition == -1)
					%tempvalue="Ground";
				else if(CrewHud.myposition == 0)
					%tempvalue="Pilot";
				else if (CrewHud.myposition == 1)
					%tempvalue="Tailgunner";
				else
					%tempvalue="Passenger";
				%fmtString = strreplace(%fmtString, "%myseat", %tempvalue);
			}
		}
		else
		{
			if( strstr(%fmtstring,"%seat2") != -1)
			{
				%tempvalue=($CrewHud::passengers[1] !$= "") ? $CrewHud::passengers[1] : "Bombardier";
				%fmtString = strreplace(%fmtString, "%seat2", %tempvalue);
			}
			if( strstr(%fmtstring,"%seat3") != -1)
			{
				%tempvalue=($CrewHud::passengers[2] !$= "") ? $CrewHud::passengers[2] : "Tailgunner";
				%fmtString = strreplace(%fmtString, "%seat3", %tempvalue);
			}

			if( strstr(%fmtstring,"%myseat") != -1)
			{
				if(CrewHud.myposition == -1)
					%tempvalue="Ground";
				else if(CrewHud.myposition == 0)
					%tempvalue="Pilot";
				else if (CrewHud.myposition == 1)
					%tempvalue="Bombardier";
				else if (CrewHud.myposition == 2)
					%tempvalue="Tailgunner";
				else
					%tempvalue="Passenger";
				%fmtString = strreplace(%fmtString, "%myseat", %tempvalue);
			}
		}
	}
	return(%fmtString);
} 





// packaged functions
package CrewHUDPkg {

	function defaultMessageCallback(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10) 
	{
		parent::defaultMessageCallback(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);

		if ( (detag(%msgType) $= "MsgShowPassenger") && (strstr(%msgString,"has boarded") > 0) )
		{
			// "Teammate: blah has boarded in the (pilot/gunner/tailgunner/passenger) position"		

			%boardname=CrewHUD.detribifyname(%a1);
					
			// some mods say Pilot, some say pilot...
			%boardlocation=strupr(detag(%a2));

			echo(%boardname SPC %boardlocation);

			if(%boardlocation $= "PILOT")
			{
				$CrewHUD::passengers[0]=%boardname;
				CrewHUD.updatenames();
			}
			else if (%boardlocation $= "GUNNER")
			{
				$CrewHUD::passengers[1]=%boardname;
				CrewHUD.updatenames();
			}
			else if (%boardlocation $= "TAILGUNNER")
			{
				if(strupr(CrewHUD.vehtype) $= "HAPC")
					$CrewHUD::passengers[1]=%boardname;
				else
					$CrewHUD::passengers[2]=%boardname;
				CrewHUD.updatenames();			
			}
			else
				CrewHUD.savename=%boardname;
				// save the name and hopefully get his position from clientCmdShowPassenger

		}
	}

	function clientCmdCheckPassengers(%pString)
	{
		parent::clientCmdCheckPassengers(%pString);

		// from client.cs
		// this is called when we jump on board a ship, and sets the inital hud dots

		// since each slot is represented by a "1" or a "0" followed by a space, the length
		// of the string divided by 2 is equal to the number of slots in the vehicle
		%numSlots = strlen(%pString) / 2;

		// if we have >1 seat and an unknown vehicle type, use the HAPC icon (probably we
		// are in TAC or something)		
		if( (%numSlots>1) && (CrewHUD.picture $= "") )	
			CrewHUD.picture=$CrewHUD::Pic["Default"];

		$CrewHUD::numseats=%numSlots;

		for(%i = 0; %i < %numSlots; %i++)
		{
			if(getWord(%pString, %i) $= "1")
				$CrewHUD::seats[%i]=true;
			else
				$CrewHUD::seats[%i]=false;

		}
		CrewHUD.updatenames();
	}

	function clientCmdShowPassenger(%slot, %full)
	{
		parent::clientCmdShowPassenger(%slot, %full);
		if(%full)
		{	
			$CrewHUD::seats[%slot]=true;
			if(CrewHUD.savename !$= "")
			{
				// this is used in Havocs, where everyone is called "passenger", this way
				// we can find what slot they are in!
				//echo("used savename " @ CrewHUD.savename @ " for position " @ %slot);
				$CrewHUD::passengers[%slot]=CrewHUD.savename;	
				CrewHUD.savename="";
			}
		}
		else
		{
			// player ejected from slot
			$CrewHUD::passengers[%slot]="";
			$CrewHUD::seats[%slot]=false;
		}
		CrewHUD.updatenames();
	}

	function LoadingGui::onWake(%this) {

		parent::onWake(%this);
		if(isObject(HM) && isObject(HudMover))
			hudmover::addhud(CrewHUDHUD, "Crew HUD");
		playGui.add(CrewHUDHUD);
	}

	function ClientCmdSetHudMode(%mode, %type, %node)
	{
		parent::ClientCmdSetHudMode(%mode, %type, %node);

		%vehmode=detag(%mode);
		%vehnode=detag(%node);		

		//echo("mode:" SPC %mode SPC "type:" SPC %type SPC "node:" SPC %node);

		// IF we just boarded a vehicle..
		if( %vehmode $= "Pilot" || %vehmode $= "Passenger" || %vehmode $= "Tailgunner" || %vehmode $= "Gunner" )
		{

			CrewHUD.myposition=%vehnode; // 0 through 5
			// echo("You boarded " @ %vehnode SPC "as " @ %vehmode);
			CrewHUD.vehtype=detag(%type);

			CrewHUD.picture=$CrewHUD::Pic[CrewHUD.vehtype];

			CrewHUD.SetupTextLocations();
		
			$CrewHUD::passengers[%vehnode]=CrewHUD.detribifyname(TeamTracker.getManagerName());

			//activate the HUD
			CrewHUDMenu(true);
		}
		else if (%vehmode $= "Standard")
		{
			// we disembarked from, say, a havoc..
			CrewHUD.myposition=-1;
			CrewHUD.picture="";
			CrewHUD.vehtype="";
			if(CrewHUD.active)
				CrewHUDMenuExit(true);
			CrewHUD.ResetList();
			CrewHUD.ResetSeats();			
		}

	}

	function clientCmdVehicleDismount() {
		if( CrewHUD.vehtype !$= "" )
		{
			CrewHUD.picture="";
			CrewHUD.vehtype="";
			if(CrewHUD.active)
				CrewHUDMenuExit(true);
			CrewHUD.ResetList();
			CrewHUD.ResetSeats();
		}
		parent::clientCmdVehicleDismount();
	}

	function clientCmdTogglePlayHuds(%val) {
		parent::clientCmdTogglePlayHuds(%val);
		if(CrewHUD.active)
		{
			CrewHUDHUD.setVisible(%val);
		}
	}



}; //CrewHUDPkg

activatepackage(CrewHUDPkg);


CrewHUD::Setup();


if (!isObject(CrewHUDGUI)) {
	// portions are from Uberguy's Timehud
	new GuiControl(CrewHUDGUI) {
		profile = "GuiDefaultProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "0 21";
		extent = "300 300";
		minExtent = "300 300";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";

		new ShellFieldCtrl() {
			profile = "ShellFieldProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "0 0";
			extent = "300 300";
			minExtent = "16 18";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";

			new GuiTextCtrl() {
				profile = "DebriefHeadlineTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "60 27";
				extent = "179 32";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "Crew HUD Options";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(CrewHUDEnable) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "20 73";
				extent = "106 37";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$pref::CrewHud::enable";
				command = "CrewHud.reset();";
				helpTag = "0";
				text = "Show Crew HUD";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(CrewHUDTransparent) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "20 103";
				extent = "106 37";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$pref::CrewHud::trans";
				command = "CrewHud.reset();";
				helpTag = "0";
				text = "Transparent Back";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(CrewHUDBitmap) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "20 133";
				extent = "106 37";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$pref::CrewHud::showbitmap";
				command = "CrewHud.reset();";
				helpTag = "0";
				text = "Show ship bitmap";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(CrewHUDOccupied) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "20 163";
				extent = "106 37";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$pref::CrewHud::showoccupied";
				command = "CrewHud.reset();";
				helpTag = "0";
				text = "Show (unknown)";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new GuiTextCtrl() {
				profile = "TaskHudTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "20 205";
				extent = "106 14";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "Script Extensions:";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(CrewHUDAlert) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "20 223";
				extent = "126 37";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$pref::CrewHUD::extendalert";
				helpTag = "0";
				text = "Extend ChatAlert";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(CrewHUDMacros) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "20 253";
				extent = "126 37";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$pref::CrewHUD::extendMacros";
				helpTag = "0";
				text = "Extend ChatMacros";
				longTextBuffer = "0";
				maxLength = "255";
			};
			//start color thingy, from Uberguy's UberChat
			new ShellFieldCtrl() {
				profile = "ShellFieldProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "150 62";
				extent = "119 143";
				minExtent = "16 18";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";

				new GuiTextCtrl(CrewHUDGreen) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 52";
					extent = "60 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "GREEN ("   @ getWord($pref::CrewHUD::color,1) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "0 255 0";
				};
				new GuiTextCtrl(CrewHUDRed) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 8";
					extent = "41 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "RED ("   @ getWord($pref::CrewHUD::color,0) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "255 0 0";
				};
				new GuiTextCtrl(CrewHUDBlue) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 94";
					extent = "46 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "BLUE ("   @ getWord($pref::CrewHUD::color,2) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "0 0 255";
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 22";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(CrewHUD_Red) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "CrewHUDGui.setColors(1);";
						altCommand = "CrewHUDGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($pref::CrewHUD::color,0);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 66";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(CrewHUD_Green) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "CrewHUDGui.setColors(1);";
						altCommand = "CrewHUDGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($pref::CrewHUD::color,1);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 108";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(CrewHUD_Blue) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "CrewHUDGui.setColors(1);";
						altCommand = "CrewHUDGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($pref::CrewHUD::color,2);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};

			}; // Color changer thingy
			new GuiTextCtrl(CrewHUDExample) {
				profile = "CrewNameTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "154 205";
				extent = "111 14";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "Example Text";
				longTextBuffer = "0";
				maxLength = "255";
			};

		};
	};
}

function CrewHUDGui::setColors(%this, %done) 
{

	// function by Uberguy
	%R = mCeil(CrewHUD_Red.value);
	%G = mCeil(CrewHUD_Green.value);
	%B = mCeil(CrewHUD_Blue.value);

	CrewHUDRed.setValue("RED ("   @ %R @ ")");
	CrewHUDGreen.setValue("GREEN (" @ %G @ ")");
	CrewHUDBlue.setValue("BLUE ("  @ %B @ ")");

	if (%done) {
		$pref::CrewHUD::color=%R SPC %G SPC %B;
		CrewHUDExample.setvisible(false);
		
		for(%i=0;%i<6;%i++)
		{
			%p=CrewHUDName @ %i;
			if(isobject(%p))
				%p.setvisible(false);
		}

		CrewHUD.resetcolors();

		CrewHUDExample.setvisible(true);

		for(%i=0;%i<6;%i++)
		{
			%p=CrewHUDName @ %i;
			if(isobject(%p))
				%p.setvisible(true);
		}
	}
}

function CrewHUDGui::onwake(%this)
{

}

