// #autoload
// #name = string matching
// #version = 1.00
// #author = Barbarian
// #warrior = Barb4rian
// #email = conanford@hotmail.com
// #web = http://barb4rian.tripod.com/
// #description = wildcard string matching
// #credit = Julian Robichaux (author of Java version)
// #status = done
// #category = barbarian
//

// basic string character matching for Tribes 2
// based on PatternMatch.java ( http://www.nsftools.com/tips/PatternMatch.java) by Julian Robichaux
// modified for Tribes 2 .cs scripting by Conan Ford, conanford@hotmail.com
//
// supports ? and *.  Does NOT support [] since writing this part into Tribes 2 is no fun at all
// Due to Tribes 2 constraints, is NOT case sensitive, unlike the original
//
// This code is distributed according to the following license:
// Quote from PatternMatch.java
//  * You may use this code as you wish, just don't pretend 
//  * that you wrote it yourself, and don't hold me liable for 
//  * anything that it does or doesn't do. If you're feeling 
//  * especially honest, please include a link to nsftools.com
//  * along with the code.
//

// recursion limit.  keeps from accidental infinite loop
$isMatch::maxrecursion=10;
$isMatch::posrecursion=0;

function isMatch(%checkString,%pattern)
{
	$isMatch::posrecursion++;
	if($isMatch::posrecursion > $isMatch::maxrecursion)
	{
		error("isMatch exceeded recursion limit");
		$isMatch::posrecursion--;
		return false;
	}
	%checkStringlength=strlen(%checkString);
	%patternlength=strlen(%pattern);

	for (%i = 0; %i < %checkStringlength; %i++)
	{
		// if we're at the end of the pattern but not the end
		// of the string, return false
		if (%patternPos >= %patternlength)
		{
			$isMatch::posrecursion--;
			return false;
		}
		
		// grab the characters we'll be looking at
		%patternChar = getsubstr(%pattern,%patternPos,1);
		%thisChar = getsubstr(%checkString,%i,1);
		
		
		switch$ (%patternChar)
		{
			// check for '*', which is zero or more characters
			case "*":
				// if this is the last thing we're matching,
				// we have a match
				if (%patternPos >= (%patternlength - 1))
				{
					$isMatch::posrecursion--;
					return true;
				}
				
				// otherwise, do a recursive search
				for (%j = %i; %j < %checkStringlength; %j++)
				{
					if (isMatch(getsubstr(%checkString,%j,%checkStringlength), getsubstr(%pattern,%patternPos + 1,%patternlength)))
					{
						$isMatch::posrecursion--;
						return true;			
					}
				}
				
				// if we never returned from that, there is no match
				$isMatch::posrecursion--;
				return false;
				
				
			// check for '?', which is a single character
			case "?":
				// do nothing, just advance the patternPos at the end	

			default :
				// the default condition is to do an exact character match
				if (%thisChar !$= %patternChar)
				{
					$isMatch::posrecursion--;
					return false;
				}
				
		}
		
		// advance the patternPos before we loop again
		%patternPos++;
		
	}
	
	// if there's still something in the pattern string, check to
	// see if it's one or more '*' characters. If that's all it is,
	// just advance to the end
	for (%j = %patternPos; %j < %patternlength; %j++)
	{
		if (getsubstr(%pattern,%j,1) !$= "*")
			break;
	}
	%patternPos = %j;
	
	// at the end of all this, if we're at the end of the pattern
	// then we have a good match

	$isMatch::posrecursion--;
	if (%patternPos == %patternlength)
		return true;
	else
		return false;
	
}

