// #autoload
// #name = Chat Vote Kick
// #version = 1.20
// #author = Barbarian
// #warrior = Barb4rian
// #email = conan_ford@hotmail.com
// #web = http://barb4rian.tripod.com/
// #description = Type !help in global or team chat box for usage information.
// #status = rc1
// #credit = jsut
// #credit = Julian Robichaux (string wildcard code, in javascript)
// #include = support/player_support.cs
// #include = support/team_tracker.cs
// #include = support/file_tools.cs

if (!isObject(ChatVoteKick))
    new ScriptObject(ChatVoteKick) {
        class = ChatVoteKick;
	version = 1.20;
	name = "Chat Vote Kick";
	author = "Barbarian";
	versionstring = "1.20 rc1 7/21/03";
	logfile="chatvotekicklog.txt";
    };

if( $pref::ChatVoteKick::log $= "")
	$pref::ChatVoteKick::log=true;

function ChatVoteKick::ForceToObserver(%this,%clients,%forceflag)
{
	%clients=trim(%clients);

	if(ChatVoteKick.CountPlayers( %clients ) > 1)
		if(!%forceflag)
			{
				addmessagehudline("!forceobs: to use on multiple clients add /f");
				return;
			}
				

	%clients = nextToken(%clients,clientid," ");

	while(%clientid !$= "")
	{	
		forceToObserver(%clientid);
		%clients = nextToken(%clients,clientid," ");
	}
}

function ChatVoteKick::ForceTeam(%this,%clients,%team,%forceflag)
{
	if(ChatVoteKick.CountPlayers( %clients ) > 1)
		if(!%forceflag)
			{
				addmessagehudline("!forceteam: to use on multiple clients add /f");
				return;
			}

	%clients=trim(%clients);
	%clients = nextToken(%clients,clientid," ");

	while(%clientid !$= "")
	{	
		changePlayersTeam(%clientId, %team);
		%clients = nextToken(%clients,clientid," ");
	}
}

function ChatVoteKick::ForceTeamSwitch(%this,%clients,%forceflag)
{
	if(ChatVoteKick.CountPlayers( %clients ) > 1)
		if(!%forceflag)
			{
				addmessagehudline("!forceswitch: to use on multiple clients add /f");
				return;
			}

	%clients=trim(%clients);
	%clients = nextToken(%clients,clientid," ");

	if(TeamTracker.numTeams < 2)
	{
		return;
	}

	while(%clientid !$= "")
	{	
		%team=PlayerList.getTeamByID(%clientid);
		if(%team == 1)
			%team = 2;
		else if(%team == 2)
			%team = 1;

		changePlayersTeam(%clientId, %team);
		%clients = nextToken(%clients,clientid," ");
	}
}


function ChatVoteKick::BanPlayers(%this,%clients,%forceflag)
{
	if(ChatVoteKick.CountPlayers( %clients ) > 1)
		if(!%forceflag)
			{
				addmessagehudline("!ban: to use on multiple clients add /f");
				return;
			}

	%clients=trim(%clients);
	%clients = nextToken(%clients,clientid," ");

	while(%clientid !$= "")
	{	
		lobbyPlayerVote( BanPlayer, "BAN player", %clientid);	
		%clients = nextToken(%clients,clientid," ");
	}
}

function ChatVoteKick::KickPlayers(%this,%clients,%forceflag)
{
	if(ChatVoteKick.CountPlayers( %clients ) > 1)
		if(!%forceflag)
			{
				addmessagehudline("!kick: to use on multiple clients add /f");
				return;
			}

	%clients=trim(%clients);
	%clients = nextToken(%clients,clientid," ");

	while(%clientid !$= "")
	{	
		lobbyPlayerVote( VoteKickPlayer, "KICK player", %clientid );	
		%clients = nextToken(%clients,clientid," ");
	}
}

function ChatVoteKick::CountPlayers(%this,%clients)
{
	%clients=trim(%clients);
	%clients = nextToken(%clients,clientid," ");
	%count=0;

	while(%clientid !$= "")
	{	
		%count++;
		%clients = nextToken(%clients,clientid," ");
	}
	return(%count);
}

function ChatVoteKick::GetMatching(%this,%expr)
{
	%players=0;	
	for(%count=0;%count<=TeamTracker.numTeams;%count++)
		%players += TeamTracker.getTeamSize(%count,1);				

	%found="";
	for(%count=0;%count<%players;%count++)
	{
		%indexname=PlayerList.getNameByIndex(%count);
		%compname=trim(StripMLControlChars(%indexname));
		%expr=trim(%expr);
		if( ismatch(%compname,%expr) )
		{
			%clientid=PlayerList.getIDByIndex(%count);
			if(%clientid>0)
				%found = %found @ %clientid @ " ";	
		}
	}
	return(%found);
}

function ChatVoteKick::GetPlayersInfo(%this,%clients,%precursor,%loguse)
{
	// Returns player info on one client or more whose clientid's are specified in clients
	// i.e. "1234 1235 1236"

	%clients=trim(%clients);
	%myinfoline="\t";
	

	%clients = nextToken(%clients,clientid," ");

	while(%clientid !$= "")
	{	
		if(%loguse)
		{
			%infoline=stripmlcontrolchars(%precursor);
			%infoline=%infoline SPC "name:" SPC stripmlcontrolchars(PlayerList.getNameByID(%clientid));
			%infoline=%infoline SPC "guid:" SPC PlayerList.getGUIDByID(%clientid);
			%infoline=%infoline SPC "team:" SPC PlayerList.getTeamByID(%clientid);
			%infoline=%infoline SPC "sco:" SPC PlayerList.getScoreByID(%clientid);
			%infoline=%infoline SPC "net:" SPC PlayerList.getNetInfoByID(%clientid);
			%flags = PlayerList.getFlagsByID(%clientid);
			if(%flags & $PLAYER_SMURF) %infoline=%infoline SPC "smurf";
			if(%flags & $PLAYER_SUPERADMIN) %infoline=%infoline SPC "super";
			if(%flags & $PLAYER_ADMIN) %infoline=%infoline SPC "admin";
			if(%flags & $PLAYER_AI) %infoline=%infoline SPC "bot";
		}
		else
		{
			%infoline=%precursor;
			%infoline=%infoline SPC "\c4name\cr:" SPC PlayerList.getNameByID(%clientid);
			%infoline=%infoline SPC "\c4guid\cr:" SPC PlayerList.getGUIDByID(%clientid);
			%infoline=%infoline SPC "\c4team\cr:" SPC PlayerList.getTeamByID(%clientid);
			%infoline=%infoline SPC "\c4sco\cr:" SPC PlayerList.getScoreByID(%clientid);
			%infoline=%infoline SPC "\c4net\cr:" SPC PlayerList.getNetInfoByID(%clientid);
			%flags = PlayerList.getFlagsByID(%clientid);
			if(%flags & $PLAYER_SMURF) %infoline=%infoline SPC "\c5smurf\cr";
			if(%flags & $PLAYER_SUPERADMIN) %infoline=%infoline SPC "\c5super\cr";
			if(%flags & $PLAYER_ADMIN) %infoline=%infoline SPC "\c5admin\cr";
			if(%flags & $PLAYER_AI) %infoline=%infoline SPC "\c5bot\cr";
		}
		%myinfoline=%myinfoline @ %infoline;

		%clients = nextToken(%clients,clientid," ");
		if(%clientid !$= "")
		{
			if(%loguse)
				%myinfoline = %myinfoline @ "\n\t";
			else
				%myinfoline = %myinfoline @ "\n";
		}
	}
	return(%myinfoline);
}

function ChatVoteKick::help(%this,%text)
{
			if(%text $= "info")
				addmessagehudline("!\c4info\cr <name>: print GUID etc. matching <name>");
			else if (%text $= "kick")
				addmessagehudline("!\c4kick\cr <name>: (vote to) kick matching <name>");
			else if (%text $= "ban")
				addmessagehudline("!\c4ban\cr <name> : bans <name>");
			else if (%text $= "forceobs")
				addmessagehudline("!\c4forceobs\cr <name>: force <name> to observer");
			else if (%text $= "forceteam")
				addmessagehudline("!\c4forceteam\cr <team> <name> : force <name> to team number <team>");
			else if (%text $= "forceswitch")
				addmessagehudline("!\c4forceswitch\cr <name> : force <name> to opposite team");
			else if (%text $= "wildcards")
				addmessagehudline("\c1wildcards: all commands accept * and ? characters in names\cr");
			else if (%text $= "switches")
			{
				addmessagehudline("\c1switches: /f - forces the command on multiple users.  place at end of command line\cr");
				addmessagehudline("\c1\t # the # character denotes the rest of the line for a comment for log purposes\cr");
			}
			else if (%text $= "log")
				addmessagehudline("!\c4log\cr <on|off> enables or disables logging to chatvotekick.log in gamedata/base, with no argument prints logging status");
			else if (%text $= "version")
				addmessagehudline("\c1" @ ChatVoteKick.name SPC ChatVoteKick.VersionString SPC "by " @ ChatVoteKick.author @ "\cr");
			else
			{
				addmessagehudline("Chat Vote Kick.  \c1!help <command or category>\cr");
				addmessagehudline("commands: \c1kick info ban forceobs forceteam forceswitch log\cr");
				addmessagehudline("categories: \c1version wildcards switches\cr");
			}

}

function ChatVoteKick::checkforce(%this,%text)
{
	// checks for /f (force) in %text command, returns TRUE if present,
	// else returns false
	if( strstr(%text,"/f") != -1)
		return true;
	else
		return false;
}

function ChatVoteKick::checkcomment(%this,%text)
{
	// checks for # comment character in %text, returns it if present, else returns blank.
	%commentpos = strstr(%text,"#");
	if(%commentpos == -1)
		%returnstring = "";
	else
		%returnstring = getSubStr(%text,%commentpos,strlen(%text)-%commentpos);
	return %returnstring;
}

function ChatVoteKick::stripbare(%this,%text)
{
	// strips /f flag and # comments from %text if present.

	// remove /f
	%pos = strstr(%text,"/f");
	if(%pos != -1)
		%text = getsubstr(%text,0,%pos) @ getsubstr(%text,%pos+2,strlen(%text)-(%pos+2));

	// remove #
	%pos = strstr(%text,"#");
	if(%pos != -1)
		%text = getsubstr(%text,0,%pos);

	return %text;
}

function ChatVoteKick::LogEntry(%this,%text,%found,%comment,%forceflag,%precursor)
{
	// this function logs the result of commands involving users with a date/time stamp
	// purpose is so that admin users can log bans/kicks, and regular users can also
	// see GUID's etc. in case of llamas

	if($pref::ChatVoteKick::log)
	{
		%mystring=formatTimeString("hh:nn:ss A") SPC %text SPC %comment;

		if(%forceflag)
			%mystring = %mystring SPC "/f forced";

		%mystring = %mystring @ "\n";
		
		%mystring = %mystring @ ChatVoteKick.GetPlayersInfo(%found,%precursor,true);

		// FileObject::append(%this, %filename, %text)	
		// string is ready, time to write to log!
	
		%filename = ChatVoteKick.logfile;

		new fileObject( "CVKLogFile" );

		if( ! CVKLogFile.openForRead(%filename) )
		{
			error("ChatVoteKick::LogEntry: trying to create log file");
			if(! CVKLogFile.openForWrite(%filename))
			{
				error("ChatVoteKick::LogEntry: cannot create log file");
				return;
			}
			CVKLogFile.writeline(ChatVoteKick.VersionString @ ": Start Log file " @ formatTimeString("hh:nn:ss A") @ "\n");
			CVKLogFile.close();
		}

		if( ! CVKLogFile.append( %filename, %mystring ) )
		{
			error("ChatVoteKick::LogEntry: cannot append to file");
		}

		// close the file and delete the file pointer.
		CVKLogFile.close();
		CVKLogFile.delete();
	}
}

function ChatVoteKick::LogToggle(%this,%command)
{
	%command=strlwr(%command);
	if(%command $= "on")
		$pref::ChatVoteKick::log = true;
	else if (%command $= "off")
		$pref::ChatVoteKick::log = false;
	else
		addmessagehudline("usage: !log <on|off>");

	if($pref::ChatVoteKick::log)
		addmessagehudline("Chat Vote Kick: Logging enabled");
	else
		addmessagehudline("Chat Vote Kick: Logging disabled");
}

function ChatVoteKick::EchoExtra(%this,%text,%found,%comment,%forceflag)
{
	// this function basically prints in the message hud the comment or the forced
	// command status if either is present
	// purpose is so that if you have logging set up with a third party script
	// you can look back and see your comment/forced status.
	// this does NOT affect logging

	%mystring="";

	if(%forceflag)
		%mystring = %mystring @ "/f forced ";
	if(%comment !$= "")
		%mystring = %mystring @ %comment;
	if(%mystring !$= "")
		addmessagehudline(%mystring); 

}

package ChatVoteKick
{

function MessageHud_Edit::eval(%this)
{
        %text = trim(%this.getValue());

	if (getSubStr(%text,0,1) $= "!" ) 
	{
            
	    %forceflag=ChatVoteKick.checkforce(%text);
	    %comment=ChatVoteKick.checkcomment(%text);
	    %text=ChatVoteKick.stripbare(%text);
	    %text = trim(%text);
            %text = nextToken(%text,command," ");
	    %text = trim(%text);
	    %command=strupr(%command);
            
            switch$(%command)
		{
		case "!HELP":
			ChatVoteKick.Help(strlwr(%text));
		case "!LOG":
			ChatVoteKick.LogToggle(%text);
		case "!INFO":
			%found=ChatVoteKick.GetMatching(%text);

			if(%found $= "")
				addMessageHudLine("!\c4info\cr" SPC %text @ ": none found");
			else
			{
				%infoline=ChatVoteKick.GetPlayersInfo(%found,"!\c4info\cr " @ %text @ ": ");
				ChatVoteKick.LogEntry(%text,%found,%comment,%forceflag,"!\c4info\cr " @ %text @ ": ");
				addmessageHudLine(%infoline);
			}
		case "!KICK":
			%found=ChatVoteKick.GetMatching(%text);

			if(%found $= "")
				addMessageHudLine("!\c4kick\cr" SPC %text @ ": none found");
			else
			{
				%infoline=ChatVoteKick.GetPlayersInfo(%found,"!\c4kick\cr " @ %text @ ": ");
				addmessageHudLine(%infoline);
				ChatVoteKick.EchoExtra(%text,%found,%comment,%forceflag);
				ChatVoteKick.LogEntry(%text,%found,%comment,%forceflag,"!\c4kick\cr " @ %text @ ": ");
				ChatVoteKick.KickPlayers(%found,%forceflag);
			}
		case "!BAN":
			%found=ChatVoteKick.GetMatching(%text);

			if(%found $= "")
				addMessageHudLine("!\c4ban\cr" SPC %text @ ": none found");
			else
			{
				%infoline=ChatVoteKick.GetPlayersInfo(%found,"!\c4ban\cr " @ %text @ ": ");
				addmessageHudLine(%infoline);
				ChatVoteKick.EchoExtra(%text,%found,%comment,%forceflag);
				ChatVoteKick.LogEntry(%text,%found,%comment,%forceflag,"!\c4ban\cr " @ %text @ ": ");
				ChatVoteKick.BanPlayers(%found,%forceflag);	
			}
		case "!FORCEOBS":
			%found=ChatVoteKick.GetMatching(%text);

			if(%found $= "")
				addMessageHudLine("!\c4forceobs\cr" SPC %text @ ": none found");
			else
			{
				%infoline=ChatVoteKick.GetPlayersInfo(%found,"!\c4forceobs\cr " @ %text @ ": ");
				addmessageHudLine(%infoline);
				ChatVoteKick.EchoExtra(%text,%found,%comment,%forceflag);
				ChatVoteKick.LogEntry(%text,%found,%comment,%forceflag,"!\c4forceobs\cr " @ %text @ ": ");
				ChatVoteKick.ForceObserver(%found,%forceflag);	
			}
		case "!FORCETEAM":
			%text = nextToken(%text,team," ");
			%found=ChatVoteKick.GetMatching(%text);
			
			if(%found $= "")
				addMessageHudLine("!\c4forceteam\cr" SPC %text @ ": none found");
			else
			{
				%infoline=ChatVoteKick.GetPlayersInfo(%found,"!\c4forceteam\cr " @ %text @ ": ");
				addmessageHudLine(%infoline);
				ChatVoteKick.EchoExtra(%text,%found,%comment,%forceflag);
				ChatVoteKick.LogEntry(%text,%found,%comment,%forceflag,"!\c4forceteam\cr " @ %text @ ": ");
				ChatVoteKick.ForceTeam(%found,%team,%forceflag);	
			}
		case "!FORCESWITCH":
			%found=ChatVoteKick.GetMatching(%text);
			
			if(%found $= "")
				addMessageHudLine("!\c4forceswitch\cr" SPC %text @ ": none found");
			else
			{
				%infoline=ChatVoteKick.GetPlayersInfo(%found,"!\c4forceswitch\cr " @ %text @ ": ");
				addmessageHudLine(%infoline);
				ChatVoteKick.EchoExtra(%text,%found,%comment,%forceflag);
				ChatVoteKick.LogEntry(%text,%found,%comment,%forceflag,"!\c4forceswitch\cr " @ %text @ ": ");
				ChatVoteKick.ForceTeamSwitch(%found,%forceflag);	
			}		
        	default:
	        	parent::eval(%this);
		}
            MessageHud.close();

        }
	else
            parent::eval(%this);	

}

};

activatepackage(ChatVoteKick);

